/*
 * Lista_jednokierunkowa.c
 *
 * Created: 2012-08-19 12:59:35
 *  Author: tmf
 */ 

#include <stdlib.h>
#include <stdbool.h>

typedef int node_data;   //Domylnie lista przechowuje wartoci o typie int

struct node 
{
	node_data data;      //Pole danych
	struct node *next;   //Wskanik do nastpnego wza
};

void sll_append(struct node **, node_data);
bool sll_delete(struct node **, node_data);
struct node *sll_getnode(struct node *q, int n);
int sll_count(struct node *);

void sll_append(struct node **q, node_data num)
{
	struct node *temp = *q,*r;
	if(*q==NULL)   //Lista nie ma adnego elementu
	{
		temp = (struct node*)malloc(sizeof(struct node));  //Stwrz nowy wze
		temp->data=num;
		temp->next=NULL;
		*q=temp;   //Bdzie on pierwszym elementem listy
	} else
	{ 
		while(temp->next !=NULL) temp=temp->next;  //Znajd ostatni element
		r = (struct node*)malloc(sizeof(struct node)); //Stwrz nowy wze
		r->data=num;
		r->next=NULL;
		temp->next=r;  //Dodaj wze do listy
	}
}

bool sll_delete(struct node**q, node_data num)
{
	struct node *old,*temp=*q;
	bool flag=false;

	while(temp!=NULL) //Iteracja po elementach listy
	{
		if(temp->data==num) //Czy znaleziono waciwy element?
		{
			if(temp==*q) //Czy znaleziony element jest pierwszym elementem listy?
			 *q=temp->next; //Jeli tak to musimy zmieni referencj do pierwszego elementu
			   else old->next=temp->next; //Usuwamy element
			free(temp);  //Zwalniamy przydzielon mu pami
			flag=true;
		} else
		{
			old=temp;
			temp=temp->next;
		}
	}
	return flag;
}

int sll_count(struct node *q)
{
	int cnt=0;
	while(q!=NULL)
	{
		++cnt;
		q=q->next;
	}
	return cnt;
}

struct node *sll_getnode(struct node *q, int n)
{
	int cnt=0;

	while(q!=NULL)
	{
		if(cnt==n) return q;
		q=q->next;
		++cnt;
	}
    return NULL;
}

int main(void)
{
	struct node *sll=NULL;  //Nasz lista
	
	sll_append(&sll, 1);
	sll_append(&sll, 2);
	sll_append(&sll, 3);
	volatile int cnt=sll_count(sll);
	sll_delete(&sll, 1);
	sll_delete(&sll, 2);
	sll_delete(&sll, 3);
	cnt=sll_count(sll);
	
    while(1)
    {
        //TODO:: Please write your application code 
    }
}