/*
 * Lista_XOR.c
 *
 * Created: 2012-08-19 21:40:58
 *  Author: tmf
 */ 


#include <stdlib.h>
#include <stdbool.h>

typedef int node_data;   //Domylnie lista przechowuje wartoci o typie int

struct node 
{
	node_data data;      //Pole danych
	struct node *difptr;   //Wskanik do nastpnego/poprzedniego wza
};

struct node *xll_NextNode(struct node *Node, struct node *PrevNode);
void xll_append(struct node **, node_data);
bool xll_delete(struct node **, node_data);
struct node *xll_getnode(struct node *q, int n);
int xll_count(struct node *);

struct node *xll_NextNode(struct node *Node, struct node *PrevNode)
{
	return ((struct node*) ((int) Node->difptr ^ (int)PrevNode));
}

void xll_append(struct node **q, node_data num)
{
	if(*q==NULL)   //Lista nie ma adnego elementu
	{
		*q = (struct node*)malloc(sizeof(struct node));  //Stwrz nowy wze
		(*q)->data=num;             //Bdzie on pierwszym elementem listy
		(*q)->difptr=NULL;
	} else
	{
		struct node *next, *prev = NULL, *curr = *q;

		while(1)
		{
			next=xll_NextNode(curr, prev);
			if(next == NULL) break;
			prev=curr;
			curr=next;
		}
		next = (struct node*)malloc(sizeof(struct node)); //Stwrz nowy wze
		next->data=num;
		next->difptr=curr;    //curr^next->difptr(NULL) == curr
		curr->difptr=(struct node*) ((int)prev ^ (int)next);
	}
}

int xll_count(struct node *q)
{
	int cnt=0;
	struct node *prev=NULL, *next;
	while(q!=NULL)
	{
		++cnt;
		next=xll_NextNode(q, prev);
		prev=q;
		q=next;
	}
	return cnt;
}

struct node *xll_getnode(struct node *q, int n)
{
	int cnt=0;
	struct node *prev=NULL, *next;
	while(q!=NULL)
	{
		if(cnt==n) return q;
		next=xll_NextNode(q, prev);
		prev=q;
		q=next;
		++cnt;
	}
    return NULL;
}

bool xll_delete(struct node**q, node_data num)
{
	struct node *next, *prev=NULL, *curr=*q;

	while(curr) //Iteracja po elementach listy
	{
		if(curr->data==num)   //Czy znaleziono waciwy element?
		{
			if(curr==*q)      //Czy znaleziony element jest pierwszym elementem listy?
			{                 //Jeli tak to musimy zmieni referencj do pierwszego elementu
			 struct node *next=xll_NextNode(curr->difptr, curr);
			 *q=curr->difptr; //Wyczamy element z listy (pole difptr pierwszego to adres kolejnego ^ NULL
			 (*q)->difptr=next;
			} else
			{                       //Usuwany element ley w rodku lub na kocu listy
			 struct node *pprev= (struct node*) ((int)prev->difptr ^ (int)curr);
			 next=xll_NextNode(curr, prev);
			 prev->difptr=(struct node*) ((int)pprev ^ (int)next); //Popraw wskanik poprzedniego elementu
			 next->difptr=(struct node*) ((int)prev ^ (int)xll_NextNode(next, curr)); //Popraw wskanik kolejnego elementu
			}			  
			free(curr);  //Zwalniamy przydzielon mu pami
			return true;
		} else
		{
			next=xll_NextNode(curr, prev);  //Kolejny element listy
			prev=curr;
			curr=next;
		}
	}
	return false;
}


int main(void)
{
	struct node *xll=NULL;  //Nasz lista
	
	xll_append(&xll, 1);
	xll_append(&xll, 2);
	xll_append(&xll, 3);
	xll_append(&xll, 4);
	xll_append(&xll, 5);
	volatile int cnt=xll_count(xll);
	struct node *last=xll_getnode(xll, cnt-1);
	struct node *tmp=xll_NextNode(last, NULL);
	tmp=xll_NextNode(tmp, last);
	
	//dll_append(&tmp, 1);
	xll_delete(&xll, 1);
	cnt=xll_count(xll);
	xll_delete(&xll, 2);
	cnt=xll_count(xll);
	xll_delete(&xll, 3);
	cnt=xll_count(xll);
	xll_delete(&xll, 4);
	cnt=xll_count(xll);
	xll_delete(&xll, 5);
	cnt=xll_count(xll);
    xll_delete(&xll, 1);
	cnt=xll_count(xll);	
    while(1)
    {
        //TODO:: Please write your application code 
    }
}