/*
 * enkoder_soft.c
 *
 * Created: 2012-04-14 17:36:05
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <stdlib.h>
#include <util/delay.h>
#include "LCD.h"

#define ENC_A  1              //Piny do ktrych podczono enkoder (1-8)
#define ENC_B  2

int8_t enc_delta;

void ReadEncoder_debounce()
{
 static int8_t last;
 static uint8_t laststate;
 static uint8_t counters[2];    //Tablica zawierajca liczniki
 int8_t newpos, diff;

 uint8_t state=PORTC_IN;
 if(((state^laststate) & ENC_A) && (counters[0]==0))
 {
  counters[0]=200;
  laststate&=(~ENC_A);
  laststate|=(state & ENC_A);
 }

 if(((state^laststate) & ENC_B) && (counters[1]==0))
 {
  counters[1]=200;
  laststate&=(~ENC_B);
  laststate|=(state & ENC_B);
 }

 uint8_t przerwa=0;
 for(uint8_t c=0;c<2;c++)
  if(counters[c])
  {
   counters[c]--;
   przerwa=1;                    //Robimy opnienie tylko, jeli ktry z licznikw by !=0
  }
 if(przerwa) _delay_ms(1);

 newpos=0;
 if((PORTC_IN & ENC_A)==0) newpos=3;
 if((PORTC_IN & ENC_B)==0) newpos^=1;  // konwersja kodu Graya na binarny
 diff=last-newpos;
 if(diff & 1)
 {                              // bit 0 = krok
  last=newpos;
  enc_delta+=(diff & 2)-1;      //bit 1 - kierunek
 }
}

int8_t encode_read1()
{
 ReadEncoder_debounce();
 int8_t val=enc_delta;
 enc_delta=0;
 return val;
}

int main(void)
{
	char bufor[6];                     //Bufor na liczb
	int8_t cnt, tmpcnt;
	
	PORTCFG_MPCMASK=0b00000011;         //Zapisz now konfiguracj do pinw 0 i 1
	PORTC_PIN0CTRL=PORT_OPC_PULLUP_gc;  //Wcz podciganie do Vcc

	lcd_init();
	
    while(1)
    {
		cnt+=encode_read1();
		if(tmpcnt!=cnt)
		{
			tmpcnt=cnt;
            itoa(cnt/4, bufor, 10);           //Konwersja wartoci CNT na tekst
			lcd_cls();                        //Skasuj lcd
		    lcd_puttext(bufor);               //Wywietl warto na LCD
		}			
    }
}