/*
 * RGB_tasma.c
 *
 * Created: 2012-12-31 20:48:34
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <util/delay.h>

uint16_t red, green, blue;

void SetRGB(uint16_t ared, uint16_t agreen, uint16_t ablue)
{
	TCF0.CCA=ared;
	TCF0.CCB=agreen;
	TCF0.CCC=ablue;
}

void RGB_timer_init()
{
	PORTF.DIRSET=PIN0_bm | PIN1_bm | PIN2_bm; //Porty RGB jako wyjcie
	TCF0.CTRLB=TC_WGMODE_SS_gc  | TC0_CCAEN_bm | TC0_CCBEN_bm | TC0_CCCEN_bm; //Tryb pracy SS
	TCF0.PER=1024;  //10-bitowa gbia kolorw
	SetRGB(512, 512, 512);
	red=green=blue=1023;
	TCF0.CTRLA=TC_CLKSEL_DIV1_gc;
}

void Btn_init()
{
	PORTCFG_MPCMASK=0xFF;
	PORTD_PIN0CTRL=PORT_OPC_PULLUP_gc;  //Pullup dla wszystkich pinw portu
}

void RGB_BtnToRGB()
{
	uint8_t kbd=PORTD_IN;
	if(!(kbd & PIN0_bm)) ++red;
	if(!(kbd & PIN1_bm)) --red;
	if(!(kbd & PIN2_bm)) ++green;
	if(!(kbd & PIN3_bm)) --green;
	if(!(kbd & PIN4_bm)) ++blue;
	if(!(kbd & PIN5_bm)) --blue;
	red%=1024; green%=1024; blue%=1024;
	SetRGB(red, green, blue);
}

int main(void)
{
	Btn_init();
	RGB_timer_init();
    while(1)
    {
        RGB_BtnToRGB();
		_delay_ms(10);
    }
}