/*
 * Lista_dwukierunkowa.c
 *
 * Created: 2012-08-19 18:25:31
 *  Author: tmf
 */ 


#include <stdlib.h>
#include <stdbool.h>

typedef int node_data;   //Domylnie lista przechowuje wartoci o typie int

struct node 
{
	node_data data;      //Pole danych
	struct node *next;   //Wskanik do nastpnego wza
	struct node *prev;   //Wskanik do poprzedniego wza
};

void dll_append(struct node **, node_data);
bool dll_delete(struct node **, node_data);
struct node *dll_getnode(struct node *q, int n);
int dll_count(struct node *);

void dll_append(struct node **q, node_data num)
{
	struct node *temp = *q,*r;
	if(*q==NULL)   //Lista nie ma adnego elementu
	{
		temp = (struct node*)malloc(sizeof(struct node));  //Stwrz nowy wze
		temp->data=num;
		temp->next=NULL;
		temp->prev=NULL;  //Z pewnoci nie mamy poprzednika
		*q=temp;   //Bdzie on pierwszym elementem listy
	} else
	{ 
		while(temp->next !=NULL) temp=temp->next;  //Znajd ostatni element
		r = (struct node*)malloc(sizeof(struct node)); //Stwrz nowy wze
		r->data=num;
		r->next=NULL;
		r->prev=temp;  //Wskanik na poprzedni element
		temp->next=r;  //Dodaj wze do listy
	}
}

bool dll_delete(struct node**q, node_data num)
{
	struct node *old,*temp=*q;

	while(temp!=NULL) //Iteracja po elementach listy
	{
		if(temp->data==num) //Czy znaleziono waciwy element?
		{
			if(temp==*q) //Czy znaleziony element jest pierwszym elementem listy?
			{            //Jeli tak to musimy zmieni referencj do pierwszego elementu
			 *q=temp->next;
			 (*q)->prev=NULL;
			} else
			{
			  old->next=temp->next; //Usuwamy element
			  temp->prev=old;
			}			  
			free(temp);  //Zwalniamy przydzielon mu pami
			return true;
		} else
		{
			old=temp;
			temp=temp->next;
		}
	}
	return false;
}

int dll_count(struct node *q)
{
	int cnt=0;
	while(q!=NULL)
	{
		++cnt;
		q=q->next;
	}
	return cnt;
}

struct node *dll_getnode(struct node *q, int n)
{
	int cnt=0;

	while(q!=NULL)
	{
		if(cnt==n) return q;
		q=q->next;
		++cnt;
	}
    return NULL;
}

int main(void)
{
	struct node *dll=NULL;  //Nasz lista
	
	dll_append(&dll, 1);
	dll_append(&dll, 2);
	dll_append(&dll, 3);
	volatile int cnt=dll_count(dll);
	dll_delete(&dll, 1);
	dll_delete(&dll, 2);
	dll_delete(&dll, 3);
	cnt=dll_count(dll);
	
    while(1)
    {
        //TODO:: Please write your application code 
    }
}