/*
 * PWM_SIN8bit.c
 *
 * Created: 2012-03-17 15:02:49
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <stdbool.h>
#include <util/delay.h>

uint16_t wave[36] ={32768, 38458, 43975, 49151, 53830, 57869, 61145, 63559, 65037, 65535, 65037, 63559, 61145, 57869, 53830, 49151, 43975, 38458,
	                32768, 27077, 21560, 16384, 11705, 7666, 4390, 1976, 498, 0, 498, 1976, 4390, 7666, 11705, 16384, 21560, 27077};
	
uint8_t counter;

void Timer_init()
{
	PORTC.DIRSET=0b0000001;       //PD0 jest wyjciem OC0A
	TCC0.CTRLB=TC1_CCAEN_bm | TC_WGMODE_SS_gc;       //Odblokuj rejestr compare A, tryb single slope
	TCC0.PER=0x0FF;                //8-bitowy PWM
	TCC0.CTRLA=TC_CLKSEL_DIV1_gc;  //Preskaler 1
}

bool OSC_wait_for_rdy(uint8_t clk)
{
	uint8_t czas=255;
	while ((!(OSC.STATUS & clk)) && (--czas)) // Czekaj na ustabilizowanie si generatora
	 _delay_ms(1);
	return czas;   //false jeli generator nie wystartowa, true jeli jest ok
}

bool RC32M_en()
{
	OSC.CTRL |= OSC_RC32MEN_bm; //Wcz generator RC 32 MHz
	return OSC_wait_for_rdy(OSC_RC32MEN_bm); //Zaczekaj na jego poprawny start
}

int main(void)
{
	RC32M_en();   //Timer musi by taktowany jak najszybciej - 32 MHz
	
	CCP=CCP_IOREG_gc;
	CLK_CTRL=CLK_SCLKSEL_RC32M_gc;   //Przecz rdo zegara CPU
	
	Timer_init();
	
    while(1)
    {
		TCC0.CCABUF=wave[counter] >> 8;          //zaaduj now prbk (8-bitow)
		counter=(counter+1) % (sizeof(wave)/sizeof(wave[0]));  //licznik modulo liczba prbek
		while(TCC0.CTRLGCLR & TC0_CCABV_bm);  //Poczekaj na kolejny okres
    }
}