/*
 * LEDStrip_pilot.c
 *
 * Created: 2013-01-01 19:00:18
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <util/delay.h>

uint16_t red, green, blue;

void SetRGB(uint16_t ared, uint16_t agreen, uint16_t ablue)
{
	TCF0.CCA=ared;
	TCF0.CCB=agreen;
	TCF0.CCC=ablue;
}

void RGB_timer_init()
{
	PORTF.DIRSET=PIN0_bm | PIN1_bm | PIN2_bm; //Porty RGB jako wyjcie
	TCF0.CTRLB=TC_WGMODE_SS_gc  | TC0_CCAEN_bm | TC0_CCBEN_bm | TC0_CCCEN_bm; //Tryb pracy SS
	TCF0.PER=1024;  //10-bitowa gbia kolorw
	SetRGB(512, 512, 512);
	red=green=blue=1023;
	TCF0.CTRLA=TC_CLKSEL_DIV1_gc;
}

void Btn_init()
{
	PORTCFG_MPCMASK=0xFF;
	PORTD_PIN0CTRL=PORT_OPC_PULLUP_gc;  //Pullup dla wszystkich pinw portu
}

int main(void)
{
    while(1)
    {
        //TODO:: Please write your application code 
    }
}