/*
 * FSM.c
 *
 * Created: 2012-12-29 11:11:46
 *  Author: tmf
 */

#include <string.h>
#include <avr/pgmspace.h>
#include <calendar.h>
#include "FSM-actions.h"
#include "FSM.h"
#include "LED7seg.h"
#include "RTC.h"

uint8_t DatePos;               //Co wywietlamy na LED?
struct calendar_date tmpdt;    //Kopia dt

struct
{
	bool AlarmOn;                         //Alarm wczony?
	struct calendar_date AlarmTime;       //Ustawiony czas alarmu
} Alarm;

enum States CurrState;   //Biecy stan maszyny

void FSM_init()
{
	CurrState=St_TimeDisplay;
}

void LED_SetLED(uint8_t D32, uint8_t D21)
{
	LEDDIGITS[0]=D21%10;
	LEDDIGITS[1]=D21/10;
	LEDDIGITS[2]=D32%10;
	LEDDIGITS[3]=D32/10;
}

void ChgFunc_TimeDateDispChg(enum ActionEvents Event)
{
	if((Alarm.AlarmOn==true) && (dt.minute==Alarm.AlarmTime.minute) && (dt.hour==Alarm.AlarmTime.hour))
	LEDBLINKALL=true; else LEDBLINKALL=false;  //Jeli aktualny czas jest taki jak alarm to zasygnalizuj to

	switch(dt.second % 10)
	{
		case 0 ... 7 :  LED_SetLED(dt.hour, dt.minute);
		CurrState=St_TimeDisplay; break;
		default:       	LED_SetLED(dt.date+1, dt.month+1);
		CurrState=St_DateDisplay; break;
	}
};

void ChgFunc_TimeDateBtn1Pressed(enum ActionEvents Event)
{
	CurrState=St_Program;
	FSM_DispatchEvent(Action_Start);
};

enum RTC_Programs {PRG_Exit, PRG_SetTime, PRG_SetDate, PRG_SetAlarm, PRG_AlarmOnOff, PRG_END};
static enum RTC_Programs CurrPrg;

void ChgFunc_PrgStart(enum ActionEvents Event)
{
	LEDBLINKALL=false;  LEDBLINKDouble=false; //Jeli wywietlacz miga to wycz to
	CurrPrg=PRG_Exit;
	LEDDIGITS[3]=11; //Pusty znak
	LEDDIGITS[2]=11;
	LEDDIGITS[1]=12; //Znak P
	LEDDIGITS[0]=CurrPrg;
	if(CurrPrg==PRG_Exit) LEDDIGITS[0]=13;  //Wywietlamy specjalny symbol
};

void ChgFunc_PrgBtn1Pressed(enum ActionEvents Event)
{
	switch(CurrPrg)
	{
		case PRG_Exit:       CurrState=St_DateDisplay; break;
		case PRG_SetTime:    CurrState=St_SetTime; break;
		case PRG_SetDate:    CurrState=St_SetDate; break;
		case PRG_SetAlarm:   CurrState=St_SetAlarm; break;
		case PRG_AlarmOnOff: CurrState=St_SetAlarmOnOff; break;
		default: ;
	}
	FSM_DispatchEvent(Action_Start);
};

void ChgFunc_PrgBtn23Pressed(enum ActionEvents Event)
{
	if(Event==Action_Btn2Pressed) CurrPrg++; else CurrPrg--;
	CurrPrg=((unsigned)CurrPrg) % PRG_END;
	LEDDIGITS[0]=CurrPrg;
	if(CurrPrg==PRG_Exit) LEDDIGITS[0]=13;  //Wywietlamy specjalny symbol
};

void ChgFunc_PrgSetTimeBtn1Pressed(enum ActionEvents Event)
{
	 LEDBLINK++;
	 if(LEDBLINK==LEDDISPNO)
	 {
		 dt.second=0;
		 dt.minute=LEDDIGITS[1]*10+LEDDIGITS[0];
		 dt.hour=LEDDIGITS[3]*10+LEDDIGITS[2];
		 if(dt.hour<24)
		 {
			 uint32_t cnt=calendar_date_to_timestamp(&dt); //Zapisz nowy czas
			 RTC32_set_counter(cnt);
		     CurrState=St_Program;
		     FSM_DispatchEvent(Action_Start);  //Wychodzimy z ustawiania
		 } else LEDBLINK=2; //Niepoprawna godzina
	 }
};

void ChgFunc_PrgSetTimeBtn2Pressed(enum ActionEvents Event)
{
	uint8_t tmp=LEDDIGITS[LEDBLINK]+1;
	switch(LEDBLINK)
	{
		case 0:   tmp%=10; break;
		case 1:   tmp%=6; break;
		case 2:   tmp%=10; break;
		default:  tmp%=3;
	}
	LEDDIGITS[LEDBLINK]=tmp;
};

void ChgFunc_PrgSetTimeBtn3Pressed(enum ActionEvents Event)
{
	int8_t tmp=LEDDIGITS[LEDBLINK]-1;
	switch(LEDBLINK)
	{
		case 0:   if(tmp<0) tmp=9; break;
		case 1:   if(tmp<0) tmp=5; break;
		case 2:   if(tmp<0) tmp=9; break;
		default:  if(tmp<0) tmp=2;
	}
	LEDDIGITS[LEDBLINK]=tmp;
};

void ChgFunc_PrgSetTimeStart(enum ActionEvents Event)
{
	LEDBLINK=0; LEDBLINKDouble=false;
	uint32_t cnt=RTC32_get_counter();          //Pobierz licznik (timestamp)
	calendar_timestamp_to_date(cnt, &dt);      //Konwersja do "normalnego" zapisu czasu
	LED_SetLED(dt.hour, dt.minute);            //Wywietl czas
};

void ChgFunc_PrgSetAlarmStart(enum ActionEvents Event)
{
	LEDBLINK=0;
	LED_SetLED(Alarm.AlarmTime.hour, Alarm.AlarmTime.minute); //Wywietl czas alarmu
};

void ChgFunc_PrgSetAlarmBtn1Pressed(enum ActionEvents Event)
{
	 LEDBLINK++;
	 if(LEDBLINK==LEDDISPNO)
	 {
		 Alarm.AlarmTime.second=0;
		 Alarm.AlarmTime.minute=LEDDIGITS[1]*10+LEDDIGITS[0];
		 Alarm.AlarmTime.hour=LEDDIGITS[3]*10+LEDDIGITS[2];
		 if(Alarm.AlarmTime.hour<24)
		 {
			 Alarm.AlarmOn=true;     //Wczamy alarm
		     CurrState=St_Program;
		     FSM_DispatchEvent(Action_Start);  //Wychodzimy z ustawiania
		 } else LEDBLINK=2; //Niepoprawna godzina alarmu
	 }
};

void AlarmOnOffDisp(bool state)
{
	LEDDIGITS[3]=11;
	if(state)
	{      //Wywietl On
		LEDDIGITS[2]=11;
		LEDDIGITS[1]=0;
		LEDDIGITS[0]=14;

	} else
	{      //Wywietl Off
		LEDDIGITS[2]=0;
		LEDDIGITS[1]=15;
		LEDDIGITS[0]=15;
	}
}

void ChgFunc_PrgSetAlarmOnOffStart(enum ActionEvents Event)
{
	AlarmOnOffDisp(Alarm.AlarmOn);
};

void ChgFunc_PrgSetAlarmOnOffExit(enum ActionEvents Event)
{
	CurrState=St_Program;
	FSM_DispatchEvent(Action_Start);
};

void ChgFunc_PrgSetAlarmOnOff(enum ActionEvents Event)
{
	Alarm.AlarmOn=!Alarm.AlarmOn;
	AlarmOnOffDisp(Alarm.AlarmOn);
};

void ChgFunc_PrgSetDateBtn1Pressed(enum ActionEvents Event)
{
	LEDBLINK+=2;
	if(LEDBLINK>=LEDDISPNO)
	{
		if(DatePos)
		{
			tmpdt.date=LEDDIGITS[3]*10 + LEDDIGITS[2] - 1;
			uint32_t cnt=RTC32_get_counter();

			calendar_timestamp_to_date(cnt, &dt);
			dt.year=tmpdt.year; dt.month=tmpdt.month; dt.date=tmpdt.date;
			RTC32_set_counter(calendar_date_to_timestamp(&dt)); //Uaktualnij licznik czasu
			CurrState=St_Program;
		    FSM_DispatchEvent(Action_Start);  //Wychodzimy z ustawiania
		} else
		{
			DatePos++;
			LEDBLINK=2;
			tmpdt.year=2000+LEDDIGITS[0] + LEDDIGITS[1]*10; //Nowy rok
			tmpdt.month=LEDDIGITS[2] + LEDDIGITS[3]*10 - 1; //i miesic

			LED_SetLED(tmpdt.date+1, tmpdt.month+1);
		}
	}
}

void ChgFunc_PrgSetDateBtn2Pressed(enum ActionEvents Event)
{
	uint8_t tmp=LEDDIGITS[LEDBLINK] + LEDDIGITS[LEDBLINK+1]*10+1;

	if(LEDBLINK==2)
	  switch(DatePos)
	  {
		case 0: tmp=(tmp-1)%12 + 1; break;
		case 1: tmpdt.date=tmp-1;
		        if(calendar_is_date_valid(&tmpdt)==false) {tmp=1; tmpdt.date=0;};
				break;
	  };
	if((LEDBLINK==0) && (DatePos==0)) tmp%=100;

	LEDDIGITS[LEDBLINK]=tmp%10;
	LEDDIGITS[LEDBLINK+1]=tmp/10;
}

void ChgFunc_PrgSetDateStart(enum ActionEvents Event)
{
	LEDBLINK=0; LEDBLINKDouble=true; DatePos=0;
	memcpy(&tmpdt, &dt, sizeof(dt));     //Utwrz kopi danych
	LED_SetLED(dt.month+1, dt.year-2000);
}

const StChgFunc TransTable[St_END][Action_END] PROGMEM = {
	[St_TimeDisplay][Action_TimerTick]=ChgFunc_TimeDateDispChg,
	[St_TimeDisplay][Action_Btn1Pressed]=ChgFunc_TimeDateBtn1Pressed,
	[St_TimeDisplay][Action_Start]=ChgFunc_TimeDateDispChg,

	[St_DateDisplay][Action_TimerTick]=ChgFunc_TimeDateDispChg,
	[St_DateDisplay][Action_Btn1Pressed]=ChgFunc_TimeDateBtn1Pressed,
	[St_DateDisplay][Action_Start]=ChgFunc_TimeDateDispChg,

	[St_Program][Action_Btn1Pressed]=ChgFunc_PrgBtn1Pressed,
	[St_Program][Action_Btn2Pressed]=ChgFunc_PrgBtn23Pressed,
	[St_Program][Action_Btn3Pressed]=ChgFunc_PrgBtn23Pressed,
	[St_Program][Action_Start]=ChgFunc_PrgStart,

	[St_SetTime][Action_Btn1Pressed]=ChgFunc_PrgSetTimeBtn1Pressed,
	[St_SetTime][Action_Btn2Pressed]=ChgFunc_PrgSetTimeBtn2Pressed,
	[St_SetTime][Action_Btn3Pressed]=ChgFunc_PrgSetTimeBtn3Pressed,
	[St_SetTime][Action_Start]=ChgFunc_PrgSetTimeStart,

	[St_SetDate][Action_Btn1Pressed]=ChgFunc_PrgSetDateBtn1Pressed,
	[St_SetDate][Action_Btn2Pressed]=ChgFunc_PrgSetDateBtn2Pressed,
	[St_SetDate][Action_Start]=ChgFunc_PrgSetDateStart,

	[St_SetAlarm][Action_Btn1Pressed]=ChgFunc_PrgSetAlarmBtn1Pressed,
	[St_SetAlarm][Action_Btn2Pressed]=ChgFunc_PrgSetTimeBtn2Pressed,
	[St_SetAlarm][Action_Btn3Pressed]=ChgFunc_PrgSetTimeBtn3Pressed,
	[St_SetAlarm][Action_Start]=ChgFunc_PrgSetAlarmStart,

	[St_SetAlarmOnOff][Action_Start]=ChgFunc_PrgSetAlarmOnOffStart,
	[St_SetAlarmOnOff][Action_Btn1Pressed]=ChgFunc_PrgSetAlarmOnOffExit,
	[St_SetAlarmOnOff][Action_Btn2Pressed]=ChgFunc_PrgSetAlarmOnOff,
	[St_SetAlarmOnOff][Action_Btn3Pressed]=ChgFunc_PrgSetAlarmOnOff
	};

void FSM_DispatchEvent(enum ActionEvents event)
{
	StChgFunc func=(StChgFunc)pgm_read_word(&TransTable[CurrState][event]);
	if(func) (*func)(event);
}