/*
 * Pooling.c
 *
 * Created: 2013-01-19 10:51:51
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <avr/pgmspace.h>
#include "usart.h"

void USART_init()
{
	PORTC_OUTSET=PIN3_bm;
	PORTC_DIRSET=PIN3_bm;                          //Pin TxD musi by wyjciem
	USARTC0.CTRLB=USART_TXEN_bm | USART_RXEN_bm;   //Wcz nadajnik USART
	USARTC0.CTRLC=USART_CHSIZE_8BIT_gc;            //Ramka 8 bitw, bez parzystoci, 1 bit stopu
	usart_set_baudrate(&USARTC0, 9600, F_CPU);
}

int main(void)
{
	USART_init();
	
    while(1)
    {
        if(USARTC0_STATUS & USART_RXCIF_bm)
		{
			uint8_t data=USARTC0_DATA;
			switch(data)
			{
				case 'n' : USART_send_F(&USARTC0, PSTR("Pozdrowienia z XMEGA\n\r")); break;
				default: ;
			}
		}			
    }
}