/*
 * DateTime.c
 *
 * Created: 2012-03-02 22:20:53
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/atomic.h>
#include <calendar.h>

volatile uint32_t timestamp;
struct calendar_date dt = {0, 0, 0, 0, 0, 2012};              //Zmienna przechowuje czas i dat w klasycznym formacie
	
ISR(RTC_OVF_vect)
{
	timestamp++;                      //Zwiksz licznik sekund
}

static inline void wait_for_RTC_sync()
{
	while(RTC.STATUS & RTC_SYNCBUSY_bm);     //Czekaj a flaga SYNCBUSY si wyzeruje
}

void RTC_init()
{
	OSC_XOSCCTRL=OSC_XOSCSEL_32KHz_gc;	//Wybierz kwarc zegarkowy
	OSC_CTRL|=OSC_XOSCEN_bm;            //Odblokuj oscylator
	
	CLK_RTCCTRL=CLK_RTCSRC_TOSC32_gc;    //Zewntrzny kwarc 32768 Hz
	CLK_RTCCTRL|=CLK_RTCEN_bm;           //Wcz wybrany oscylator dla RTC

	RTC.PER=32768;                       //W cigu sekundy mamy 32768 okresw zegara
	RTC.CNT=0;
	wait_for_RTC_sync();                 //Poczekaj na synchronizacj rejestrw CNT i PER
	
	RTC.INTCTRL=RTC_OVFINTLVL_LO_gc;     //Wcz przerwania przepenienia, nadajc im niski priorytet
	wait_for_RTC_sync(); 
	PMIC_CTRL=PMIC_LOLVLEN_bm;           //Odblokuj przerwania niskiego poziomu
	
	RTC.CTRL=RTC_PRESCALER_DIV1_gc;      //Preskaler 1 - brak podziau	
}

int main(void)
{
	RTC_init();                          //Zainicjuj ukad RTC	
	sei();
	
	uint32_t tmp=calendar_date_to_timestamp(&dt);  //Konwersja daty na marker czasu
	ATOMIC_BLOCK(ATOMIC_RESTORESTATE)
	{
		timestamp=tmp;                  //Zapis do timestamp te musi by atomowy
	}
	
    while(1)
    {
		ATOMIC_BLOCK(ATOMIC_RESTORESTATE)
		{
			tmp=timestamp;
		}			
        calendar_timestamp_to_date(tmp, &dt);  //Zamie marker czasowy na posta czyteln dla czowieka
    }
}