/*
 * OSCFAIL.c
 *
 * Created: 2012-05-12 12:00:41
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdbool.h>
#include <util/delay.h>

ISR(OSC_XOSCF_vect)
{
	PORTE.OUT=0x0F;    //Zmie sposb migania diod
}

bool OSC_wait_for_rdy(uint8_t clk)
{
	uint8_t czas=255;
	while ((!(OSC.STATUS & clk)) && (--czas)) // Czekaj na ustabilizowanie si generatora
	_delay_ms(1);
	return czas;   //false jeli generator nie wystartowa, true jeli jest ok
}

bool EXCLK_en()
{
	OSC_CTRL |= OSC_XOSCEN_bm;
	return OSC_wait_for_rdy(OSC_XOSCEN_bm);
}

void SelectPLL(OSC_PLLSRC_t src, uint8_t mult)
{
	mult&=OSC_PLLFAC_gm;
	OSC.PLLCTRL=src | mult;              //Ustaw rdo i mnonik PLL
	OSC.CTRL|=OSC_PLLEN_bm;				 //Wcz ukad PLL
	OSC_wait_for_rdy(OSC_PLLRDY_bm);     //Poczekaj na ustabilizowanie si PLL
}


int main(void)
{
	EXCLK_en();                         //Odblokuj zegar zewntrzny doprowadzony do XTAL1
	SelectPLL(OSC_PLLSRC_XOSC_gc, 10);   //FXTAL1=4 MHz * 8 = 32 MHz

	CPU_CCP=CCP_IOREG_gc;            //Odblokuj zmian konfiguracji
	CLK.CTRL=CLK_SCLKSEL_PLL_gc;     //Wybierz PLL

    asm volatile ("nop");            //Niezbdne dla zachowania timingw dostpu do portu

    CPU_CCP=CCP_IOREG_gc;            //Odblokuj zmian konfiguracji
    OSC.XOSCFAIL=OSC_XOSCFDEN_bm;    //Wcz monitorowanie zegara

	PORTE.DIR=0xFF;    //Wszystkie piny s wyjciem

    while(1)
    {
        PORTE.OUTTGL=0xFF;
		_delay_ms(100);             //Opnienie 100ms dla FCPU=32 MHz, dla 2MHz=1,6s
    }
}