/*
 * PulseLengthEncoding.c
 *
 * Created: 2013-02-10 16:34:30
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <avr/interrupt.h>

#define F_CARRIER  38000   //Czstotliwo fali nonej
#define PULSE_LOW  540     //Dugo impulsu dla bitu 0 w mikrosekundach
#define PULSE_HIGH 1100    //Dugo impulsu dla bitu 1 w mikrosekundach
#define PULSE_SPACE 540    //Dugo przerwy pomidzy bitami w mikrosekundach

uint8_t IR_value=0b11001010;

ISR(TCC1_CCA_vect)
{
	enum CCA_State {St_Start, St_Space};
	static enum CCA_State State=St_Start;
	
	switch(State)
	{
		case St_Start: if(IR_value & 1) TCC1_CCA=PULSE_HIGH; else TCC1_CCA=PULSE_LOW;
		               TCC0_CTRLB|=TC0_CCDEN_bm;  //Wcz modulacj
		               State=St_Space;
		               break;
		case St_Space: TCC1_CCA=PULSE_SPACE;
		               TCC0_CTRLB&=~TC0_CCDEN_bm;  //Wcz modulacj
		               if(IR_value & 1) {IR_value>>=1; IR_value|=0x80;} else {IR_value>>=1;}
		               State=St_Start;
		               break;
	}
	TCC1_CNT=0;
}

void wave_init()
{
	TCC0.PER=F_CPU/F_CARRIER -1;       //Ustaw czstotliwo nonej
	TCC0.CCD=TCC0.PER/2;               //Wypenienie mniej wicej 50%
	TCC0.CTRLB=TC_WGMODE_SINGLESLOPE_gc;
	TCC0.CTRLA=TC_CLKSEL_DIV1_gc;    //Wcz timer
	
	TCC1.INTCTRLB=TC_CCAINTLVL_LO_gc;  //Wcz przerwanie porwnania
	TCC1.CTRLA=TC_CLKSEL_DIV2_gc;      //Stan zmienia si co 1 mikrosekund
	PMIC_CTRL=PMIC_LOLVLEN_bm;         //Odblokuj przerwania

	PORTC.DIRSET=0b00001000;       //PC3 jest wyjciem
	PORTC.OUTCLR=0b00001000;       //Domylnie w stanie 0
}

int main(void)
{
	wave_init();
	sei();
	
    while(1)
    {
        //TODO:: Please write your application code 
    }
}