/*
 * SlavePkt.c
 *
 * Created: 2013-02-16 16:41:42
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <util/crc16.h>
#include <stddef.h>               //Tu jest makro offsetof
#include "usart.h"
#include "RingBuffer.h"
#include <avr/interrupt.h>
#include <stdio.h>

#define PKT_HEADER  0xFF  //Nagwek - znak wyrniajcy pocztek pakietu

typedef struct
{
	uint8_t  Header;     //Nagwek pakietu
	uint8_t  Addr;       //Adres urzdzenia
	uint8_t  Len;        //Dugo pola danych
	char     Data[0];    //Pole danych o zmiennej dugoci
	uint16_t CRC16;      //CRC caego pakietu
} Pakiet;

CircBuffer recBuf;

#define MAX_PKTLEN 50      //Maksymalna dugo odbieranego pakietu

ISR(USARTF0_RXC_vect)
{
	cb_Add(&recBuf, USARTF0_DATA);
}

bool isPacket(uint8_t *pkt, CircBuffer *recbuf)
{
	bool ret=false;
	if(recbuf->Count>sizeof(Pakiet))  //Jeli odebralimy mniej bajtw ni dugo nagwka to z pewnoci nie mamy kompletnego pakietu
	{
		pkt[0]=cb_Read(recbuf);
		if(pkt[0]==PKT_HEADER)             //Sprawdzamy nagwek
		{
			uint16_t crc=_crc_xmodem_update(0xffff, pkt[0]);   //Inicjujemy CRC
            uint8_t len=0;
			for(uint8_t pos=1; pos<(len+sizeof(Pakiet)); pos++)
			{
				pkt[pos]=cb_Read_Block(recbuf);
				if(pos==offsetof(Pakiet, Len)) len=pkt[pos];
				crc=_crc_xmodem_update(crc, pkt[pos]);
		    }
		    if(crc==0) ret=true;
		}
	}
	return ret;
}

void USART_rec_init()
{
	USARTF0.CTRLB=USART_RXEN_bm;         //Wcz odbiornik USART
	USARTF0.CTRLC=USART_CHSIZE_8BIT_gc;  //Ramka 8 bitw, bez parzystoi, 1 bit stopu
	usart_set_baudrate(&USARTF0, 1800, F_CPU);
	PORTF_PIN2CTRL|=PORT_OPC_PULLUP_gc;  //Wyjcie odbiornika jest typu OC
	USARTF0.CTRLA=USART_RXCINTLVL_LO_gc; //Odblokuj przerwania odbiornika
	PMIC_CTRL|=PMIC_LOLVLEN_bm;          //Odblokuj przerwanie niskiego poziomu
}

void USART_PC_init()
{
	USARTC0.CTRLB=USART_TXEN_bm;         //Wcz nadajnik USART
	USARTC0.CTRLC=USART_CHSIZE_8BIT_gc;  //Ramka 8 bitw, bez parzystoci, 1 bit stopu
	usart_set_baudrate(&USARTC0, 9600, F_CPU);
	PORTC_OUTSET=PIN3_bm;
	PORTC_DIRSET=PIN3_bm;  //Pin TxD musi by wyjciem w stanie wysokim
}

int main(void)
{
	char strbuf[60];
	uint8_t bufor[MAX_PKTLEN];
	Pakiet *pkt=(Pakiet*)bufor;
	
	USART_rec_init();
	USART_PC_init();
	sei();
	while(1)
	{
		if(isPacket(bufor, &recBuf)) 
		 {
			 sprintf(strbuf, "Adres: %d, dugosc: %d bajtow, dane:", pkt->Addr, pkt->Len);
			 USART_send(&USARTC0, strbuf);
			 USART_send(&USARTC0, pkt->Data);
		 }			 
	}
}
