/*
 * MEM_IO1.c
 *
 * Created: 2012-03-21 15:38:26
 *  Author: tmf
 */ 


#include <avr/io.h>

volatile uint8_t src[10]={1, 2, 3, 4, 5, 6, 7, 8, 9, 10};

int main(void)
{
	PORTE.DIR=0xFF; //Port E bdzie wyjciem (tam s podczone diody)
	DMA.CTRL=DMA_ENABLE_bm;  //Odblokuj kontroler DMA, round robin, bez bouble buffering
	
	//Kopiuj src do PORTE.OUT
	DMA.CH0.ADDRCTRL=DMA_CH_SRCRELOAD_BLOCK_gc | DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTDIR_FIXED_gc | DMA_CH_DESTRELOAD_BURST_gc; //Zwikszamy adres rda, adres przeznaczenia stay, reload adresu co blok
	DMA.CH0.TRFCNT=sizeof(src);                 //Blok ma dugo tablicy src
	DMA.CH0.SRCADDR0=(uint16_t)&src & 0xFF;
	DMA.CH0.SRCADDR1=(uint16_t)&src >>8;
	DMA.CH0.SRCADDR2=0;                        //rdem danych jest tablica src
	DMA.CH0.DESTADDR0=(uint16_t)&PORTE.OUT & 0xFF;
	DMA.CH0.DESTADDR1=(uint16_t)&PORTE.OUT >> 8;
	DMA.CH0.DESTADDR2=0;                       
	DMA.CH0.CTRLA=DMA_CH_ENABLE_bm | DMA_CH_TRFREQ_bm | DMA_CH_BURSTLEN_1BYTE_gc;  //Kana 0 dugo transferu 1 bajt, start manualny
	while(DMA.CH0.CTRLA & DMA_CH_ENABLE_bm);  //Zaczekaj na koniec transferu
	
    while(1) {}
}