/*
 * RingBuffer.c
 *
 * Created: 2012-09-09 21:58:47
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <util/atomic.h>
#include <stdbool.h>

#define CB_MAXTRANS  10         //Maksymalna liczba elementw bufora

typedef uint8_t CB_Element;     //Typ elementw w buforze

typedef struct
{
	CB_Element elements[CB_MAXTRANS]; //Elementy bufora
	uint8_t Beg;                       //Pierwszy element bufora
	uint8_t Count;                     //Liczba elementw w buforze
} CircBuffer;

static inline bool cb_IsFull(CircBuffer *cb)
{
	return cb->Count == CB_MAXTRANS;
}

static inline bool cb_IsEmpty(CircBuffer *cb)
{
	return cb->Count == 0;
}

bool cb_Add(CircBuffer *cb, CB_Element elem)
{
	ATOMIC_BLOCK(ATOMIC_RESTORESTATE)
	{
		if(cb_IsFull(cb)) return false;         //Czy jest miejsce w kolejce?
		uint8_t end = (cb->Beg + cb->Count) % CB_MAXTRANS;
		cb->elements[end] = elem;              //Dodaj transakcj
		++cb->Count;                           //Liczba elementw w buforze
	}
	return true;      //Wszystko ok
}

CB_Element cb_Read(CircBuffer *cb)
{
	CB_Element elem;
	ATOMIC_BLOCK(ATOMIC_RESTORESTATE)
	{
		if(cb_IsEmpty(cb)) return 0;       //Bufor pusty, nie mona zwrci elementu
		elem = cb->elements[cb->Beg];
		cb->Beg = (cb->Beg + 1) % CB_MAXTRANS;
		-- cb->Count;                        //Zmniejszamy liczb elementw pozostaych
	}		                                 //w buforze
	return elem;
}

static CircBuffer cb_Buffer;         //Instancja bufora koowego

int main(void)
{
	cb_Add(&cb_Buffer, 1);
	cb_Add(&cb_Buffer, 2);
	cb_Add(&cb_Buffer, 3);
	cb_Add(&cb_Buffer, 4);
	volatile static CB_Element x;  //Jak zwykle volatile, aby utrudni prac optymalizatorowi
	x=cb_Read(&cb_Buffer);
	x=cb_Read(&cb_Buffer);
	x=cb_Read(&cb_Buffer);
	x=cb_Read(&cb_Buffer);
	x=cb_Read(&cb_Buffer);
	
    while(1)
    {
        //TODO:: Please write your application code 
    }
}