/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.signalelement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import nl.lxtreme.ols.api.data.Channel;
import nl.lxtreme.ols.api.data.DataSet;
import nl.lxtreme.ols.client.signaldisplay.IDataModelChangeListener;
import nl.lxtreme.ols.client.signaldisplay.signalelement.ElementGroup;
import nl.lxtreme.ols.client.signaldisplay.signalelement.ISignalElementChangeListener;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;

public final class SignalElementManager
implements IDataModelChangeListener {
    private final List<ElementGroup> groups;
    private final List<SignalElement> elements;
    private final EventListenerList eventListeners;
    private final Object lock = new Object();

    public SignalElementManager() {
        this.groups = new ArrayList<ElementGroup>();
        this.elements = new ArrayList<SignalElement>();
        this.eventListeners = new EventListenerList();
    }

    public void addChannelChangeListener(ISignalElementChangeListener aListener) {
        this.eventListeners.add(ISignalElementChangeListener.class, aListener);
    }

    public int calculateScreenHeight() {
        int height = 0;
        int spacing = UIManager.getInt("ols.signal.element.spacer.height");
        for (ElementGroup cg : this.getGroups()) {
            if (!cg.isVisible()) continue;
            for (SignalElement element : cg.getElements()) {
                if (element.isSignalGroup()) {
                    height += element.getHeight() + spacing;
                    continue;
                }
                if (element.isDigitalSignal() && cg.isShowDigitalSignals()) {
                    height += element.getHeight() + spacing;
                    continue;
                }
                if (element.isGroupSummary() && cg.isShowGroupSummary()) {
                    height += element.getHeight() + spacing;
                    continue;
                }
                if (!element.isAnalogSignal() || !cg.isShowAnalogSignal()) continue;
                height += element.getHeight() + spacing;
            }
        }
        return height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataModelChanged(DataSet aCapturedData) {
        Object object = this.lock;
        synchronized (object) {
            Channel[] newChannelList = aCapturedData.getChannels();
            int groupCount = Math.max(1, (int)Math.ceil((double)newChannelList.length / 8.0));
            int channelsPerGroup = (int)Math.ceil((double)newChannelList.length / (double)groupCount);
            this.elements.clear();
            this.groups.clear();
            for (int g = 0; g < groupCount; ++g) {
                ElementGroup group = this.addGroup("Group " + (g + 1));
                this.addSignalElement(group, SignalElement.createSignalGroupElement(group));
                for (int c = 0; c < channelsPerGroup; ++c) {
                    int channelIdx = g * channelsPerGroup + c;
                    if (newChannelList[channelIdx] == null) continue;
                    this.addSignalElement(group, SignalElement.createDigitalSignalElement(newChannelList[channelIdx], group));
                }
                this.addSignalElement(group, SignalElement.createGroupSummaryElement(group));
                this.addSignalElement(group, SignalElement.createAnalogScopeElement(group));
            }
        }
        this.fireGroupStructureChangeEvent(this.getAssignedElements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SignalElement> getAllElements() {
        ArrayList<SignalElement> result = new ArrayList<SignalElement>();
        Object object = this.lock;
        synchronized (object) {
            if (this.elements != null) {
                result.addAll(this.elements);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<SignalElement> getAssignedElements() {
        TreeSet<SignalElement> channelIndexes = new TreeSet<SignalElement>();
        Object object = this.lock;
        synchronized (object) {
            for (ElementGroup cg : this.groups) {
                channelIndexes.addAll(cg.getElements());
            }
        }
        return channelIndexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignalElement getChannelByIndex(int aChannelIndex) {
        SignalElement result = null;
        Object object = this.lock;
        synchronized (object) {
            ElementGroup cg;
            Iterator<ElementGroup> i$ = this.groups.iterator();
            while (i$.hasNext() && (result = (cg = i$.next()).getChannelByIndex(aChannelIndex)) == null) {
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ElementGroup> getGroups() {
        Collection<ElementGroup> result;
        List<ElementGroup> list = this.groups;
        synchronized (list) {
            result = Collections.unmodifiableCollection(this.groups);
        }
        return result;
    }

    public SignalElement[] getSignalElements(int aY, int aHeight, SignalElementMeasurer aMeasurer) {
        ArrayList<SignalElement> result = new ArrayList<SignalElement>();
        int yMin = aY;
        int yMax = aHeight + aY;
        int spacing = UIManager.getInt("ols.signal.element.spacer.height");
        int halfSpacing = spacing / 2;
        int yPos = 0;
        for (ElementGroup group : this.getGroups()) {
            if (!group.isVisible()) continue;
            if (yPos > yMax) break;
            for (SignalElement element : group.getElements()) {
                int height;
                if (element.isSignalGroup()) {
                    height = element.getHeight();
                    if (aMeasurer.signalElementFits(yPos, height + halfSpacing, yMin, yMax)) {
                        element.setYposition(yPos);
                        result.add(element);
                    }
                    yPos += height + spacing;
                    continue;
                }
                if (element.isDigitalSignal() && group.isShowDigitalSignals()) {
                    height = element.getHeight();
                    if (aMeasurer.signalElementFits(yPos, height + halfSpacing, yMin, yMax)) {
                        element.setYposition(yPos);
                        result.add(element);
                    }
                    yPos += height + spacing;
                    continue;
                }
                if (element.isGroupSummary() && group.isShowGroupSummary()) {
                    height = element.getHeight();
                    if (aMeasurer.signalElementFits(yPos, height + halfSpacing, yMin, yMax)) {
                        element.setYposition(yPos);
                        result.add(element);
                    }
                    yPos += height + spacing;
                    continue;
                }
                if (!element.isAnalogSignal() || !group.isShowAnalogSignal()) continue;
                height = element.getHeight();
                if (aMeasurer.signalElementFits(yPos, height + halfSpacing, yMin, yMax)) {
                    element.setYposition(yPos);
                    result.add(element);
                }
                yPos += height + spacing;
            }
        }
        return result.toArray(new SignalElement[result.size()]);
    }

    public void moveElement(SignalElement aMovedElement, ElementGroup aNewGroup, int aNewIndex) {
        if (aMovedElement == null) {
            throw new IllegalArgumentException("Moved signal element cannot be null!");
        }
        if (aNewGroup == null) {
            throw new IllegalArgumentException("New group cannot be null!");
        }
        if (aNewIndex < 0 || aNewIndex > 32) {
            throw new IllegalArgumentException("Invalid new index: " + aNewIndex + "!");
        }
        ElementGroup oldCG = aMovedElement.getGroup();
        int oldIndex = aMovedElement.getVirtualIndex();
        aNewGroup.moveChannel(aMovedElement, aNewIndex);
        this.fireChannelMoveEvent(new ISignalElementChangeListener.ElementMoveEvent(aMovedElement, oldCG, oldIndex));
    }

    public void removeChannelChangeListener(ISignalElementChangeListener aListener) {
        this.eventListeners.remove(ISignalElementChangeListener.class, aListener);
    }

    final void fireChannelMoveEvent(ISignalElementChangeListener.ElementMoveEvent aEvent) {
        ISignalElementChangeListener[] listeners;
        for (ISignalElementChangeListener listener : listeners = (ISignalElementChangeListener[])this.eventListeners.getListeners(ISignalElementChangeListener.class)) {
            listener.signalElementMoved(aEvent);
        }
    }

    final void fireGroupStructureChangeEvent(Collection<SignalElement> aSignalElements) {
        ISignalElementChangeListener[] listeners;
        for (ISignalElementChangeListener listener : listeners = (ISignalElementChangeListener[])this.eventListeners.getListeners(ISignalElementChangeListener.class)) {
            listener.groupStructureChanged(aSignalElements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ElementGroup addGroup(String aName) {
        ElementGroup result;
        Object object = this.lock;
        synchronized (object) {
            result = new ElementGroup(this.groups.size(), aName);
            this.groups.add(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSignalElement(ElementGroup aGroup, SignalElement aSignalElement) {
        if (aGroup == null) {
            throw new IllegalArgumentException("Group cannot be null!");
        }
        if (aSignalElement == null) {
            throw new IllegalArgumentException("Signal element cannot be null!");
        }
        if (aGroup.hasElement(aSignalElement)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.elements.contains(aSignalElement)) {
                this.elements.add(aSignalElement);
            }
            ElementGroup oldGroup = aSignalElement.getGroup();
            aGroup.addElement(aSignalElement);
            if (oldGroup != null && !oldGroup.hasElements()) {
                this.groups.remove(oldGroup);
            }
        }
    }

    protected List<SignalElement> getUnassignedElements() {
        ArrayList<SignalElement> channels = new ArrayList<SignalElement>(this.getAllElements());
        for (ElementGroup cg : this.getGroups()) {
            channels.removeAll(cg.getElements());
        }
        return channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeGroup(String aName) {
        if (aName == null || aName.trim().isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty!");
        }
        List<ElementGroup> list = this.groups;
        synchronized (list) {
            ElementGroup group = this.getGroupByName(aName);
            if (group != null) {
                this.groups.remove(group);
            }
        }
    }

    protected void removeSignalElement(ElementGroup aGroup, SignalElement aSignalElement) {
        if (aGroup == null) {
            throw new IllegalArgumentException("Group cannot be null!");
        }
        if (aSignalElement == null) {
            throw new IllegalArgumentException("Signal element cannot be null!");
        }
        aGroup.removeElement(aSignalElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElementGroup getGroupByName(String aName) {
        Iterator<ElementGroup> channelGroupIter;
        if (aName == null || aName.trim().isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty!");
        }
        Object object = this.lock;
        synchronized (object) {
            channelGroupIter = this.groups.iterator();
        }
        while (channelGroupIter.hasNext()) {
            ElementGroup cg = channelGroupIter.next();
            if (!aName.equals(cg.getName())) continue;
            return cg;
        }
        return null;
    }

    private static class StrictChannelElementMeasurer
    implements SignalElementMeasurer {
        private StrictChannelElementMeasurer() {
        }

        @Override
        public boolean signalElementFits(int aYpos, int aHeight, int aMinY, int aMaxY) {
            return aYpos >= aMinY && aYpos <= aMaxY;
        }
    }

    private static class LooseChannelElementMeasurer
    implements SignalElementMeasurer {
        private LooseChannelElementMeasurer() {
        }

        @Override
        public boolean signalElementFits(int aYpos, int aHeight, int aMinY, int aMaxY) {
            int y1 = aYpos;
            int y2 = y1 + aHeight;
            return !(y1 < aMinY && y2 < aMinY || y1 > aMaxY && y2 > aMaxY);
        }
    }

    public static interface SignalElementMeasurer {
        public static final SignalElementMeasurer STRICT_MEASURER = new StrictChannelElementMeasurer();
        public static final SignalElementMeasurer LOOSE_MEASURER = new LooseChannelElementMeasurer();

        public boolean signalElementFits(int var1, int var2, int var3, int var4);
    }
}

