/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.icons;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import nl.lxtreme.ols.client.icons.IconLocator;
import nl.lxtreme.ols.util.swing.component.icon.TextOverlayIcon;

public final class IconFactory {
    private IconFactory() {
    }

    public static Icon createIcon(String aIconName) {
        try {
            URL url = IconLocator.class.getResource(aIconName);
            return new ImageIcon(url);
        }
        catch (Exception exception) {
            return new ImageIcon();
        }
    }

    public static Image createImage(String aImageName) {
        URL url = IconLocator.class.getResource(aImageName);
        return Toolkit.getDefaultToolkit().createImage(url);
    }

    public static Icon createOverlayIcon(String aIconName, String aText) {
        return new CompoundTextIcon(aIconName, aText, 3);
    }

    public static class CompoundTextIcon
    extends TextOverlayIcon {
        private static final long serialVersionUID = 1L;

        public CompoundTextIcon(String aIconName, String aTextOverlay) {
            super(IconFactory.createIcon(aIconName), aTextOverlay);
        }

        public CompoundTextIcon(String aIconName, String aTextOverlay, int aPosition) {
            super(IconFactory.createIcon(aIconName), aTextOverlay, aPosition);
        }
    }
}

