/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.action;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;

public class FocusWindowAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final String ID_PREFIX = "FocusWindow.";

    public FocusWindowAction(String aWindowTitle) {
        super(ID_PREFIX.concat(aWindowTitle));
        this.putValue("Name", aWindowTitle);
        this.putValue("SwingSelectedKey", FocusWindowAction.hasFocus(aWindowTitle));
    }

    public static final String getTitle(Window aWindow) {
        if (aWindow instanceof Frame) {
            return ((Frame)aWindow).getTitle();
        }
        if (aWindow instanceof Dialog) {
            return ((Dialog)aWindow).getTitle();
        }
        return aWindow.getName();
    }

    private static Window findWindow(Object aName) {
        String name = String.valueOf(aName);
        for (Window window : Window.getWindows()) {
            if (!name.equals(FocusWindowAction.getTitle(window))) continue;
            return window;
        }
        return null;
    }

    private static Boolean hasFocus(Object aName) {
        Window window = FocusWindowAction.findWindow(aName);
        if (window != null) {
            return window.hasFocus();
        }
        return Boolean.FALSE;
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                Window window = FocusWindowAction.findWindow(FocusWindowAction.this.getValue("Name"));
                if (window != null && !SwingComponentUtils.isActivelyShown((Component)window)) {
                    if (window instanceof Frame) {
                        FocusWindowAction.this.deiconifyWindow((Frame)window);
                    }
                    window.toFront();
                    window.requestFocus();
                }
            }
        });
    }

    void deiconifyWindow(Frame aWindow) {
        int state = aWindow.getExtendedState();
        if ((state & 1) != 0) {
            aWindow.setExtendedState(state &= 0xFFFFFFFE);
        }
    }
}

