/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.asm45;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.api.tools.Tool;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolTask;
import nl.lxtreme.ols.tool.asm45.Asm45Analyser;
import nl.lxtreme.ols.tool.asm45.Asm45AnalyserTask;
import nl.lxtreme.ols.tool.asm45.Asm45Data;
import nl.lxtreme.ols.tool.asm45.Asm45DataSet;
import nl.lxtreme.ols.tool.base.BaseToolDialog;
import nl.lxtreme.ols.tool.base.ExportAware;
import nl.lxtreme.ols.tool.base.ToolDialog;
import nl.lxtreme.ols.tool.base.ToolUtils;
import nl.lxtreme.ols.util.ExportUtils;
import nl.lxtreme.ols.util.HostUtils;
import nl.lxtreme.ols.util.StringUtils;
import nl.lxtreme.ols.util.swing.SpringLayoutUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import nl.lxtreme.ols.util.swing.component.JErrorDialog;
import org.osgi.framework.BundleContext;

public final class Asm45ProtocolAnalysisDialog
extends BaseToolDialog<Asm45DataSet>
implements ExportAware<Asm45DataSet> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(Asm45ProtocolAnalysisDialog.class.getName());
    private JLabel idaLinesLabel;
    private JLabel bscLinesLabel;
    private JLabel idaLinesConfigLabel;
    private JLabel bscLinesConfigLabel;
    private JLabel lineSMCLabel;
    private JLabel lineSTMLabel;
    private JLabel lineEBGLabel;
    private JLabel lineBYTELabel;
    private JLabel lineBLLabel;
    private JLabel lineWRTLabel;
    private JLabel lineSYNCLabel;
    private JComboBox lineSMC;
    private JComboBox lineSTM;
    private JComboBox lineEBG;
    private JComboBox lineBYTE;
    private JComboBox lineBL;
    private JComboBox lineWRT;
    private JComboBox lineSYNC;
    private JCheckBox showInst;
    private JCheckBox showData;
    private JCheckBox showBusGrants;
    private JEditorPane outText;
    private ToolUtils.RestorableAction runAnalysisAction;
    private Action exportAction;
    private Action closeAction;

    public Asm45ProtocolAnalysisDialog(Window aOwner, ToolContext aToolContext, BundleContext aContext, Asm45Analyser aTool) {
        super(aOwner, aToolContext, aContext, (Tool)aTool);
        this.initDialog();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void exportToFile(File aOutputFile, ExportAware.ExportFormat aFormat) throws IOException {
        if (ExportAware.ExportFormat.CSV.equals((Object)aFormat)) {
            this.storeToCsvFile(aOutputFile, (Asm45DataSet)((Object)this.getLastResult()));
        } else if (ExportAware.ExportFormat.HTML.equals((Object)aFormat)) {
            this.storeToHtmlFile(aOutputFile, (Asm45DataSet)((Object)this.getLastResult()));
        }
    }

    public void readPreferences(UserSettings aSettings) {
        this.setComboBoxIndex(this.lineSMC, aSettings, "lineSMC");
        this.setComboBoxIndex(this.lineSTM, aSettings, "lineSTM");
        this.setComboBoxIndex(this.lineEBG, aSettings, "lineEBG");
        this.setComboBoxIndex(this.lineBYTE, aSettings, "lineBYTE");
        this.setComboBoxIndex(this.lineBL, aSettings, "lineBL");
        this.setComboBoxIndex(this.lineWRT, aSettings, "lineWRT");
        this.setComboBoxIndex(this.lineSYNC, aSettings, "lineSYNC");
        this.showInst.setSelected(aSettings.getBoolean("showInst", this.showInst.isSelected()));
        this.showData.setSelected(aSettings.getBoolean("showData", this.showData.isSelected()));
        this.showBusGrants.setSelected(aSettings.getBoolean("showBusGrants", this.showBusGrants.isSelected()));
    }

    public void reset() {
        String emptyHtmlPage = this.getEmptyHtmlPage();
        this.outText.setText(emptyHtmlPage);
        this.outText.setEditable(false);
        this.runAnalysisAction.restore();
        this.setControlsEnabled(true);
        this.exportAction.setEnabled(false);
    }

    public void writePreferences(UserSettings aSettings) {
        aSettings.putInt("lineSMC", this.lineSMC.getSelectedIndex());
        aSettings.putInt("lineSTM", this.lineSTM.getSelectedIndex());
        aSettings.putInt("lineEBG", this.lineEBG.getSelectedIndex());
        aSettings.putInt("lineBYTE", this.lineBYTE.getSelectedIndex());
        aSettings.putInt("lineBL", this.lineBL.getSelectedIndex());
        aSettings.putInt("lineWRT", this.lineWRT.getSelectedIndex());
        aSettings.putInt("lineSYNC", this.lineSYNC.getSelectedIndex());
        aSettings.putBoolean("showInst", this.showInst.isSelected());
        aSettings.putBoolean("showData", this.showData.isSelected());
        aSettings.putBoolean("showBusGrants", this.showBusGrants.isSelected());
    }

    protected void onToolEnded(Asm45DataSet aAnalysisResult) {
        block2: {
            try {
                String htmlPage = aAnalysisResult != null ? this.toHtmlPage(null, aAnalysisResult) : this.getEmptyHtmlPage();
                this.outText.setText(htmlPage);
                this.outText.setEditable(false);
                this.runAnalysisAction.restore();
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block2;
                throw new RuntimeException(exception);
            }
        }
    }

    protected void onToolStarted() {
    }

    protected void prepareToolTask(ToolTask<Asm45DataSet> aToolTask) {
        Asm45AnalyserTask toolTask = (Asm45AnalyserTask)aToolTask;
        toolTask.setLineSMCIndex(this.lineSMC.getSelectedIndex());
        toolTask.setLineSTMIndex(this.lineSTM.getSelectedIndex());
        toolTask.setLineEBGIndex(this.lineEBG.getSelectedIndex());
        toolTask.setLineBYTEIndex(this.lineBYTE.getSelectedIndex());
        toolTask.setLineBLIndex(this.lineBL.getSelectedIndex());
        toolTask.setLineWRTIndex(this.lineWRT.getSelectedIndex());
        toolTask.setLineSYNCIndex(this.lineSYNC.getSelectedIndex());
        toolTask.setReportInst(this.showInst.isSelected());
        toolTask.setReportData(this.showData.isSelected());
        toolTask.setReportBusGrants(this.showBusGrants.isSelected());
    }

    protected void setControlsEnabled(boolean aEnabled) {
        this.lineSMC.setEnabled(aEnabled);
        this.lineSTM.setEnabled(aEnabled);
        this.lineEBG.setEnabled(aEnabled);
        this.lineBYTE.setEnabled(aEnabled);
        this.lineBL.setEnabled(aEnabled);
        this.lineWRT.setEnabled(aEnabled);
        this.lineSYNC.setEnabled(aEnabled);
        this.showInst.setEnabled(aEnabled);
        this.showData.setEnabled(aEnabled);
        this.showBusGrants.setEnabled(aEnabled);
        this.closeAction.setEnabled(aEnabled);
        this.exportAction.setEnabled(aEnabled);
    }

    protected boolean validateToolSettings() {
        boolean result = super.validateToolSettings();
        if (result && this.getContext().getChannels() != 32) {
            JErrorDialog.showDialog((Window)this.getOwner(), (String)"Cannot start analysis!", (String)"Not enough channels!", (String)"For the Asm45 decoder, you need to have 32 channels enabled.");
            result = false;
        }
        return result;
    }

    private ExportUtils.HtmlExporter createHtmlTemplate(ExportUtils.HtmlExporter aExporter) {
        aExporter.addCssStyle("body { font-family: sans-serif; } ");
        aExporter.addCssStyle("table { border-width: 1px; border-spacing: 0px; border-color: gray; border-collapse: collapse; border-style: solid; margin-bottom: 15px; } ");
        aExporter.addCssStyle("table th { border-width: 1px; padding: 2px; border-style: solid; border-color: gray; background-color: #E0E0FF; text-align: center; font-weight: bold; font-family: sans-serif; } ");
        aExporter.addCssStyle("table td { border-width: 1px; padding: 2px; border-style: solid; border-color: gray; font-family: monospace; } ");
        aExporter.addCssStyle(".date { text-align: right; font-size: x-small; margin-bottom: 15px; } ");
        aExporter.addCssStyle(".w100 { width: 100%; } ");
        aExporter.addCssStyle(".w30 { width: 30%; } ");
        aExporter.addCssStyle(".w20 { width: 20%; } ");
        aExporter.addCssStyle(".w15 { width: 15%; } ");
        aExporter.addCssStyle(".w10 { width: 10%; } ");
        ExportUtils.HtmlExporter.Element body = aExporter.getBody();
        body.addChild(ExportUtils.HtmlExporter.H1).addContent(new String[]{"Asm45 Analysis results"});
        body.addChild(ExportUtils.HtmlExporter.HR);
        body.addChild(ExportUtils.HtmlExporter.DIV).addAttribute("class", "date").addContent(new String[]{"{date-now}"});
        ExportUtils.HtmlExporter.Element table = body.addChild(ExportUtils.HtmlExporter.TABLE).addAttribute("class", "w100");
        ExportUtils.HtmlExporter.Element tbody = table.addChild(ExportUtils.HtmlExporter.TBODY);
        ExportUtils.HtmlExporter.Element tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("colspan", "2").addContent(new String[]{"Bus configuration"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"IDA0/..IDA15/"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"0..15"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"BSC0/..BSC5/"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"16..21"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"SMC/"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{smc-bus-config}"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"STM/"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{stm-bus-config}"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"EBG"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{ebg-bus-config}"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"BYTE"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{byte-bus-config}"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"BL"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{bl-bus-config}"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"WRT/"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{wrt-bus-config}"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"SYNC"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{sync-bus-config}"});
        tbody = table.addChild(ExportUtils.HtmlExporter.TBODY);
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("colspan", "2").addContent(new String[]{"Statistics"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"Decoded words"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{decoded-words}"});
        table = body.addChild(ExportUtils.HtmlExporter.TABLE).addAttribute("class", "w100");
        ExportUtils.HtmlExporter.Element thead = table.addChild(ExportUtils.HtmlExporter.THEAD);
        tr = thead.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"Index"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"Clocks"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"Block"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"Address"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"Value"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"Bus Grant"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"Type"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w30").addContent(new String[]{"Event"});
        tbody = table.addChild(ExportUtils.HtmlExporter.TBODY);
        tbody.addContent(new String[]{"{decoded-data}"});
        return aExporter;
    }

    private JPanel createPreviewPane() {
        JPanel output = new JPanel(new GridLayout(1, 1, 0, 0));
        this.outText = new JEditorPane("text/html", this.getEmptyHtmlPage());
        this.outText.setEditable(false);
        output.add(new JScrollPane(this.outText));
        return output;
    }

    private JPanel createSettingsPane() {
        int channelCount = this.getData().getChannels();
        JPanel panel = new JPanel(new SpringLayout());
        SpringLayoutUtils.addSeparator((Container)panel, (String)"Settings");
        this.idaLinesLabel = SwingComponentUtils.createRightAlignedLabel((String)"IDA0/..IDA15/");
        this.bscLinesLabel = SwingComponentUtils.createRightAlignedLabel((String)"BSC0/..BSC5/");
        this.idaLinesConfigLabel = SwingComponentUtils.createRightAlignedLabel((String)"0..15");
        this.bscLinesConfigLabel = SwingComponentUtils.createRightAlignedLabel((String)"16..21");
        this.lineSMCLabel = SwingComponentUtils.createRightAlignedLabel((String)"SMC/");
        this.lineSTMLabel = SwingComponentUtils.createRightAlignedLabel((String)"STM/");
        this.lineEBGLabel = SwingComponentUtils.createRightAlignedLabel((String)"EBG");
        this.lineBYTELabel = SwingComponentUtils.createRightAlignedLabel((String)"BYTE");
        this.lineBLLabel = SwingComponentUtils.createRightAlignedLabel((String)"BL");
        this.lineWRTLabel = SwingComponentUtils.createRightAlignedLabel((String)"WRT/");
        this.lineSYNCLabel = SwingComponentUtils.createRightAlignedLabel((String)"SYNC");
        panel.add(this.idaLinesLabel);
        panel.add(this.idaLinesConfigLabel);
        panel.add(this.bscLinesLabel);
        panel.add(this.bscLinesConfigLabel);
        panel.add(this.lineSMCLabel);
        this.lineSMC = SwingComponentUtils.createChannelSelector((int)channelCount, (int)22);
        panel.add(this.lineSMC);
        panel.add(this.lineSTMLabel);
        this.lineSTM = SwingComponentUtils.createChannelSelector((int)channelCount, (int)23);
        panel.add(this.lineSTM);
        panel.add(this.lineEBGLabel);
        this.lineEBG = SwingComponentUtils.createChannelSelector((int)channelCount, (int)25);
        panel.add(this.lineEBG);
        panel.add(this.lineBYTELabel);
        this.lineBYTE = SwingComponentUtils.createChannelSelector((int)channelCount, (int)26);
        panel.add(this.lineBYTE);
        panel.add(this.lineBLLabel);
        this.lineBL = SwingComponentUtils.createChannelSelector((int)channelCount, (int)27);
        panel.add(this.lineBL);
        panel.add(this.lineWRTLabel);
        this.lineWRT = SwingComponentUtils.createChannelSelector((int)channelCount, (int)29);
        panel.add(this.lineWRT);
        panel.add(this.lineSYNCLabel);
        this.lineSYNC = SwingComponentUtils.createChannelSelector((int)channelCount, (int)30);
        panel.add(this.lineSYNC);
        this.showInst = new JCheckBox();
        this.showInst.setSelected(true);
        panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Show instructions"));
        panel.add(this.showInst);
        this.showData = new JCheckBox();
        this.showData.setSelected(true);
        panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Show data transfers"));
        panel.add(this.showData);
        this.showBusGrants = new JCheckBox();
        this.showBusGrants.setSelected(false);
        panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Show bus grants"));
        panel.add(this.showBusGrants);
        SpringLayoutUtils.makeEditorGrid((Container)panel, (int)10, (int)4);
        return panel;
    }

    private String getEmptyHtmlPage() {
        ExportUtils.HtmlExporter exporter = this.createHtmlTemplate(ExportUtils.createHtmlExporter());
        return exporter.toString(new ExportUtils.HtmlExporter.MacroResolver(){

            public Object resolve(String aMacro, ExportUtils.HtmlExporter.Element aParent) {
                if ("date-now".equals(aMacro)) {
                    DateFormat df = DateFormat.getDateInstance(1);
                    return df.format(new Date());
                }
                if ("smc-bus-config".equals(aMacro)) {
                    return Asm45ProtocolAnalysisDialog.this.lineSMC.getSelectedIndex();
                }
                if ("stm-bus-config".equals(aMacro)) {
                    return Asm45ProtocolAnalysisDialog.this.lineSTM.getSelectedIndex();
                }
                if ("ebg-bus-config".equals(aMacro)) {
                    return Asm45ProtocolAnalysisDialog.this.lineEBG.getSelectedIndex();
                }
                if ("byte-bus-config".equals(aMacro)) {
                    return Asm45ProtocolAnalysisDialog.this.lineBYTE.getSelectedIndex();
                }
                if ("bl-bus-config".equals(aMacro)) {
                    return Asm45ProtocolAnalysisDialog.this.lineBL.getSelectedIndex();
                }
                if ("wrt-bus-config".equals(aMacro)) {
                    return Asm45ProtocolAnalysisDialog.this.lineWRT.getSelectedIndex();
                }
                if ("sync-bus-config".equals(aMacro)) {
                    return Asm45ProtocolAnalysisDialog.this.lineSYNC.getSelectedIndex();
                }
                if ("decoded-words".equals(aMacro)) {
                    return "-";
                }
                return null;
            }
        });
    }

    private void initDialog() {
        this.setMinimumSize(new Dimension(640, 480));
        JPanel settingsPane = this.createSettingsPane();
        JPanel previewPane = this.createPreviewPane();
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.add((Component)settingsPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(2, 0, 2, 0), 0, 0));
        contentPane.add((Component)previewPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 0, 2, 0), 0, 0));
        JButton runAnalysisButton = ToolUtils.createRunAnalysisButton((ToolDialog)this);
        this.runAnalysisAction = (ToolUtils.RestorableAction)runAnalysisButton.getAction();
        JButton exportButton = ToolUtils.createExportButton((ExportAware)this);
        this.exportAction = exportButton.getAction();
        this.exportAction.setEnabled(false);
        JButton closeButton = ToolUtils.createCloseButton();
        this.closeAction = closeButton.getAction();
        JComponent buttonPane = SwingComponentUtils.createButtonPane((JButton[])new JButton[]{runAnalysisButton, exportButton, closeButton});
        SwingComponentUtils.setupDialogContentPane((JDialog)((Object)this), (Component)contentPane, (Component)buttonPane, (JButton)runAnalysisButton);
        this.pack();
    }

    private void storeToCsvFile(File aSelectedFile, Asm45DataSet aAnalysisResult) {
        block3: {
            try {
                ExportUtils.CsvExporter exporter = ExportUtils.createCsvExporter((File)aSelectedFile);
                exporter.setHeaders(new String[]{"index", "clocks", "block", "address", "value", "bus grant", "type", "event"});
                List dataSet = aAnalysisResult.getData();
                for (int i = 0; i < dataSet.size(); ++i) {
                    Asm45Data ds = (Asm45Data)((Object)dataSet.get(i));
                    exporter.addRow(new Object[]{i, ds.getClocks(), StringUtils.integerToHexString((int)ds.getBlock(), (int)2), StringUtils.integerToHexString((int)ds.getAddress(), (int)4), StringUtils.integerToHexString((int)ds.getValue(), (int)4), ds.getBusGrant() ? "X" : "-", ds.getType(), ds.getEvent()});
                }
                exporter.close();
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block3;
                LOG.log(Level.WARNING, "CSV export failed!", exception);
            }
        }
    }

    private void storeToHtmlFile(File aSelectedFile, Asm45DataSet aAnalysisResult) {
        block2: {
            try {
                this.toHtmlPage(aSelectedFile, aAnalysisResult);
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block2;
                LOG.log(Level.WARNING, "HTML export failed!", exception);
            }
        }
    }

    private String toHtmlPage(File aFile, final Asm45DataSet aAnalysisResult) throws IOException {
        ExportUtils.HtmlExporter.MacroResolver macroResolver = new ExportUtils.HtmlExporter.MacroResolver(){

            public Object resolve(String aMacro, ExportUtils.HtmlExporter.Element aParent) {
                if ("date-now".equals(aMacro)) {
                    DateFormat df = DateFormat.getDateInstance(1);
                    return df.format(new Date());
                }
                if ("smc-bus-config".equals(aMacro)) {
                    return Asm45ProtocolAnalysisDialog.this.lineSMC.getSelectedIndex();
                }
                if ("stm-bus-config".equals(aMacro)) {
                    return Asm45ProtocolAnalysisDialog.this.lineSTM.getSelectedIndex();
                }
                if ("ebg-bus-config".equals(aMacro)) {
                    return Asm45ProtocolAnalysisDialog.this.lineEBG.getSelectedIndex();
                }
                if ("byte-bus-config".equals(aMacro)) {
                    return Asm45ProtocolAnalysisDialog.this.lineBYTE.getSelectedIndex();
                }
                if ("bl-bus-config".equals(aMacro)) {
                    return Asm45ProtocolAnalysisDialog.this.lineBL.getSelectedIndex();
                }
                if ("wrt-bus-config".equals(aMacro)) {
                    return Asm45ProtocolAnalysisDialog.this.lineWRT.getSelectedIndex();
                }
                if ("sync-bus-config".equals(aMacro)) {
                    return Asm45ProtocolAnalysisDialog.this.lineSYNC.getSelectedIndex();
                }
                if ("decoded-words".equals(aMacro)) {
                    return aAnalysisResult.getDecodedWordCount();
                }
                if ("decoded-data".equals(aMacro)) {
                    List dataSet = aAnalysisResult.getData();
                    for (int i = 0; i < dataSet.size(); ++i) {
                        Asm45Data data = (Asm45Data)((Object)dataSet.get(i));
                        int index = i - aAnalysisResult.getTriggerEvent();
                        String bgColor = index == 0 ? "#ffa0ff" : (data.getType().equals("I") ? "#ffffff" : (data.getBusGrant() ? "#64ff64" : "#e0e0ff"));
                        ExportUtils.HtmlExporter.Element tr = aParent.addChild(ExportUtils.HtmlExporter.TR).addAttribute("style", "background-color: " + bgColor + "; text-align: center;");
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{String.valueOf(index)});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{String.valueOf(data.getClocks())});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{StringUtils.integerToHexString((int)data.getBlock(), (int)2)});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{StringUtils.integerToHexString((int)data.getAddress(), (int)4)});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{StringUtils.integerToHexString((int)data.getValue(), (int)4)});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{data.getBusGrant() ? "X" : "-"});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{data.getType()});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("style", "text-align: left;").addContent(new String[]{data.getEvent()});
                    }
                }
                return null;
            }
        };
        if (aFile == null) {
            ExportUtils.HtmlExporter exporter = this.createHtmlTemplate(ExportUtils.createHtmlExporter());
            return exporter.toString(macroResolver);
        }
        ExportUtils.HtmlFileExporter exporter = (ExportUtils.HtmlFileExporter)this.createHtmlTemplate((ExportUtils.HtmlExporter)ExportUtils.createHtmlExporter((File)aFile));
        exporter.write(macroResolver);
        exporter.close();
        return null;
    }
}

