/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm;

import com.sun.jna.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import jtermios.FDSet;
import jtermios.JTermios;
import jtermios.Pollfd;
import jtermios.Termios;
import jtermios.TimeVal;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.SerialPortEvent;
import purejavacomm.SerialPortEventListener;
import purejavacomm.UnsupportedCommOperationException;

public class PureJavaSerialPort
extends SerialPort {
    private Thread m_Thread;
    private volatile SerialPortEventListener m_EventListener;
    private volatile int m_FD = -1;
    private volatile int m_BaudRate;
    private volatile int m_DataBits;
    private volatile int m_FlowControlMode;
    private volatile int m_Parity;
    private volatile int m_StopBits;
    private volatile boolean m_ReceiveTimeOutEnabled;
    private volatile int m_ReceiveTimeOutValue;
    private volatile boolean m_ReceiveThresholdEnabled;
    private volatile int m_ReceiveThresholdValue;
    private volatile boolean m_NotifyOnDataAvailable;
    private volatile boolean m_DataAvailableNotified;
    private volatile boolean m_NotifyOnOutputEmpty;
    private volatile boolean m_OutputEmptyNotified;
    private volatile boolean m_NotifyOnRI;
    private volatile boolean m_NotifyOnCTS;
    private volatile boolean m_NotifyOnDSR;
    private volatile boolean m_NotifyOnCD;
    private volatile boolean m_NotifyOnOverrunError;
    private volatile boolean m_NotifyOnParityError;
    private volatile boolean m_NotifyOnFramingError;
    private volatile boolean m_NotifyOnBreakInterrupt;
    private volatile boolean m_ThreadRunning;
    private volatile boolean m_ThreadStarted;
    private int[] m_ioctl = new int[1];
    private int m_ControlLineStates;
    private Termios m_Termios = new Termios();

    private void sendDataEvents(boolean read, boolean write) {
        if (read && this.m_NotifyOnDataAvailable && !this.m_DataAvailableNotified) {
            this.m_DataAvailableNotified = true;
            this.m_EventListener.serialEvent(new SerialPortEvent(this, 1, false, true));
        }
        if (write && this.m_NotifyOnOutputEmpty && !this.m_OutputEmptyNotified) {
            this.m_OutputEmptyNotified = true;
            this.m_EventListener.serialEvent(new SerialPortEvent(this, 2, false, true));
        }
    }

    private synchronized void sendNonDataEvents() {
        int line;
        if (JTermios.ioctl(this.m_FD, JTermios.TIOCMGET, this.m_ioctl) < 0) {
            return;
        }
        int oldstates = this.m_ControlLineStates;
        this.m_ControlLineStates = this.m_ioctl[0];
        int newstates = this.m_ControlLineStates;
        int changes = oldstates ^ newstates;
        if (changes == 0) {
            return;
        }
        if (this.m_NotifyOnCTS && ((line = JTermios.TIOCM_CTS) & changes) != 0) {
            this.m_EventListener.serialEvent(new SerialPortEvent(this, 3, (oldstates & line) != 0, (newstates & line) != 0));
        }
        if (this.m_NotifyOnDSR && ((line = JTermios.TIOCM_DSR) & changes) != 0) {
            this.m_EventListener.serialEvent(new SerialPortEvent(this, 4, (oldstates & line) != 0, (newstates & line) != 0));
        }
        if (this.m_NotifyOnRI && ((line = JTermios.TIOCM_RI) & changes) != 0) {
            this.m_EventListener.serialEvent(new SerialPortEvent(this, 5, (oldstates & line) != 0, (newstates & line) != 0));
        }
        if (this.m_NotifyOnCD && ((line = JTermios.TIOCM_CD) & changes) != 0) {
            this.m_EventListener.serialEvent(new SerialPortEvent(this, 6, (oldstates & line) != 0, (newstates & line) != 0));
        }
    }

    public synchronized void addEventListener(SerialPortEventListener eventListener) throws TooManyListenersException {
        this.checkState();
        if (eventListener == null) {
            throw new IllegalArgumentException("eventListener cannot be null");
        }
        if (this.m_EventListener != null) {
            throw new TooManyListenersException();
        }
        this.m_EventListener = eventListener;
        if (!this.m_ThreadStarted) {
            this.m_ThreadStarted = true;
            this.m_Thread.start();
        }
    }

    public synchronized int getBaudRate() {
        this.checkState();
        return this.m_BaudRate;
    }

    public synchronized int getDataBits() {
        this.checkState();
        return this.m_DataBits;
    }

    public synchronized int getFlowControlMode() {
        this.checkState();
        return this.m_FlowControlMode;
    }

    public synchronized int getParity() {
        this.checkState();
        return this.m_Parity;
    }

    public synchronized int getStopBits() {
        this.checkState();
        return this.m_StopBits;
    }

    public synchronized boolean isCD() {
        this.checkState();
        return this.getControlLineState(JTermios.TIOCM_CD);
    }

    public synchronized boolean isCTS() {
        this.checkState();
        return this.getControlLineState(JTermios.TIOCM_CTS);
    }

    public synchronized boolean isDSR() {
        this.checkState();
        return this.getControlLineState(JTermios.TIOCM_DSR);
    }

    public synchronized boolean isDTR() {
        this.checkState();
        return this.getControlLineState(JTermios.TIOCM_DTR);
    }

    public synchronized boolean isRI() {
        this.checkState();
        return this.getControlLineState(JTermios.TIOCM_RI);
    }

    public synchronized boolean isRTS() {
        this.checkState();
        return this.getControlLineState(JTermios.TIOCM_RTS);
    }

    public synchronized void notifyOnBreakInterrupt(boolean x) {
        this.checkState();
        this.m_NotifyOnBreakInterrupt = x;
    }

    public synchronized void notifyOnCTS(boolean x) {
        this.checkState();
        if (x) {
            this.updateControlLineState(JTermios.TIOCM_CTS);
        }
        this.m_NotifyOnCTS = x;
    }

    public synchronized void notifyOnCarrierDetect(boolean x) {
        this.checkState();
        if (x) {
            this.updateControlLineState(JTermios.TIOCM_CD);
        }
        this.m_NotifyOnCD = x;
    }

    public synchronized void notifyOnDSR(boolean x) {
        this.checkState();
        if (x) {
            this.updateControlLineState(JTermios.TIOCM_DSR);
        }
        this.m_NotifyOnDSR = x;
    }

    public synchronized void notifyOnDataAvailable(boolean x) {
        this.checkState();
        this.m_NotifyOnDataAvailable = x;
    }

    public synchronized void notifyOnFramingError(boolean x) {
        this.checkState();
        this.m_NotifyOnFramingError = x;
    }

    public synchronized void notifyOnOutputEmpty(boolean x) {
        this.checkState();
        this.m_NotifyOnOutputEmpty = x;
    }

    public synchronized void notifyOnOverrunError(boolean x) {
        this.checkState();
        this.m_NotifyOnOverrunError = x;
    }

    public synchronized void notifyOnParityError(boolean x) {
        this.checkState();
        this.m_NotifyOnParityError = x;
    }

    public synchronized void notifyOnRingIndicator(boolean x) {
        this.checkState();
        if (x) {
            this.updateControlLineState(JTermios.TIOCM_RI);
        }
        this.m_NotifyOnRI = x;
    }

    public synchronized void removeEventListener() {
        this.checkState();
        this.m_EventListener = null;
    }

    public synchronized void sendBreak(int duration) {
        this.checkState();
        JTermios.tcsendbreak(this.m_FD, duration);
    }

    public synchronized void setDTR(boolean x) {
        this.checkState();
        this.setControlLineState(JTermios.TIOCM_DTR, x);
    }

    public synchronized void setRTS(boolean x) {
        this.checkState();
        this.setControlLineState(JTermios.TIOCM_RTS, x);
    }

    public synchronized void disableReceiveFraming() {
        this.checkState();
    }

    public synchronized void disableReceiveThreshold() {
        this.checkState();
        this.m_ReceiveThresholdEnabled = false;
        this.setReceiveTimeout();
    }

    public synchronized void disableReceiveTimeout() {
        this.checkState();
        this.m_ReceiveTimeOutEnabled = false;
        this.setReceiveTimeout();
    }

    public synchronized void enableReceiveFraming(int arg0) throws UnsupportedCommOperationException {
        this.checkState();
        throw new UnsupportedCommOperationException();
    }

    public synchronized void enableReceiveThreshold(int value) throws UnsupportedCommOperationException {
        this.checkState();
        this.m_ReceiveThresholdEnabled = true;
        this.m_ReceiveThresholdValue = value;
        this.setReceiveTimeout();
    }

    public synchronized int getInputBufferSize() {
        this.checkState();
        return 0;
    }

    public synchronized int getOutputBufferSize() {
        this.checkState();
        return 0;
    }

    public synchronized void enableReceiveTimeout(int value) throws UnsupportedCommOperationException {
        this.checkState();
        this.m_ReceiveTimeOutEnabled = true;
        this.m_ReceiveTimeOutValue = value;
        this.setReceiveTimeout();
    }

    public synchronized void setFlowControlMode(int mode) throws UnsupportedCommOperationException {
        this.checkState();
        this.m_Termios.c_iflag &= ~JTermios.IXANY;
        this.m_Termios.c_cflag = (mode & 3) != 0 ? (this.m_Termios.c_cflag |= JTermios.CRTSCTS) : (this.m_Termios.c_cflag &= ~JTermios.CRTSCTS);
        this.m_Termios.c_iflag = (mode & 4) != 0 ? (this.m_Termios.c_iflag |= JTermios.IXOFF) : (this.m_Termios.c_iflag &= ~JTermios.IXOFF);
        this.m_Termios.c_iflag = (mode & 8) != 0 ? (this.m_Termios.c_iflag |= JTermios.IXON) : (this.m_Termios.c_iflag &= ~JTermios.IXON);
        this.checkReturnCode(JTermios.tcsetattr(this.m_FD, JTermios.TCSANOW, this.m_Termios));
        this.m_FlowControlMode = mode;
    }

    public synchronized void setSerialPortParams(int baudRate, int dataBits, int stopBits, int parity) throws UnsupportedCommOperationException {
        this.checkState();
        Termios prev = new Termios();
        prev.set(this.m_Termios);
        try {
            int sb;
            int db;
            this.checkReturnCode(JTermios.setspeed(this.m_FD, this.m_Termios, baudRate));
            switch (dataBits) {
                case 5: {
                    db = JTermios.CS5;
                    break;
                }
                case 6: {
                    db = JTermios.CS6;
                    break;
                }
                case 7: {
                    db = JTermios.CS7;
                    break;
                }
                case 8: {
                    db = JTermios.CS8;
                    break;
                }
                default: {
                    throw new UnsupportedCommOperationException("dataBits = " + dataBits);
                }
            }
            switch (stopBits) {
                case 1: {
                    sb = 1;
                    break;
                }
                case 2: {
                    sb = 2;
                    break;
                }
                default: {
                    throw new UnsupportedCommOperationException("stopBits = " + stopBits);
                }
            }
            int fi = this.m_Termios.c_iflag;
            int fc = this.m_Termios.c_cflag;
            switch (parity) {
                case 0: {
                    fc &= ~JTermios.PARENB;
                    fi &= ~(JTermios.INPCK | JTermios.ISTRIP);
                    break;
                }
                case 2: {
                    fc |= JTermios.PARENB;
                    fc &= ~JTermios.PARODD;
                    fi &= ~(JTermios.INPCK | JTermios.ISTRIP);
                    break;
                }
                case 1: {
                    fc |= JTermios.PARENB;
                    fc |= JTermios.PARODD;
                    fi &= ~(JTermios.INPCK | JTermios.ISTRIP);
                    break;
                }
                default: {
                    throw new UnsupportedCommOperationException("parity = " + parity);
                }
            }
            fc &= ~JTermios.CSIZE;
            fc |= db;
            fc = sb == 2 ? (fc |= JTermios.CSTOPB) : (fc &= ~JTermios.CSTOPB);
            this.m_Termios.c_cflag = fc;
            this.m_Termios.c_iflag = fi;
            this.checkReturnCode(JTermios.tcsetattr(this.m_FD, JTermios.TCSANOW, this.m_Termios));
            this.checkReturnCode(JTermios.tcflush(this.m_FD, JTermios.TCIOFLUSH));
            this.m_BaudRate = baudRate;
            this.m_Parity = parity;
            this.m_DataBits = dataBits;
            this.m_StopBits = stopBits;
        }
        catch (UnsupportedCommOperationException e) {
            this.m_Termios.set(prev);
            this.checkReturnCode(JTermios.tcsetattr(this.m_FD, JTermios.TCSANOW, this.m_Termios));
            throw e;
        }
        catch (IllegalStateException e) {
            this.m_Termios.set(prev);
            this.checkReturnCode(JTermios.tcsetattr(this.m_FD, JTermios.TCSANOW, this.m_Termios));
            throw e;
        }
    }

    private static int min(int a, int b) {
        return a < b ? a : b;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        this.checkState();
        return new OutputStream(){
            private byte[] m_Buffer = new byte[2048];

            public void write(int b) throws IOException {
                PureJavaSerialPort.this.checkState();
                byte[] buf = new byte[]{(byte)b};
                this.write(buf, 0, 1);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                PureJavaSerialPort.this.checkState();
                while (len > 0) {
                    int n = PureJavaSerialPort.min(len, PureJavaSerialPort.min(this.m_Buffer.length, b.length - off));
                    if (off > 0) {
                        System.arraycopy(b, off, this.m_Buffer, 0, n);
                        n = JTermios.write(PureJavaSerialPort.this.m_FD, this.m_Buffer, n);
                    } else {
                        n = JTermios.write(PureJavaSerialPort.this.m_FD, b, n);
                    }
                    if (n < 0) {
                        PureJavaSerialPort.this.close();
                        throw new IOException();
                    }
                    len -= n;
                    off += n;
                }
                PureJavaSerialPort.this.m_OutputEmptyNotified = false;
            }

            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            public void flush() throws IOException {
                PureJavaSerialPort.this.checkState();
                if (JTermios.tcdrain(PureJavaSerialPort.this.m_FD) < 0) {
                    this.close();
                    throw new IOException();
                }
            }
        };
    }

    public synchronized InputStream getInputStream() throws IOException {
        this.checkState();
        return new InputStream(){
            private TimeVal m_TimeOut = new TimeVal();
            private int[] m_Available = new int[1];
            private byte[] m_Buffer = new byte[2048];

            public int available() throws IOException {
                PureJavaSerialPort.this.checkState();
                if (JTermios.ioctl(PureJavaSerialPort.this.m_FD, JTermios.FIONREAD, this.m_Available) < 0) {
                    PureJavaSerialPort.this.close();
                    throw new IOException();
                }
                return this.m_Available[0];
            }

            public int read() throws IOException {
                PureJavaSerialPort.this.checkState();
                byte[] buf = new byte[1];
                int n = this.read(buf, 0, 1);
                return n > 0 ? buf[0] & 0xFF : -1;
            }

            public int read(byte[] b, int off, int len) throws IOException {
                PureJavaSerialPort.this.checkState();
                long T0 = PureJavaSerialPort.this.m_ReceiveTimeOutEnabled ? System.currentTimeMillis() : 0L;
                int N = 0;
                while (true) {
                    int n = len - N;
                    if (off > 0) {
                        n = PureJavaSerialPort.min(n, PureJavaSerialPort.min(this.m_Buffer.length, b.length - off));
                        n = JTermios.read(PureJavaSerialPort.this.m_FD, this.m_Buffer, n);
                        if (n > 0) {
                            System.arraycopy(this.m_Buffer, 0, b, off, n);
                        }
                    } else {
                        n = JTermios.read(PureJavaSerialPort.this.m_FD, b, n);
                    }
                    if (n < 0) {
                        throw new IOException();
                    }
                    if (!PureJavaSerialPort.this.m_ReceiveThresholdEnabled && (N += n) > 0 || PureJavaSerialPort.this.m_ReceiveThresholdEnabled && N >= PureJavaSerialPort.this.m_ReceiveThresholdValue || PureJavaSerialPort.this.m_ReceiveTimeOutEnabled && System.currentTimeMillis() - T0 >= (long)PureJavaSerialPort.this.m_ReceiveTimeOutValue) break;
                    off += n;
                }
                PureJavaSerialPort.this.m_DataAvailableNotified = false;
                return N;
            }
        };
    }

    public synchronized int getReceiveFramingByte() {
        this.checkState();
        return 0;
    }

    public synchronized int getReceiveThreshold() {
        this.checkState();
        return 0;
    }

    public synchronized int getReceiveTimeout() {
        this.checkState();
        return this.m_ReceiveTimeOutValue;
    }

    public synchronized boolean isReceiveFramingEnabled() {
        this.checkState();
        return false;
    }

    public synchronized boolean isReceiveThresholdEnabled() {
        this.checkState();
        return false;
    }

    public synchronized boolean isReceiveTimeoutEnabled() {
        this.checkState();
        return this.m_ReceiveTimeOutEnabled;
    }

    public synchronized void setInputBufferSize(int arg0) {
        this.checkState();
    }

    public synchronized void setOutputBufferSize(int arg0) {
        this.checkState();
    }

    public synchronized void close() {
        int fd = this.m_FD;
        if (fd != -1) {
            int err;
            this.m_FD = -1;
            int flags = JTermios.fcntl(fd, JTermios.F_GETFL, 0);
            int fcres = JTermios.fcntl(fd, JTermios.F_SETFL, flags |= JTermios.O_NONBLOCK);
            if (fcres != 0) {
                boolean bl = JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "fcntl(%d,%d,%d) returned %d\n", this.m_FD, JTermios.F_SETFL, flags, fcres);
            }
            if (this.m_Thread != null) {
                this.m_Thread.interrupt();
            }
            if ((err = JTermios.close(fd)) < 0) {
                JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "JTermios.close returned %d, errno %d\n", err, JTermios.errno());
            }
            long t0 = System.currentTimeMillis();
            while (this.m_ThreadRunning) {
                try {
                    Thread.sleep(5L);
                    if (System.currentTimeMillis() - t0 <= 2000L) continue;
                }
                catch (InterruptedException e) {}
                break;
            }
            super.close();
        }
    }

    PureJavaSerialPort(String name, int timeout) throws PortInUseException {
        this.name = name;
        int tries = 100;
        long T0 = System.currentTimeMillis();
        while ((this.m_FD = JTermios.open(name, JTermios.O_RDWR | JTermios.O_NOCTTY | JTermios.O_NONBLOCK)) < 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (tries-- >= 0 && System.currentTimeMillis() - T0 < (long)timeout) continue;
            throw new PortInUseException();
        }
        int flags = JTermios.fcntl(this.m_FD, JTermios.F_GETFL, 0);
        this.checkReturnCode(JTermios.fcntl(this.m_FD, JTermios.F_SETFL, flags &= ~JTermios.O_NONBLOCK));
        this.m_BaudRate = 9600;
        this.m_DataBits = 8;
        this.m_FlowControlMode = 0;
        this.m_Parity = 0;
        this.m_StopBits = 1;
        this.checkReturnCode(JTermios.tcgetattr(this.m_FD, this.m_Termios));
        JTermios.cfmakeraw(this.m_FD, this.m_Termios);
        this.m_Termios.c_cflag |= JTermios.CLOCAL | JTermios.CREAD;
        this.m_Termios.c_lflag &= ~(JTermios.ICANON | JTermios.ECHO | JTermios.ECHOE | JTermios.ISIG);
        this.m_Termios.c_oflag &= ~JTermios.OPOST;
        this.m_Termios.c_cc[JTermios.VSTART] = (byte)JTermios.DC1;
        this.m_Termios.c_cc[JTermios.VSTOP] = (byte)JTermios.DC3;
        this.m_Termios.c_cc[JTermios.VMIN] = 0;
        this.m_Termios.c_cc[JTermios.VTIME] = 0;
        this.checkReturnCode(JTermios.tcsetattr(this.m_FD, JTermios.TCSANOW, this.m_Termios));
        try {
            this.setSerialPortParams(this.m_BaudRate, this.m_DataBits, this.m_StopBits, this.m_Parity);
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }
        this.setReceiveTimeout();
        this.checkReturnCode(JTermios.ioctl(this.m_FD, JTermios.TIOCMGET, this.m_ioctl));
        this.m_ControlLineStates = this.m_ioctl[0];
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    try {
                        PureJavaSerialPort.this.m_ThreadRunning = true;
                        boolean USE_POLL = Boolean.getBoolean("purejavacomm.use_poll") && Platform.isLinux();
                        int TIMEOUT = 10;
                        TimeVal timeout = null;
                        FDSet rset = null;
                        FDSet wset = null;
                        Pollfd[] pollfd2 = null;
                        if (USE_POLL) {
                            pollfd2 = new Pollfd[]{new Pollfd()};
                        } else {
                            rset = JTermios.newFDSet();
                            wset = JTermios.newFDSet();
                            timeout = new TimeVal();
                            timeout.tv_sec = 0L;
                            timeout.tv_usec = 10000L;
                        }
                        while (PureJavaSerialPort.this.m_FD >= 0) {
                            boolean read = PureJavaSerialPort.this.m_NotifyOnDataAvailable && !PureJavaSerialPort.this.m_DataAvailableNotified;
                            boolean write = PureJavaSerialPort.this.m_NotifyOnOutputEmpty && !PureJavaSerialPort.this.m_OutputEmptyNotified;
                            int n = 0;
                            if (!read && !write) {
                                Thread.sleep(10L);
                            } else {
                                if (USE_POLL) {
                                    pollfd2[0].fd = PureJavaSerialPort.this.m_FD;
                                    short e = 0;
                                    if (read) {
                                        e = (short)(e | JTermios.POLLIN);
                                    }
                                    if (write) {
                                        e = (short)(e | JTermios.POLLOUT);
                                    }
                                    pollfd2[0].events = e;
                                    pollfd2[0].revents = 0;
                                    n = JTermios.poll(pollfd2, 1, 10);
                                    short re = pollfd2[0].revents;
                                    if ((re & JTermios.POLLNVAL) != 0) {
                                        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "poll() returned POLLNVAL, errno %\n", JTermios.errno());
                                        break;
                                    }
                                    read = read && (re & JTermios.POLLIN) != 0;
                                    write = write && (re & JTermios.POLLOUT) != 0;
                                } else {
                                    JTermios.FD_ZERO(rset);
                                    JTermios.FD_ZERO(wset);
                                    if (read) {
                                        JTermios.FD_SET(PureJavaSerialPort.this.m_FD, rset);
                                    }
                                    if (write) {
                                        JTermios.FD_SET(PureJavaSerialPort.this.m_FD, wset);
                                    }
                                    n = JTermios.select(PureJavaSerialPort.this.m_FD + 1, rset, wset, null, timeout);
                                    read = read && JTermios.FD_ISSET(PureJavaSerialPort.this.m_FD, rset);
                                    boolean bl = write = write && JTermios.FD_ISSET(PureJavaSerialPort.this.m_FD, wset);
                                }
                                if (Thread.currentThread().isInterrupted()) {
                                    break;
                                }
                                if (n < 0) {
                                    JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "select() or poll() returned %d, errno %d\n", n, JTermios.errno());
                                    PureJavaSerialPort.this.close();
                                    break;
                                }
                            }
                            if (PureJavaSerialPort.this.m_EventListener == null) continue;
                            if (read || write) {
                                PureJavaSerialPort.this.sendDataEvents(read, write);
                            }
                            if (!PureJavaSerialPort.this.m_NotifyOnCTS && !PureJavaSerialPort.this.m_NotifyOnDSR && !PureJavaSerialPort.this.m_NotifyOnRI && !PureJavaSerialPort.this.m_NotifyOnCD) continue;
                            PureJavaSerialPort.this.sendNonDataEvents();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        PureJavaSerialPort.this.m_ThreadRunning = false;
                    }
                }
                finally {
                    PureJavaSerialPort.this.m_ThreadRunning = false;
                }
            }
        };
        this.m_Thread = new Thread(runnable, this.getName());
        this.m_Thread.setDaemon(true);
    }

    private synchronized void updateControlLineState(int line) {
        this.checkState();
        if (JTermios.ioctl(this.m_FD, JTermios.TIOCMGET, this.m_ioctl) == -1) {
            throw new IllegalStateException();
        }
        this.m_ControlLineStates = (this.m_ioctl[0] & line) + (this.m_ControlLineStates & ~line);
    }

    private synchronized boolean getControlLineState(int line) {
        this.checkState();
        if (JTermios.ioctl(this.m_FD, JTermios.TIOCMGET, this.m_ioctl) == -1) {
            throw new IllegalStateException();
        }
        return (this.m_ioctl[0] & line) != 0;
    }

    private synchronized void setControlLineState(int line, boolean state) {
        this.checkState();
        if (JTermios.ioctl(this.m_FD, JTermios.TIOCMGET, this.m_ioctl) == -1) {
            throw new IllegalStateException();
        }
        this.m_ioctl[0] = state ? this.m_ioctl[0] | line : this.m_ioctl[0] & ~line;
        if (JTermios.ioctl(this.m_FD, JTermios.TIOCMSET, this.m_ioctl) == -1) {
            throw new IllegalStateException();
        }
    }

    private void setReceiveTimeout() {
        byte vmin = 1;
        byte vtime = 0;
        if (this.m_ReceiveTimeOutEnabled) {
            vmin = 0;
            int t = this.m_ReceiveTimeOutValue;
            if (t < 25500) {
                vtime = (byte)(t / 100);
            } else {
                int n = t / 25500 + 1;
                vtime = (byte)(t / n / 100 + 1);
            }
        }
        this.m_Termios.c_cc[JTermios.VMIN] = vmin;
        this.m_Termios.c_cc[JTermios.VTIME] = vtime;
        this.checkReturnCode(JTermios.tcsetattr(this.m_FD, JTermios.TCSANOW, this.m_Termios));
    }

    private void checkState() {
        if (this.m_FD < 0) {
            throw new IllegalStateException("File descriptor is " + this.m_FD + " < 0, maybe closed by previous error condition");
        }
    }

    private void checkReturnCode(int code) {
        if (code != 0) {
            this.close();
            StackTraceElement ste = Thread.currentThread().getStackTrace()[1];
            String msg = String.format("JTermios call returned %d at %s", code, JTermios.JTermiosLogging.lineno());
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "%s\n", msg);
            throw new IllegalStateException(msg);
        }
    }
}

