/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.asm45;

import nl.lxtreme.ols.api.data.BaseData;

public final class Asm45Data
extends BaseData<Asm45Data> {
    public static final String TYPE_INSTRUCTION = "I";
    public static final String TYPE_DATA_WORD = "DW";
    public static final String TYPE_DATA_BYTE_LEFT = "DBL";
    public static final String TYPE_DATA_BYTE_RIGHT = "DBR";
    private final int clocks;
    private final int block;
    private final int address;
    private final int value;
    private final boolean busGrant;
    private final String type;
    private final String event;

    public Asm45Data(int aIdx, int aChannelIdx, int aStartSampleIdx, int aEndSampleIdx, int aClocks, int aBlock, int aAddress, int aValue, boolean aBusGrant, String aType, String aEvent) {
        super(aIdx, aChannelIdx, aStartSampleIdx, aEndSampleIdx);
        this.clocks = aClocks;
        this.block = aBlock;
        this.address = aAddress;
        this.value = aValue;
        this.busGrant = aBusGrant;
        this.type = aType;
        this.event = aEvent;
    }

    public Asm45Data(int aIdx, int aChannelIdx, int aSampleIdx, String aEventName) {
        super(aIdx, aChannelIdx, aSampleIdx, aEventName);
        this.clocks = 0;
        this.block = 0;
        this.address = 0;
        this.value = 0;
        this.busGrant = false;
        this.type = "";
        this.event = "";
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (!super.equals(aObject) || !(aObject instanceof Asm45Data)) {
            return false;
        }
        Asm45Data other = (Asm45Data)((Object)aObject);
        return this.value == other.value;
    }

    public int getAddress() {
        return this.address;
    }

    public int getBlock() {
        return this.block;
    }

    public boolean getBusGrant() {
        return this.busGrant;
    }

    public int getClocks() {
        return this.clocks;
    }

    public String getEvent() {
        return this.event;
    }

    public String getType() {
        return this.type;
    }

    public int getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.value;
        return result;
    }
}

