/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.api.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.BaseData;

public class BaseDataSet<DATA extends BaseData<DATA>> {
    private final List<DATA> data = new ArrayList<DATA>();
    private final int startOfDecode;
    private final int endOfDecode;
    private final boolean timingDataPresent;
    private final int sampleRate;
    private final boolean triggerDataPresent;
    private final long triggerPosition;
    private final long[] timestamps;

    public BaseDataSet(int aStartOfDecodeIdx, int aEndOfDecodeIdx, AcquisitionResult aData) {
        this.startOfDecode = aStartOfDecodeIdx;
        this.endOfDecode = aEndOfDecodeIdx;
        this.timingDataPresent = aData.hasTimingData();
        this.sampleRate = aData.getSampleRate();
        this.triggerDataPresent = aData.hasTriggerData();
        this.triggerPosition = aData.getTriggerPosition();
        this.timestamps = aData.getTimestamps();
    }

    public final List<DATA> getData() {
        return this.data;
    }

    public final int getEndOfDecode() {
        return this.endOfDecode;
    }

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final int getStartOfDecode() {
        return this.startOfDecode;
    }

    public final double getTime(int aSampleIdx) {
        long time = this.timestamps[aSampleIdx];
        if (this.triggerDataPresent) {
            time -= this.triggerPosition;
        }
        if (this.timingDataPresent) {
            return (double)time / (double)this.sampleRate;
        }
        return time;
    }

    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    protected final void addData(DATA aData) {
        this.data.add(aData);
    }

    protected final int size() {
        return this.data.size();
    }

    protected void sort() {
        Collections.sort(this.data);
    }
}

