/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import nl.lxtreme.ols.util.HostProperties;
import nl.lxtreme.ols.util.HostUtils;
import org.osgi.framework.BundleContext;

public class HostResourceProperties
implements HostProperties {
    private static final String HOST_PROPERTIES = "/host.properties";
    private static final String SHORT_NAME = "LogicSniffer";
    private static final String FULL_NAME = "LogicSniffer".concat(" - Logic Analyzer Client");
    private final Properties properties = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HostResourceProperties(BundleContext aContext) {
        URL resource = aContext.getBundle().getResource(HOST_PROPERTIES);
        if (resource != null) {
            InputStream is = null;
            try {
                is = resource.openStream();
                this.properties.load(is);
            }
            catch (IOException exception) {
            }
            finally {
                HostUtils.closeResource(is);
                resource = null;
            }
            String osName = aContext.getProperty("org.osgi.framework.os.name");
            this.properties.put("org.osgi.framework.os.name", osName);
            String osVersion = aContext.getProperty("org.osgi.framework.os.version");
            this.properties.put("org.osgi.framework.os.version", osVersion);
            String processor = aContext.getProperty("org.osgi.framework.processor");
            this.properties.put("org.osgi.framework.processor", processor);
            String javaVersion = aContext.getProperty("org.osgi.framework.executionenvironment");
            this.properties.put("org.osgi.framework.executionenvironment", javaVersion);
        }
    }

    @Override
    public String getExecutionEnvironment() {
        return System.getProperty("java.vendor") + ", v" + System.getProperty("java.version");
    }

    @Override
    public String getFullName() {
        return FULL_NAME;
    }

    @Override
    public String getOSName() {
        return this.properties.getProperty("org.osgi.framework.os.name");
    }

    @Override
    public String getOSVersion() {
        return this.properties.getProperty("org.osgi.framework.os.version");
    }

    @Override
    public String getProcessor() {
        return this.properties.getProperty("org.osgi.framework.processor");
    }

    @Override
    public String getReportIncidentAddress() {
        return this.properties.getProperty("client.incidentAddress", "info+ols@lxtreme.nl");
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getVersion() {
        return this.properties.getProperty("client.version", "<NO VERSION>");
    }

    @Override
    public boolean isDebugMode() {
        return Boolean.parseBoolean(System.getProperty("nl.lxtreme.ols.client.debug", "false"));
    }
}

