/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.util;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import nl.lxtreme.ols.api.data.Cursor;
import nl.lxtreme.ols.api.data.annotation.DataAnnotation;
import nl.lxtreme.ols.client.action.SmartJumpAction;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramComponent;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;
import nl.lxtreme.ols.client.signaldisplay.util.AnnotationsHelper;

public final class SmartJumpHelper {
    private final SignalDiagramController controller;
    private final SmartJumpAction.JumpDirection direction;
    private final SmartJumpAction.JumpType type;

    public SmartJumpHelper(SignalDiagramController aController, SmartJumpAction.JumpDirection aDirection, SmartJumpAction.JumpType aType) {
        this.controller = aController;
        this.direction = aDirection;
        this.type = aType;
    }

    public long getSmartJumpPosition(int aChannelIndex) {
        Rectangle viewSize = this.getSignalDiagram().getSignalView().getVisibleRect();
        SignalElement signalElement = this.getSignalDiagramModel().getSignalElementManager().getChannelByIndex(aChannelIndex);
        if (signalElement != null) {
            Point refPoint = new Point((int)Math.round(viewSize.getCenterX()), signalElement.getYposition());
            long refTimestamp = this.locationToTimestamp(refPoint);
            switch (this.type) {
                case ANNOTATION: {
                    return this.getAnnotationJumpPosition(signalElement, refTimestamp);
                }
                case CURSOR: {
                    return this.getCursorJumpPosition(refTimestamp);
                }
                case SIGNAL_EDGE: {
                    return this.getSignalEdgeJumpPosition(aChannelIndex, refTimestamp);
                }
            }
        }
        return -1L;
    }

    private long getAnnotationJumpPosition(SignalElement signalElement, long refTimestamp) {
        AnnotationsHelper helper = new AnnotationsHelper(signalElement);
        DataAnnotation<?> annotation = null;
        annotation = this.direction.isLeft() ? helper.getAnnotationBefore(refTimestamp) : helper.getAnnotationAfter(refTimestamp);
        if (annotation != null) {
            long start = annotation.getStartTimestamp();
            long end = annotation.getEndTimestamp();
            return start + (end - start) / 2L;
        }
        return -1L;
    }

    private long getCursorJumpPosition(long refTimestamp) {
        ArrayList<Cursor> cursors = new ArrayList<Cursor>(Arrays.asList(this.getSignalDiagramModel().getDefinedCursors()));
        Collections.sort(cursors, new CursorComparator());
        Cursor foundCursor = null;
        for (Cursor cursor : cursors) {
            long timestamp = cursor.getTimestamp();
            if (this.direction.isLeft()) {
                if (timestamp >= refTimestamp) break;
                foundCursor = cursor;
                continue;
            }
            if (timestamp <= refTimestamp) continue;
            foundCursor = cursor;
            break;
        }
        if (foundCursor != null) {
            return foundCursor.getTimestamp();
        }
        return -1L;
    }

    private SignalDiagramComponent getSignalDiagram() {
        return this.controller.getSignalDiagram();
    }

    private SignalDiagramModel getSignalDiagramModel() {
        return this.controller.getSignalDiagramModel();
    }

    private long getSignalEdgeJumpPosition(int aChannelIndex, long refTimestamp) {
        SignalDiagramModel model = this.getSignalDiagramModel();
        if (this.direction.isLeft()) {
            return model.findEdgeBefore(aChannelIndex, refTimestamp);
        }
        return model.findEdgeAfter(aChannelIndex, refTimestamp);
    }

    private long locationToTimestamp(Point aPoint) {
        return this.getSignalDiagramModel().locationToTimestamp(aPoint);
    }

    private static class CursorComparator
    implements Comparator<Cursor> {
        private CursorComparator() {
        }

        @Override
        public int compare(Cursor aCursor1, Cursor aCursor2) {
            return (int)(aCursor1.getTimestamp() - aCursor2.getTimestamp());
        }
    }
}

