/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.laf;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import nl.lxtreme.ols.api.data.annotation.DataAnnotation;
import nl.lxtreme.ols.client.signaldisplay.MeasurementInfo;
import nl.lxtreme.ols.client.signaldisplay.model.SignalViewModel;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;
import nl.lxtreme.ols.client.signaldisplay.util.AnnotationsHelper;
import nl.lxtreme.ols.client.signaldisplay.util.ArrowRenderer;
import nl.lxtreme.ols.client.signaldisplay.view.SignalView;

public class SignalUI
extends ComponentUI {
    private static final int POINT_COUNT = 1000000;
    private static final int SLOPPY_DRAW_THRESHOLD = 10000;
    private volatile boolean listening = true;
    private volatile MeasurementInfo measurementInfo;
    private volatile Rectangle measurementRect;
    private static final int[] x = new int[2000000];
    private static final int[] y = new int[2000000];

    private static RenderingHints createArrowRenderingHints() {
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        return hints;
    }

    private static RenderingHints createCursorRenderingHints() {
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        return hints;
    }

    private static RenderingHints createSignalRenderingHints(boolean aUseAA) {
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        hints.put(RenderingHints.KEY_ANTIALIASING, aUseAA ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        return hints;
    }

    public Rectangle getMeasurementRect() {
        return this.measurementRect;
    }

    public void handleMeasureEvent(MeasurementInfo aMeasurementInfo) {
        this.measurementInfo = aMeasurementInfo;
        if (aMeasurementInfo != null) {
            this.measurementRect = new Rectangle(aMeasurementInfo.getRectangle());
            this.measurementRect.grow(8, 8);
        } else {
            this.measurementRect = null;
        }
    }

    public boolean isListening() {
        return this.listening;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics aGraphics, JComponent aComponent) {
        SignalView view = (SignalView)aComponent;
        SignalViewModel model = view.getModel();
        if (!model.hasData()) {
            return;
        }
        this.listening = false;
        try {
            Rectangle clip = aGraphics.getClipBounds();
            SignalElement[] signalElements = model.getSignalElements(clip.y, clip.height);
            Graphics2D canvas = (Graphics2D)aGraphics.create();
            try {
                if (signalElements.length > 0) {
                    this.paintSignals(canvas, model, signalElements);
                }
            }
            finally {
                canvas.dispose();
                canvas = null;
            }
            canvas = (Graphics2D)aGraphics;
            if (model.isCursorMode()) {
                this.paintCursors(canvas, model);
            }
            if (model.isMeasurementMode() && MeasurementInfo.isDefined(this.measurementInfo)) {
                this.paintMeasurementArrow(canvas, model, this.measurementInfo);
            }
            this.paintAnnotations(canvas, model, signalElements);
        }
        finally {
            this.listening = true;
        }
    }

    private Stroke getAnnotationLineStroke(boolean renderStyle, double zoomFactor) {
        float strokeWidth = (float)(3.0 / Math.max(1.0, 1.0 / zoomFactor));
        BasicStroke stroke = renderStyle ? new BasicStroke(strokeWidth, 2, 1, 0.9f) : new BasicStroke(strokeWidth, 1, 1, 0.9f);
        return stroke;
    }

    private void paintAnnotations(Graphics2D aCanvas, SignalViewModel aModel, SignalElement[] aSignalElements) {
        long[] timestamps = aModel.getTimestamps();
        if (timestamps == null || timestamps.length == 0 || aSignalElements.length == 0) {
            return;
        }
        Rectangle clip = aCanvas.getClipBounds();
        int startIdx = aModel.getStartIndex(clip);
        int endIdx = aModel.getEndIndex(clip, timestamps.length);
        long startTimestamp = timestamps[startIdx];
        long endTimestamp = timestamps[endIdx];
        double zoomFactor = aModel.getZoomFactor();
        aCanvas.translate(0, aSignalElements[0].getYposition());
        boolean annotationRenderStyle = aModel.isRenderAnnotationAlternatively();
        Stroke stroke = this.getAnnotationLineStroke(annotationRenderStyle, zoomFactor);
        AlphaComposite alphaComposite = AlphaComposite.SrcOver.derive(aModel.getAnnotationAlpha());
        for (SignalElement signalElement : aSignalElements) {
            if (signalElement.isDigitalSignal()) {
                aCanvas.setRenderingHints(SignalUI.createSignalRenderingHints(aModel.isRenderAnnotationAntiAliased()));
                aCanvas.setColor(signalElement.getColor());
                if (signalElement.isEnabled()) {
                    AnnotationsHelper helper = new AnnotationsHelper(signalElement);
                    aCanvas.setFont(aModel.getAnnotationFont());
                    FontMetrics fm = aCanvas.getFontMetrics();
                    int fontHeight = fm.getHeight();
                    for (DataAnnotation ann : helper.getAnnotations(DataAnnotation.class, startTimestamp, endTimestamp)) {
                        long annStartTime = ann.getStartTimestamp();
                        long annEndTime = ann.getEndTimestamp();
                        int x1 = (int)((double)annStartTime * zoomFactor);
                        int x2 = (int)((double)annEndTime * zoomFactor);
                        int y1 = signalElement.getOffset(aModel.getAnnotationAlignment());
                        int y2 = y1 + signalElement.getSignalHeight();
                        int midY = y1 + (y2 - y1) / 2;
                        String annText = ann.getAnnotation().toString();
                        int annotationWidth = x2 - x1 + 2;
                        Composite oldComposite = aCanvas.getComposite();
                        Stroke oldStroke = aCanvas.getStroke();
                        aCanvas.setComposite(alphaComposite);
                        aCanvas.setColor(aModel.getBackgroundColor());
                        if (annotationRenderStyle) {
                            aCanvas.fillRect(x1, y1 + 0, annotationWidth, y2 - y1 + 1);
                        } else {
                            aCanvas.fillRect(x1, y1 + 1, annotationWidth, y2 - y1 - 1);
                        }
                        aCanvas.setComposite(oldComposite);
                        aCanvas.setColor(aModel.getAnnotationColor());
                        aCanvas.setStroke(stroke);
                        aCanvas.drawLine(x1, y1 + 2, x1, y2 - 2);
                        aCanvas.drawLine(x2, y1 + 2, x2, y2 - 2);
                        aCanvas.setStroke(oldStroke);
                        int textWidth = fm.stringWidth(annText);
                        int textXoffset = (int)((double)(annotationWidth - textWidth) / 2.0);
                        if (textXoffset <= 0) continue;
                        int x3 = x1 + textXoffset;
                        if (annotationRenderStyle && x3 - 4 > 0) {
                            aCanvas.drawLine(x1, midY, x3 - 4, midY);
                            aCanvas.drawLine(x3 + textWidth + 8, midY, x2, midY);
                        }
                        aCanvas.drawString(annText, x1 + textXoffset, y1 + fontHeight);
                    }
                }
            }
            aCanvas.translate(0, signalElement.getHeight() + aModel.getSignalElementSpacing());
        }
    }

    private void paintCursors(Graphics2D aCanvas, SignalViewModel aModel) {
        Rectangle clip = aCanvas.getClipBounds();
        aCanvas.setRenderingHints(SignalUI.createCursorRenderingHints());
        for (int i = 0; i < 10; ++i) {
            int cursorXpos = aModel.getCursorScreenCoordinate(i);
            if (cursorXpos < 0 || !clip.contains(cursorXpos, clip.y)) continue;
            aCanvas.setColor(aModel.getCursorColor(i));
            aCanvas.drawLine(cursorXpos, clip.y, cursorXpos, clip.y + clip.height);
        }
    }

    private void paintMeasurementArrow(Graphics2D aCanvas, SignalViewModel aModel, MeasurementInfo aMeasurementInfo) {
        Rectangle signalHoverRect = aMeasurementInfo.getRectangle();
        int x = signalHoverRect.x;
        int y = (int)signalHoverRect.getCenterY();
        int w = signalHoverRect.width;
        int middlePos = aMeasurementInfo.getMidSamplePos() - x;
        aCanvas.setRenderingHints(SignalUI.createArrowRenderingHints());
        aCanvas.setColor(aModel.getMeasurementArrowColor());
        aCanvas.translate(x, y);
        ArrowRenderer.render(aCanvas, w, middlePos);
        aCanvas.translate(-x, -y);
    }

    private void paintSignals(Graphics2D aCanvas, SignalViewModel aModel, SignalElement[] aSignalElements) {
        long triggerOffset;
        int[] values = aModel.getDataValues();
        long[] timestamps = aModel.getTimestamps();
        Rectangle clip = aCanvas.getClipBounds();
        aCanvas.setBackground(aModel.getBackgroundColor());
        aCanvas.clearRect(clip.x, clip.y, clip.width, clip.height);
        int startIdx = aModel.getStartIndex(clip);
        int endIdx = aModel.getEndIndex(clip, values.length);
        double zoomFactor = aModel.getZoomFactor();
        if (aModel.hasTriggerData() && timestamps[startIdx] <= (triggerOffset = aModel.getTriggerOffset()) && timestamps[endIdx] >= triggerOffset) {
            int x = (int)Math.round((double)triggerOffset * zoomFactor) - 1;
            aCanvas.setColor(aModel.getTriggerColor());
            aCanvas.drawLine(x, clip.y, x, clip.y + clip.height);
        }
        aCanvas.translate(0, aSignalElements[0].getYposition());
        boolean enableSloppyScopePainting = aModel.isSloppyScopeRenderingAllowed();
        int lastP = 0;
        for (SignalElement signalElement : aSignalElements) {
            aCanvas.setColor(signalElement.getColor());
            if (signalElement.isSignalGroup()) {
                // empty if block
            }
            if (signalElement.isDigitalSignal()) {
                int signalHeight = signalElement.getSignalHeight();
                int signalOffset = signalElement.getOffset();
                aCanvas.setRenderingHints(SignalUI.createSignalRenderingHints(false));
                aCanvas.translate(0, signalOffset);
                if (!signalElement.isEnabled() || startIdx == endIdx) {
                    aCanvas.drawLine(clip.x, signalHeight, clip.x + clip.width, signalHeight);
                } else {
                    int mask = signalElement.getMask();
                    long timestamp = timestamps[startIdx];
                    int prevSampleValue = values[startIdx] & mask;
                    int xValue = (int)(zoomFactor * (double)timestamp);
                    int yValue = prevSampleValue == 0 ? signalHeight : 0;
                    SignalUI.x[0] = xValue;
                    SignalUI.y[0] = yValue;
                    int p = 1;
                    for (int sampleIdx = startIdx + 1; p < 1000000 && sampleIdx <= endIdx; ++p, ++sampleIdx) {
                        timestamp = timestamps[sampleIdx];
                        int sampleValue = values[sampleIdx] & mask;
                        xValue = (int)(zoomFactor * (double)timestamp);
                        if (prevSampleValue != sampleValue) {
                            SignalUI.x[p] = xValue;
                            SignalUI.y[p] = prevSampleValue == 0 ? signalHeight : 0;
                            ++p;
                        }
                        SignalUI.x[p] = xValue;
                        SignalUI.y[p] = sampleValue == 0 ? signalHeight : 0;
                        prevSampleValue = sampleValue;
                    }
                    aCanvas.drawPolyline(x, y, p);
                    lastP = (int)((double)p * 0.1 + (double)lastP * 0.9);
                }
                aCanvas.translate(0, -signalOffset);
            }
            int sampleIncr = 1;
            if (enableSloppyScopePainting && lastP > 10000) {
                sampleIncr = (int)Math.max(1.0, 1.0 / zoomFactor);
            }
            if (signalElement.isGroupSummary()) {
                aCanvas.setRenderingHints(SignalUI.createSignalRenderingHints(aModel.isRenderGroupSummaryAntiAliased()));
                int mask = signalElement.getMask();
                int padding = aModel.getGroupSummaryPadding();
                int prevSampleValue = values[startIdx] & mask;
                int prevX = (int)(zoomFactor * (double)timestamps[startIdx]);
                aCanvas.setFont(aModel.getGroupSummaryTextFont());
                FontMetrics fm = aCanvas.getFontMetrics();
                int textYpos = (int)((double)(signalElement.getHeight() + fm.getLeading() + fm.getMaxAscent()) / 2.0) - padding;
                for (int sampleIdx = startIdx + 1; sampleIdx < endIdx; sampleIdx += sampleIncr) {
                    int sampleValue = values[sampleIdx] & mask;
                    if (sampleValue != prevSampleValue) {
                        int cellWidth;
                        int x = (int)(zoomFactor * (double)timestamps[sampleIdx]);
                        String text = String.format("%02X", prevSampleValue);
                        int textWidth = fm.stringWidth(text) + 2 * padding;
                        if (textWidth < (cellWidth = x - prevX)) {
                            int textXpos = prevX + (int)((double)(cellWidth - textWidth) / 2.0) + padding;
                            aCanvas.setColor(signalElement.getColor());
                            aCanvas.drawString(text, textXpos, textYpos);
                        }
                        aCanvas.setColor(aModel.getGroupSummaryBarColor());
                        aCanvas.drawLine(x, padding, x, signalElement.getHeight() - padding);
                        prevX = x;
                    }
                    prevSampleValue = sampleValue;
                }
            }
            if (signalElement.isAnalogSignal()) {
                aCanvas.setRenderingHints(SignalUI.createSignalRenderingHints(aModel.isRenderScopeSignalAntiAliased()));
                aCanvas.setColor(signalElement.getColor());
                long mask = (long)signalElement.getMask() & 0xFFFFFFFFL;
                int trailingZeros = Long.numberOfTrailingZeros(mask);
                int onesCount = 64 - Long.numberOfLeadingZeros(mask) - trailingZeros;
                long maxValue = (1L << onesCount) - 1L & 0xFFFFFFFFL;
                double scaleFactor = maxValue == 0L ? 1.0 : (double)signalElement.getHeight() / (double)maxValue;
                int p = 0;
                if (startIdx == endIdx) {
                    SignalUI.x[p] = clip.x;
                    SignalUI.y[p] = signalElement.getHeight();
                    ++p;
                } else {
                    for (int sampleIdx = startIdx; p < 1000000 && sampleIdx < endIdx; ++p, sampleIdx += sampleIncr) {
                        long timestamp = timestamps[sampleIdx];
                        int sampleValue = (int)(((long)values[sampleIdx] & mask) >> trailingZeros);
                        int i_max = Math.min(endIdx, sampleIdx + sampleIncr - 1);
                        for (int i = sampleIdx + 1; i < i_max; ++i) {
                            sampleValue = (int)((long)sampleValue + (((long)values[i] & mask) >> trailingZeros));
                        }
                        sampleValue = (int)((double)maxValue - (double)sampleValue / (double)sampleIncr);
                        SignalUI.x[p] = (int)(zoomFactor * (double)timestamp);
                        SignalUI.y[p] = (int)(scaleFactor * (double)sampleValue);
                    }
                }
                SignalUI.x[p] = clip.x + clip.width;
                SignalUI.y[p] = y[p - 1];
                aCanvas.drawPolyline(x, y, ++p);
            }
            aCanvas.translate(0, signalElement.getHeight() + aModel.getSignalElementSpacing());
        }
    }
}

