/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.action;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import nl.lxtreme.ols.api.data.Cursor;
import nl.lxtreme.ols.client.actionmanager.IManagedAction;
import nl.lxtreme.ols.client.icons.IconFactory;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;

public class GotoNthCursorAction
extends AbstractAction
implements IManagedAction {
    private static final long serialVersionUID = 1L;
    private static final String ID_PREFIX = "GotoCursor";
    private final int index;
    private final SignalDiagramController controller;

    public GotoNthCursorAction(SignalDiagramController aController, int aIndex) {
        this.controller = aController;
        this.index = aIndex;
        String cursorStr = String.valueOf(aIndex + 1);
        this.putValue("Name", "Go to cursor " + cursorStr);
        this.putValue("ShortDescription", "Go to the " + GotoNthCursorAction.getOrdinalNumber(aIndex + 1) + " cursor in the diagram");
        this.putValue("SwingLargeIconKey", IconFactory.createOverlayIcon("go-jump.png", cursorStr));
        int keyStroke = 48 + (aIndex + 1) % 10;
        if (keyStroke != 48) {
            int mask = SwingComponentUtils.getMenuShortcutKeyMask();
            this.putValue("AcceleratorKey", SwingComponentUtils.createKeyMask((int)keyStroke, (int[])new int[]{mask}));
        }
        this.putValue("MnemonicKey", keyStroke);
    }

    public static String getID(int aCursorIdx) {
        if (aCursorIdx < 0 || aCursorIdx >= 10) {
            throw new IllegalArgumentException("Invalid cursor index, should be between 0 and 10");
        }
        return ID_PREFIX + aCursorIdx;
    }

    private static String getOrdinalNumber(int aValue) {
        String suffix = "";
        if (aValue == 1 || aValue == 21 || aValue == 31) {
            suffix = "st";
        } else if (aValue == 2 || aValue == 22) {
            suffix = "nd";
        } else if (aValue == 3 || aValue == 23) {
            suffix = "rd";
        } else if (aValue >= 0 && aValue < 40) {
            suffix = "th";
        }
        return String.format("%d%s", aValue, suffix);
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        Cursor[] definedCursors;
        for (Cursor cursor : definedCursors = this.controller.getDefinedCursors()) {
            if (this.index != cursor.getIndex() || !cursor.isDefined()) continue;
            this.controller.scrollToTimestamp(cursor.getTimestamp());
        }
    }

    @Override
    public String getId() {
        return GotoNthCursorAction.getID(this.index);
    }
}

