/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.api.acquisition;

public final class AcquisitionResultStatus {
    private final ResultStatus status;
    private final String message;

    public AcquisitionResultStatus(ResultStatus aStatus) {
        this(aStatus, null);
    }

    public AcquisitionResultStatus(ResultStatus aStatus, String aMessage) {
        this.status = aStatus;
        this.message = aMessage;
    }

    public static AcquisitionResultStatus create(Throwable aThrowable) {
        return new AcquisitionResultStatus(ResultStatus.FAILED, aThrowable.getMessage());
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (aObject == null || !(aObject instanceof AcquisitionResultStatus)) {
            return false;
        }
        AcquisitionResultStatus other = (AcquisitionResultStatus)aObject;
        if (this.status != other.status) {
            return false;
        }
        return !(this.message == null ? other.message != null : !this.message.equals(other.message));
    }

    public String getMessage() {
        return this.message;
    }

    public ResultStatus getStatus() {
        return this.status;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean isAborted() {
        return this.status == ResultStatus.ABORTED;
    }

    public boolean isCompletedNormally() {
        return this.status == ResultStatus.NORMAL;
    }

    public boolean isFailed() {
        return this.status == ResultStatus.FAILED;
    }

    public static enum ResultStatus {
        NORMAL,
        ABORTED,
        FAILED;

    }
}

