/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.device.generic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import nl.lxtreme.ols.api.Configurable;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.util.NumberUtils;
import nl.lxtreme.ols.util.swing.SpringLayoutUtils;
import nl.lxtreme.ols.util.swing.StandardActionFactory;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import nl.lxtreme.ols.util.swing.validation.JComponentInputVerifier;

public class GenericDeviceConfigDialog
extends JDialog
implements Configurable,
StandardActionFactory.CloseAction.Closeable {
    private static final long serialVersionUID = 1L;
    private JTextField devicePath;
    private JTextField sampleRate;
    private JTextField sampleDepth;
    private JTextField sampleWidth;
    private JTextField channelCount;
    private boolean setupConfirmed;

    public GenericDeviceConfigDialog(Window aParent) {
        super(aParent, "Generic capture settings", Dialog.ModalityType.DOCUMENT_MODAL);
        this.initDialog();
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public int getChannelCount() {
        int result = NumberUtils.smartParseInt((String)this.channelCount.getText(), (int)8);
        return result;
    }

    public String getDevicePath() {
        return this.devicePath.getText();
    }

    public int getEnabledChannelsMask() {
        int bits = 8 * this.getSampleWidth();
        int width = (int)((1L << bits) - 1L);
        return width;
    }

    public int getSampleDepth() {
        int result = NumberUtils.smartParseInt((String)this.sampleDepth.getText(), (int)1024);
        return result;
    }

    public int getSampleRate() {
        int result = NumberUtils.smartParseInt((String)this.sampleRate.getText(), (int)1000000);
        return result;
    }

    public int getSampleWidth() {
        int result = NumberUtils.smartParseInt((String)this.sampleWidth.getText(), (int)1);
        return result;
    }

    public void readPreferences(UserSettings aSettings) {
        this.channelCount.setText(aSettings.get("channelCount", this.channelCount.getText()));
        this.devicePath.setText(aSettings.get("devicePath", this.devicePath.getText()));
        this.sampleDepth.setText(aSettings.get("sampleDepth", this.sampleDepth.getText()));
        this.sampleRate.setText(aSettings.get("sampleRate", this.sampleRate.getText()));
        this.sampleWidth.setText(aSettings.get("sampleWidth", this.sampleWidth.getText()));
    }

    public boolean showDialog() {
        this.setupConfirmed = false;
        this.setVisible(true);
        return this.setupConfirmed;
    }

    public void writePreferences(UserSettings aSettings) {
        aSettings.put("channelCount", this.channelCount.getText());
        aSettings.put("devicePath", this.devicePath.getText());
        aSettings.put("sampleDepth", this.sampleDepth.getText());
        aSettings.put("sampleRate", this.sampleRate.getText());
        aSettings.put("sampleWidth", this.sampleWidth.getText());
    }

    private JComponent createContents() {
        this.channelCount = new JTextField(10);
        this.channelCount.setText("1");
        this.channelCount.setInputVerifier((InputVerifier)JComponentInputVerifier.create(Integer.TYPE, (String)"Invalid channel count!"));
        this.devicePath = new JTextField(10);
        this.sampleDepth = new JTextField(10);
        this.sampleDepth.setText("256");
        this.sampleDepth.setInputVerifier((InputVerifier)JComponentInputVerifier.create(Integer.TYPE, (String)"Invalid sample depth!"));
        this.sampleRate = new JTextField(10);
        this.sampleRate.setText("1000000");
        this.sampleRate.setInputVerifier((InputVerifier)JComponentInputVerifier.create(Integer.TYPE, (String)"Invalid sample rate!"));
        this.sampleWidth = new JTextField(10);
        this.sampleWidth.setText("1");
        this.sampleWidth.setInputVerifier((InputVerifier)JComponentInputVerifier.create(Integer.TYPE, (String)"Invalid sample width!"));
        JPanel result = new JPanel(new SpringLayout());
        SpringLayoutUtils.addSeparator((Container)result, (String)"Acquisition settings");
        result.add(SwingComponentUtils.createRightAlignedLabel((String)"Device path"));
        result.add(this.devicePath);
        result.add(SwingComponentUtils.createRightAlignedLabel((String)"Channel count"));
        result.add(this.channelCount);
        result.add(SwingComponentUtils.createRightAlignedLabel((String)"Sample rate"));
        result.add(this.sampleRate);
        result.add(SwingComponentUtils.createRightAlignedLabel((String)"Sample depth"));
        result.add(this.sampleDepth);
        result.add(SwingComponentUtils.createRightAlignedLabel((String)"Sample width"));
        result.add(this.sampleWidth);
        SpringLayoutUtils.makeEditorGrid((Container)result, (int)6, (int)6);
        return result;
    }

    private void initDialog() {
        JComponent contents = this.createContents();
        JButton closeButton = StandardActionFactory.createCloseButton();
        JButton okButton = new JButton("Ok");
        okButton.setPreferredSize(closeButton.getPreferredSize());
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                GenericDeviceConfigDialog.this.setupConfirmed = true;
                GenericDeviceConfigDialog.this.close();
            }
        });
        JComponent buttonPane = SwingComponentUtils.createButtonPane((JButton[])new JButton[]{okButton, closeButton});
        SwingComponentUtils.setupDialogContentPane((JDialog)this, (Component)contents, (Component)buttonPane, (JButton)okButton);
    }
}

