/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.uart;

import java.util.Arrays;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.Edge;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolProgressListener;
import nl.lxtreme.ols.util.NumberUtils;

public class AsyncSerialDataDecoder {
    public static final int[] COMMON_BAUDRATES = new int[]{150, 300, 600, 1200, 2400, 4800, 9600, 14400, 19200, 28800, 38400, 57600, 76800, 115200, 230400, 460800, 921600};
    protected final SerialConfiguration configuration;
    protected final AcquisitionResult dataSet;
    protected final ToolContext context;
    private SerialDecoderCallback callback;
    private ToolProgressListener progressListener;

    public AsyncSerialDataDecoder(SerialConfiguration aConfiguration, ToolContext aContext) {
        this.configuration = aConfiguration;
        this.context = aContext;
        this.dataSet = aContext.getData();
    }

    protected static final int findSampleIndex(long[] aTimestamps, long aTimeValue) {
        int k = Arrays.binarySearch(aTimestamps, aTimeValue);
        if (k < 0) {
            k = -(k + 1);
        }
        return k;
    }

    public int decodeDataLine(int aChannelIndex) {
        int frameSize = this.configuration.getFrameSize(this.dataSet.getSampleRate());
        int bitLength = this.configuration.getBitLength(this.dataSet.getSampleRate());
        int bitCount = this.configuration.getDataBits();
        StopBits stopBits = this.configuration.getStopBits();
        Parity parity = this.configuration.getParity();
        int bitCenter = bitLength / 2;
        int mask = 1 << aChannelIndex;
        long[] timestamps = this.dataSet.getTimestamps();
        long startOfDecode = timestamps[this.context.getStartSampleIndex()];
        long endOfDecode = timestamps[this.context.getEndSampleIndex()];
        long time = startOfDecode;
        this.setProgress(0);
        int symbolCount = 0;
        while (endOfDecode - time > (long)frameSize && (time = this.findStartBit(aChannelIndex, this.isInverted() ? Edge.RISING : Edge.FALLING, time, endOfDecode)) >= 0L) {
            if (!this.isSpace(time += (long)bitCenter, mask) && this.callback != null) {
                this.callback.onError(aChannelIndex, ErrorType.START, time);
            }
            long startTime = time + (long)bitCenter;
            long endTime = startTime + (long)(bitCount * bitLength) - 1L;
            int symbol = 0;
            for (int bitIdx = 0; bitIdx < bitCount; ++bitIdx) {
                if (!this.isMark(time += (long)bitLength, mask)) continue;
                symbol |= 1 << bitIdx;
            }
            symbol = this.decodeSymbol(symbol, bitCount);
            ++symbolCount;
            if (this.callback != null) {
                this.callback.onSymbol(aChannelIndex, symbol, startTime, endTime);
            }
            if (parity.isOdd() || parity.isEven()) {
                int expectedValue;
                int actualBitCount = Integer.bitCount(symbol);
                if (parity.isOdd()) {
                    expectedValue = actualBitCount % 2 == 0 ? mask : 0;
                } else {
                    int n = expectedValue = actualBitCount % 2 == 1 ? mask : 0;
                }
                if (!this.isExpectedLevel(time += (long)bitLength, mask, expectedValue) && this.callback != null) {
                    this.callback.onError(aChannelIndex, ErrorType.PARITY, time);
                }
            }
            time += (long)bitLength;
            double stopBitCount = stopBits.getValue();
            while (stopBitCount > 0.0) {
                if (!this.isMark(time, mask) && this.callback != null) {
                    this.callback.onError(aChannelIndex, ErrorType.FRAME, time);
                }
                time = (long)((double)time + (stopBitCount -= stopBitCount > 1.0 ? 1.0 : stopBitCount) * (double)bitLength);
            }
            this.setProgress(NumberUtils.getPercentage((long)time, (long)startOfDecode, (long)endOfDecode));
        }
        this.setProgress(100);
        return symbolCount;
    }

    public void setCallback(SerialDecoderCallback aCallback) {
        this.callback = aCallback;
    }

    public final void setProgressListener(ToolProgressListener aProgressListener) {
        this.progressListener = aProgressListener;
    }

    protected final long findEdge(int aChannelIndex, Edge aSampleEdge, long aStartOfDecode, long aEndOfDecode) {
        int mask = 1 << aChannelIndex;
        long result = -1L;
        int oldBitValue = this.getDataValue(aStartOfDecode, mask);
        for (long timeCursor = aStartOfDecode + 1L; result < 0L && timeCursor < aEndOfDecode; ++timeCursor) {
            int bitValue = this.getDataValue(timeCursor, mask);
            Edge edge = Edge.toEdge((int)oldBitValue, (int)bitValue);
            if (aSampleEdge == edge) {
                result = timeCursor;
            }
            oldBitValue = bitValue;
        }
        return result;
    }

    protected long findStartBit(int aChannelIndex, Edge aEdge, long aStartOfDecode, long aEndOfDecode) {
        return this.findEdge(aChannelIndex, aEdge, aStartOfDecode, aEndOfDecode);
    }

    protected final SerialDecoderCallback getCallback() {
        return this.callback;
    }

    protected final int getDataValue(long aTimeValue, int aMask) {
        int value;
        int[] values = this.dataSet.getValues();
        long[] timestamps = this.dataSet.getTimestamps();
        int k = AsyncSerialDataDecoder.findSampleIndex(timestamps, aTimeValue);
        int n = value = k == 0 ? values[0] : values[k - 1];
        if (this.isInverted()) {
            value ^= 0xFFFFFFFF;
        }
        return value & aMask;
    }

    protected final boolean isMark(long aTimestamp, int aMask) {
        return this.isExpectedLevel(aTimestamp, aMask, this.isInverted() ? 0 : aMask);
    }

    protected final boolean isSpace(long aTimestamp, int aMask) {
        return this.isExpectedLevel(aTimestamp, aMask, this.isInverted() ? aMask : 0);
    }

    protected final void setProgress(int aProgress) {
        if (this.progressListener != null) {
            this.progressListener.setProgress(aProgress);
        }
    }

    private int decodeSymbol(int aSymbol, int aBitCount) {
        if (this.isInverted()) {
            aSymbol = ~aSymbol & NumberUtils.getBitMask((int)aBitCount);
        }
        if (this.configuration.isMostSignificantBitFirst()) {
            aSymbol = NumberUtils.reverseBits((int)aSymbol, (int)aBitCount);
        }
        return aSymbol;
    }

    private boolean isExpectedLevel(long aTimestamp, int aMask, int aExpectedMask) {
        return this.getDataValue(aTimestamp, aMask) == aExpectedMask;
    }

    private boolean isInverted() {
        return this.configuration.isInverted();
    }

    public static enum StopBits {
        ONE,
        ONE_HALF,
        TWO;


        public double getValue() {
            if (this == ONE_HALF) {
                return 1.5;
            }
            if (this == TWO) {
                return 2.0;
            }
            return 1.0;
        }
    }

    public static interface SerialDecoderCallback {
        public void onError(int var1, ErrorType var2, long var3);

        public void onEvent(int var1, String var2, long var3, long var5);

        public void onSymbol(int var1, int var2, long var3, long var5);
    }

    public static class SerialConfiguration {
        private final int dataBits;
        private final int baudRate;
        private final StopBits stopBits;
        private final Parity parity;
        private final boolean inverted;
        private final boolean msbFirst;

        public SerialConfiguration() {
            this(9600, 8, StopBits.ONE, Parity.NONE, false, false);
        }

        public SerialConfiguration(int aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity, boolean aInverted, boolean aMsbFirst) {
            this.baudRate = aBaudRate;
            this.dataBits = aDataBits;
            this.stopBits = aStopBits;
            this.parity = aParity;
            this.inverted = aInverted;
            this.msbFirst = aMsbFirst;
        }

        public int getBaudRate() {
            return this.baudRate;
        }

        public int getBitLength(int aSampleRate) {
            return aSampleRate / this.baudRate;
        }

        public int getDataBits() {
            return this.dataBits;
        }

        public int getFrameSize(int aSampleRate) {
            int bitLength = this.getBitLength(aSampleRate);
            int stopCount = (int)Math.ceil(this.stopBits.getValue());
            int parityCount = this.parity.isNone() ? 0 : 1;
            return (this.dataBits + stopCount + parityCount) * bitLength;
        }

        public Parity getParity() {
            return this.parity;
        }

        public StopBits getStopBits() {
            return this.stopBits;
        }

        public boolean isInverted() {
            return this.inverted;
        }

        public boolean isMostSignificantBitFirst() {
            return this.msbFirst;
        }
    }

    public static enum Parity {
        NONE,
        ODD,
        EVEN;


        public boolean isEven() {
            return this == EVEN;
        }

        public boolean isNone() {
            return this == NONE;
        }

        public boolean isOdd() {
            return this == ODD;
        }
    }

    public static enum ErrorType {
        START,
        PARITY,
        FRAME;

    }
}

