/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay;

import java.awt.Rectangle;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;

public final class MeasurementInfo {
    private final int channelIdx;
    private final String channelLabel;
    private final double refTime;
    private final Long startTimestamp;
    private final Long transitionTimestamp;
    private final Long endTimestamp;
    private final Rectangle rectangle;
    private final Double highTime;
    private final Double totalTime;
    private final Integer midSamplePos;
    private final boolean hasTimingData;

    public MeasurementInfo(SignalElement aElement, double aRefTime) {
        this.channelIdx = aElement.getChannel().getIndex();
        this.channelLabel = aElement.getLabel();
        this.rectangle = new Rectangle();
        this.startTimestamp = null;
        this.transitionTimestamp = null;
        this.endTimestamp = null;
        this.refTime = aRefTime;
        this.totalTime = null;
        this.highTime = null;
        this.midSamplePos = null;
        this.hasTimingData = false;
    }

    public MeasurementInfo(SignalElement aElement, long aStartState, long aTransitionState, long aEndState, double aRefState, double aZoomFactor, double aSampleRate) {
        this.channelIdx = aElement.getChannel().getIndex();
        this.channelLabel = aElement.getLabel();
        this.startTimestamp = aStartState;
        this.endTimestamp = aEndState;
        this.transitionTimestamp = aTransitionState;
        this.refTime = aRefState;
        this.midSamplePos = (int)((double)aTransitionState * aZoomFactor);
        this.highTime = null;
        this.totalTime = null;
        this.rectangle = new Rectangle();
        this.rectangle.x = (int)(aZoomFactor * (double)aStartState);
        this.rectangle.width = (int)(aZoomFactor * (double)(aEndState - aStartState));
        this.rectangle.y = aElement.getYposition() + aElement.getOffset();
        this.rectangle.height = aElement.getSignalHeight();
        this.hasTimingData = false;
    }

    public MeasurementInfo(SignalElement aElement, long aStartTime, long aTransitionTime, long aEndTime, long aHighTime, double aRefTime, double aZoomFactor, double aSampleRate) {
        this.channelIdx = aElement.getChannel().getIndex();
        this.channelLabel = aElement.getLabel();
        this.startTimestamp = aStartTime;
        this.endTimestamp = aEndTime;
        this.transitionTimestamp = aTransitionTime;
        this.refTime = aRefTime;
        this.midSamplePos = (int)((double)aTransitionTime * aZoomFactor);
        this.highTime = (double)aHighTime / aSampleRate;
        this.totalTime = (double)(aEndTime - aStartTime) / aSampleRate;
        this.rectangle = new Rectangle();
        this.rectangle.x = (int)(aZoomFactor * (double)aStartTime);
        this.rectangle.width = (int)(aZoomFactor * (double)(aEndTime - aStartTime));
        this.rectangle.y = aElement.getYposition() + aElement.getOffset();
        this.rectangle.height = aElement.getSignalHeight();
        this.hasTimingData = true;
    }

    public static boolean isDefined(MeasurementInfo aMeasurementInfo) {
        return aMeasurementInfo != null && !aMeasurementInfo.isEmpty();
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (aObject == null || this.getClass() != aObject.getClass()) {
            return false;
        }
        MeasurementInfo other = (MeasurementInfo)aObject;
        if (this.channelIdx != other.channelIdx) {
            return false;
        }
        if (this.endTimestamp == null ? other.endTimestamp != null : !this.endTimestamp.equals(other.endTimestamp)) {
            return false;
        }
        if (this.midSamplePos == null ? other.midSamplePos != null : !this.midSamplePos.equals(other.midSamplePos)) {
            return false;
        }
        if (Double.doubleToLongBits(this.refTime) != Double.doubleToLongBits(other.refTime)) {
            return false;
        }
        return !(this.startTimestamp == null ? other.startTimestamp != null : !this.startTimestamp.equals(other.startTimestamp));
    }

    public int getChannelIndex() {
        return this.channelIdx;
    }

    public String getChannelLabel() {
        return this.channelLabel;
    }

    public Double getDutyCycle() {
        if (this.highTime == null || this.totalTime == null) {
            return null;
        }
        return 100.0 * this.highTime / this.totalTime;
    }

    public Long getEndTimestamp() {
        return this.endTimestamp;
    }

    public Double getHighTime() {
        return this.highTime;
    }

    public Double getLowTime() {
        if (this.totalTime == null || this.highTime == null) {
            return null;
        }
        return this.totalTime - this.highTime;
    }

    public Integer getMidSamplePos() {
        return this.midSamplePos;
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public double getReferenceTime() {
        return this.refTime;
    }

    public Long getStartTimestamp() {
        return this.startTimestamp;
    }

    public Double getTotalTime() {
        return this.totalTime;
    }

    public Long getTransitionTimestamp() {
        return this.transitionTimestamp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.channelIdx;
        result = 31 * result + (this.endTimestamp == null ? 0 : this.endTimestamp.hashCode());
        result = 31 * result + (this.midSamplePos == null ? 0 : this.midSamplePos.hashCode());
        long temp = Double.doubleToLongBits(this.refTime);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.startTimestamp == null ? 0 : this.startTimestamp.hashCode());
        return result;
    }

    public boolean hasTimingData() {
        return this.hasTimingData;
    }

    public boolean isEmpty() {
        return this.rectangle.isEmpty();
    }
}

