/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.osgi;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import nl.lxtreme.ols.api.Configurable;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.api.data.project.Project;
import nl.lxtreme.ols.api.data.project.ProjectManager;
import nl.lxtreme.ols.api.data.project.UserSettingsManager;
import nl.lxtreme.ols.util.HostUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.osgi.service.log.LogService;
import org.osgi.service.prefs.Preferences;
import org.osgi.service.prefs.PreferencesService;

public class UserSessionManager {
    private static final String IMPLICIT_USER_SETTING_NAME_PREFIX = "nl.lxtreme.ols.client";
    private static final String IMPLICIT_USER_SETTING_NAME_SUFFIX = "settings";
    private volatile DependencyManager dependencyManager;
    private volatile ProjectManager projectManager;
    private volatile UserSettingsManager userSettingsManager;
    private volatile LogService log;
    private Component windowStateComponent;

    public void start() {
        this.loadImplicitUserSettings();
        this.windowStateComponent = this.dependencyManager.createComponent();
        this.windowStateComponent.setImplementation((Object)new WindowStateListener()).add((Dependency)this.dependencyManager.createServiceDependency().setService(ProjectManager.class).setRequired(true)).add((Dependency)this.dependencyManager.createServiceDependency().setService(PreferencesService.class).setRequired(true)).add((Dependency)this.dependencyManager.createServiceDependency().setService(LogService.class).setRequired(false));
        this.dependencyManager.add(this.windowStateComponent);
    }

    public void stop() {
        this.saveImplicitUserSettings();
        this.dependencyManager.remove(this.windowStateComponent);
    }

    private File getUserSettingsFile() {
        return HostUtils.createLocalDataFile((String)IMPLICIT_USER_SETTING_NAME_PREFIX, (String)IMPLICIT_USER_SETTING_NAME_SUFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImplicitUserSettings() {
        File userSettingsFile = this.getUserSettingsFile();
        Project currentProject = this.projectManager.getCurrentProject();
        try {
            this.userSettingsManager.loadUserSettings(userSettingsFile, currentProject);
            this.log.log(4, "User settings restored ...");
        }
        finally {
            currentProject.setChanged(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveImplicitUserSettings() {
        Project currentProject = this.projectManager.getCurrentProject();
        if (currentProject.isChanged()) {
            try {
                File userSettingsFile = this.getUserSettingsFile();
                this.userSettingsManager.saveUserSettings(userSettingsFile, currentProject);
                this.log.log(4, "User settings stored ...");
            }
            finally {
                currentProject.setChanged(false);
            }
        }
    }

    static class WindowStateListener
    implements AWTEventListener {
        private volatile PreferencesService preferenceService;
        private volatile ProjectManager projectManager;
        private volatile LogService logger;
        private final ConcurrentMap<String, Boolean> prefsLoaded;
        private final String userName = System.getProperty("user.name", "default");

        public WindowStateListener() {
            this.prefsLoaded = new ConcurrentHashMap<String, Boolean>();
        }

        @Override
        public void eventDispatched(AWTEvent aEvent) {
            ComponentEvent event = (ComponentEvent)aEvent;
            Window component = (Window)event.getComponent();
            String namespace = component.getClass().getName();
            int id = aEvent.getID();
            if (id == 200) {
                if (this.arePreferencesLoaded(namespace)) {
                    return;
                }
                this.loadPreferences(component, namespace);
            } else if (id == 202) {
                if (this.arePreferencesSaved(namespace)) {
                    return;
                }
                this.savePreferences(component, namespace);
            }
        }

        public void start() {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
            this.logger.log(4, "AWT Window state listener installed...");
        }

        public void stop() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            this.logger.log(4, "AWT Window state listener removed...");
        }

        final void setLogger(LogService aLogger) {
            this.logger = aLogger;
        }

        final void setPreferenceService(PreferencesService aPreferenceService) {
            this.preferenceService = aPreferenceService;
        }

        final void setProjectManager(ProjectManager aProjectManager) {
            this.projectManager = aProjectManager;
        }

        private boolean arePreferencesLoaded(String aNamespace) {
            Boolean result = (Boolean)this.prefsLoaded.get(aNamespace);
            return Boolean.TRUE.equals(result);
        }

        private boolean arePreferencesSaved(String aNamespace) {
            Boolean result = (Boolean)this.prefsLoaded.get(aNamespace);
            return Boolean.FALSE.equals(result);
        }

        private Preferences getUserPreferences(String aNamespace) {
            Preferences userPreferences = this.preferenceService.getUserPreferences(this.userName);
            return userPreferences.node(aNamespace);
        }

        private UserSettings getUserSettings(String aNamespace) {
            return this.projectManager.getCurrentProject().getSettings(aNamespace);
        }

        private boolean isManagedWindow(Window aComponent) {
            if (aComponent == null) {
                return false;
            }
            return aComponent instanceof JFrame && !((JFrame)aComponent).isUndecorated() || aComponent instanceof JDialog && !((JDialog)aComponent).isUndecorated();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadPreferences(Window aComponent, String aNamespace) {
            try {
                if (aComponent instanceof Configurable) {
                    this.logger.log(4, "Reading dialog-specific properties for: " + aNamespace);
                    try {
                        UserSettings userSettings = this.getUserSettings(aNamespace);
                        ((Configurable)aComponent).readPreferences(userSettings);
                    }
                    catch (Exception exception) {
                        this.logger.log(4, "Failed to read preferences for: " + aNamespace, (Throwable)exception);
                    }
                }
                if (this.isManagedWindow(aComponent)) {
                    this.logger.log(4, "Reading window-properties for: " + aNamespace);
                    Preferences componentPrefs = this.getUserPreferences(aNamespace);
                    SwingComponentUtils.loadWindowState((Preferences)componentPrefs, (Window)aComponent);
                }
            }
            finally {
                this.registerPreferencesLoaded(aNamespace);
            }
        }

        private void registerPreferencesLoaded(String aNamespace) {
            this.prefsLoaded.put(aNamespace, Boolean.TRUE);
        }

        private void registerPreferencesSaved(String aNamespace) {
            this.prefsLoaded.put(aNamespace, Boolean.FALSE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void savePreferences(Window aComponent, String aNamespace) {
            try {
                if (aComponent instanceof Configurable) {
                    this.logger.log(4, "Writing dialog-specific properties for: " + aNamespace);
                    try {
                        UserSettings userSettings = this.getUserSettings(aNamespace);
                        ((Configurable)aComponent).writePreferences(userSettings);
                        this.setUserSettings(userSettings);
                    }
                    catch (Exception exception) {
                        this.logger.log(4, "Failed to safe properties for: " + aNamespace, (Throwable)exception);
                    }
                }
                if (this.isManagedWindow(aComponent)) {
                    this.logger.log(4, "Writing window-properties for: " + aNamespace);
                    Preferences componentPrefs = this.getUserPreferences(aNamespace);
                    SwingComponentUtils.saveWindowState((Preferences)componentPrefs, (Window)aComponent);
                }
            }
            catch (RuntimeException exception) {
                this.logger.log(2, "Writing dialog properties failed!", (Throwable)exception);
            }
            finally {
                this.registerPreferencesSaved(aNamespace);
            }
        }

        private void setUserSettings(UserSettings aUserSettings) {
            this.projectManager.getCurrentProject().setSettings(aUserSettings);
        }
    }
}

