/*
 * Decompiled with CFR 0.152.
 */
package org.sump.device.logicsniffer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import nl.lxtreme.ols.api.Configurable;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.api.devices.DeviceMetadata;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import org.sump.device.logicsniffer.LogicSnifferDetectionTask;
import org.sump.device.logicsniffer.LogicSnifferDevice;
import org.sump.device.logicsniffer.LogicSnifferMetadata;
import org.sump.device.logicsniffer.profile.DeviceProfile;
import org.sump.device.logicsniffer.profile.DeviceProfileManager;

public abstract class LogicSnifferDeviceProfilePanel
implements Configurable {
    private JButton showMetadataButton;
    private JComboBox deviceTypeSelect;
    private JEditorPane deviceTypeDetails;
    private static final Logger LOG = Logger.getLogger(LogicSnifferDeviceProfilePanel.class.getName());
    private static final String DETAILS_TMPL = "<html><style>body { font-family: sans-serif; font-size: 8px; margin-left: 8px; } th { text-align: right; }</style><body><table><tr><th>%s</th><td>%s</td></tr><tr><th>%s</th><td>%s</td></tr><tr><th>%s</th><td>%s</td></tr><tr><th>%s</th><td>%s</td></tr></table></body></html>";
    private static final String ERROR_TMPL = "<html><style>body { font-family: sans-serif; font-size: 8px; margin-left: 8px; } th { text-align: right; }</style><body><table><tr><th>Detection failed!</th></tr><tr><td>%s</td></tr><tr><td>&#160;</td></tr><tr><td>&#160;</td></tr></table></body></html>";
    private final LogicSnifferDevice device;

    public LogicSnifferDeviceProfilePanel(LogicSnifferDevice aDevice) {
        this.device = aDevice;
        this.initPanel();
    }

    public void buildPanel(Container aContainer) {
        aContainer.add(SwingComponentUtils.createRightAlignedLabel((String)"Device type"));
        aContainer.add(this.deviceTypeSelect);
        aContainer.add(new JLabel(""));
        aContainer.add(this.showMetadataButton);
        aContainer.add(new JLabel(""));
        aContainer.add(this.deviceTypeDetails);
    }

    public final void readPreferences(UserSettings aSettings) {
        Object element;
        String preferredDeviceType = aSettings.get("deviceType", null);
        if (preferredDeviceType != null && !"null".equals(preferredDeviceType) && (element = ((DeviceProfileTypeComboBoxModel)this.deviceTypeSelect.getModel()).findElementByType(preferredDeviceType)) != null) {
            this.deviceTypeSelect.setSelectedItem(element);
        }
    }

    public final void writePreferences(UserSettings aSettings) {
        aSettings.put("deviceType", String.valueOf(this.deviceTypeSelect.getSelectedItem()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void obtainDeviceMetadata() {
        SwingComponentUtils.getCurrentWindow().setCursor(Cursor.getPredefinedCursor(3));
        LogicSnifferDetectionTask detectTask = new LogicSnifferDetectionTask(this.device, this.getConnectionURI());
        try {
            LogicSnifferMetadata metadata = null;
            String details = this.getEmtpyMetadataDetails();
            try {
                metadata = detectTask.call();
            }
            catch (IOException exception) {
                LOG.log(Level.INFO, "Failed to detect device!", exception);
                details = this.getErrorMetadataDetails(exception);
            }
            if (metadata != null) {
                DeviceProfile deviceProfile = metadata.getDeviceProfile();
                if (deviceProfile == null) {
                    LOG.info("No device profile obtained from metadata!");
                }
                this.deviceTypeSelect.setSelectedItem(deviceProfile);
                this.deviceTypeSelect.repaint();
                details = this.getMetadataDetailsAsText(metadata);
            }
            this.deviceTypeDetails.setText(details);
        }
        finally {
            SwingComponentUtils.getCurrentWindow().setCursor(null);
        }
    }

    protected abstract String getConnectionURI();

    protected abstract void updateDeviceProfile(DeviceProfile var1);

    private String getEmtpyMetadataDetails() {
        return this.getMetadataDetailsAsText(new EmptyDeviceMetadata());
    }

    private String getErrorMetadataDetails(IOException exception) {
        return String.format(ERROR_TMPL, exception.getMessage());
    }

    private String getMetadataDetailsAsText(DeviceMetadata aMetadata) {
        String header1 = "Device type";
        String text1 = "-";
        String header2 = "   Firmware";
        String text2 = "-";
        String header3 = "   Protocol";
        String text3 = "-";
        String header4 = "  Ancillary";
        String text4 = "-";
        Object version = aMetadata.getName();
        if (version != null) {
            text1 = String.valueOf(version);
        }
        if ((version = aMetadata.getFpgaVersion()) != null) {
            text2 = String.valueOf(version);
        }
        if ((version = aMetadata.getProtocolVersion()) != null) {
            text3 = String.valueOf(version);
        }
        if ((version = aMetadata.getAncillaryVersion()) != null) {
            text4 = String.valueOf(version);
        }
        return String.format(DETAILS_TMPL, header1, text1, header2, text2, header3, text3, header4, text4);
    }

    private void initPanel() {
        this.showMetadataButton = new JButton(new ShowDeviceMetadataAction());
        this.deviceTypeDetails = new JEditorPane("text/html", this.getEmtpyMetadataDetails());
        this.deviceTypeDetails.setEditable(false);
        this.deviceTypeDetails.setEnabled(true);
        this.deviceTypeDetails.setOpaque(false);
        this.deviceTypeSelect = new JComboBox(new DeviceProfileTypeComboBoxModel(this.device.getDeviceProfileManager()));
        this.deviceTypeSelect.setRenderer(new DeviceProfileTypeComboBoxRenderer());
        this.deviceTypeSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                JComboBox combobox = (JComboBox)aEvent.getSource();
                DeviceProfile profile = (DeviceProfile)combobox.getSelectedItem();
                LogicSnifferDeviceProfilePanel.this.updateDeviceProfile(profile);
            }
        });
        DeviceProfile defaultProfile = this.device.getDefaultProfile();
        if (defaultProfile != null) {
            this.deviceTypeSelect.setSelectedItem(defaultProfile);
        }
    }

    final class ShowDeviceMetadataAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ShowDeviceMetadataAction() {
            super("Show device metadata");
            this.putValue("LongDescription", "Returns the results of the 'metadata' command.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent aEvent) {
            this.setEnabled(false);
            try {
                LogicSnifferDeviceProfilePanel.this.obtainDeviceMetadata();
            }
            finally {
                this.setEnabled(true);
            }
        }
    }

    static final class EmptyDeviceMetadata
    implements DeviceMetadata {
        EmptyDeviceMetadata() {
        }

        public String getAncillaryVersion() {
            return null;
        }

        public Integer getDynamicMemoryDepth() {
            return null;
        }

        public String getFpgaVersion() {
            return null;
        }

        public Integer getMaxSampleRate() {
            return null;
        }

        public String getName() {
            return null;
        }

        public Integer getProbeCount() {
            return null;
        }

        public Integer getProtocolVersion() {
            return null;
        }

        public Integer getSampleMemoryDepth() {
            return null;
        }

        public Iterator<Object> iterator() {
            return null;
        }
    }

    static final class DeviceProfileTypeComboBoxRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 1L;

        DeviceProfileTypeComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList aList, Object aValue, int aIndex, boolean aIsSelected, boolean aCellHasFocus) {
            DeviceProfile profile;
            Object value = aValue;
            if (value instanceof DeviceProfile && ((value = (profile = (DeviceProfile)value).getDescription()) == null || String.valueOf(value).isEmpty())) {
                value = profile.getType();
            }
            return super.getListCellRendererComponent((JList<?>)aList, value, aIndex, aIsSelected, aCellHasFocus);
        }
    }

    final class DeviceProfileTypeComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = 1L;
        private final DeviceProfileManager deviceProfileManager;
        private volatile Object selected = null;

        public DeviceProfileTypeComboBoxModel(DeviceProfileManager aDeviceProfileManager) {
            this.deviceProfileManager = aDeviceProfileManager;
        }

        public Object findElementByType(String aType) {
            return this.deviceProfileManager.getProfile(aType);
        }

        @Override
        public Object getElementAt(int aIndex) {
            List<DeviceProfile> profiles = this.deviceProfileManager.getProfiles();
            if (profiles.isEmpty()) {
                return null;
            }
            return profiles.get(aIndex);
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public int getSize() {
            return this.deviceProfileManager.getSize();
        }

        @Override
        public void setSelectedItem(Object aItem) {
            this.selected = aItem;
        }
    }
}

