/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.onewire;

import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.BaseDataSet;
import nl.lxtreme.ols.tool.onewire.OneWireData;

public class OneWireDataSet
extends BaseDataSet<OneWireData> {
    public static final String OW_RESET = "RESET";
    public static final String OW_BUS_ERROR = "BUS-ERROR";
    private int busErrors = 0;
    private int decodedBytes = 0;

    public OneWireDataSet(int aStartOfDecodeIdx, int aEndOfDecodeIdx, AcquisitionResult aData) {
        super(aStartOfDecodeIdx, aEndOfDecodeIdx, aData);
    }

    public int getBusErrorCount() {
        return this.busErrors;
    }

    public int getDecodedByteCount() {
        return this.decodedBytes;
    }

    public void reportBusError(int aChannelIdx, int aSampleIdx) {
        int idx = this.size();
        ++this.busErrors;
        this.addData(new OneWireData(idx, aChannelIdx, aSampleIdx, OW_BUS_ERROR, false));
    }

    public void reportData(int aChannelIdx, int aStartSampleIdx, int aEndSampleIdx, int aByteValue) {
        int idx = this.size();
        ++this.decodedBytes;
        this.addData(new OneWireData(idx, aChannelIdx, aStartSampleIdx, aEndSampleIdx, aByteValue));
    }

    public void reportReset(int aChannelIdx, int aSampleIdx, int aEndSampleIdx, boolean aSlaveIsPresent) {
        int idx = this.size();
        this.addData(new OneWireData(idx, aChannelIdx, aSampleIdx, OW_RESET, aSlaveIsPresent));
    }
}

