/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.swing.validation;

import nl.lxtreme.ols.util.swing.validation.IValidator;

public final class NumberValidator
implements IValidator {
    private static final int DECIMAL_RADIX = 10;
    private final Class<?> type;
    private final int radix;

    public NumberValidator() {
        this(Integer.TYPE);
    }

    public NumberValidator(Class<?> aType) {
        this(aType, 10);
    }

    public NumberValidator(Class<?> aType, int aRadix) {
        if (aRadix != 10 && (Float.class.isAssignableFrom(aType) || Double.class.isAssignableFrom(aType))) {
            throw new IllegalArgumentException("Floats or doubles can only be validated as decimals (radix 10)!");
        }
        this.type = aType;
        this.radix = aRadix;
    }

    public NumberValidator(int aRadix) {
        this(Integer.TYPE, 10);
    }

    public static boolean isFloatType(Class<?> aType) {
        if (aType == Float.TYPE || aType == Double.TYPE) {
            return true;
        }
        return Float.class.isAssignableFrom(aType) || Double.class.isAssignableFrom(aType);
    }

    public static boolean isIntegerType(Class<?> aType) {
        if (aType == Integer.TYPE || aType == Long.TYPE) {
            return true;
        }
        return Integer.class.isAssignableFrom(aType) || Long.class.isAssignableFrom(aType);
    }

    public static boolean isNumericType(Class<?> aType) {
        return NumberValidator.isIntegerType(aType) || NumberValidator.isFloatType(aType);
    }

    @Override
    public boolean validate(Object aValue) {
        if (aValue == null) {
            return true;
        }
        String inputText = String.valueOf(aValue).trim();
        if (inputText.isEmpty()) {
            return true;
        }
        return this.parse(inputText) != null;
    }

    protected final Number parse(String aInputText) {
        try {
            Number value = Long.TYPE == this.type || Long.class == this.type ? (Number)Long.parseLong(aInputText, this.radix) : (Number)(Short.TYPE == this.type || Short.class == this.type ? (Number)Short.parseShort(aInputText, this.radix) : (Number)(Float.TYPE == this.type || Float.class == this.type ? (Number)Float.valueOf(Float.parseFloat(aInputText)) : (Number)(Double.TYPE == this.type || Double.class == this.type ? (Number)Double.parseDouble(aInputText) : (Number)Integer.parseInt(aInputText, this.radix))));
            return value;
        }
        catch (NumberFormatException exception) {
            return null;
        }
    }
}

