/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.view;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import nl.lxtreme.ols.api.data.Cursor;
import nl.lxtreme.ols.client.signaldisplay.MeasurementInfo;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramComponent;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.action.EditCursorPropertiesAction;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;
import nl.lxtreme.ols.client.signaldisplay.util.GhostGlassPane;
import nl.lxtreme.ols.client.signaldisplay.view.PopupFactory;
import nl.lxtreme.ols.client.signaldisplay.view.SignalView;
import nl.lxtreme.ols.client.signaldisplay.view.renderer.RubberBandRenderer;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;

abstract class AbstractMouseHandler
extends MouseAdapter {
    private static final int CURSOR_SENSITIVITY_AREA = 4;
    protected final SignalDiagramController controller;
    protected final PopupFactory popupHelper;
    private volatile int movingCursor;
    private volatile Point lastClickPosition = null;

    public AbstractMouseHandler(SignalDiagramController aController) {
        this.controller = aController;
        this.popupHelper = new PopupFactory(aController);
    }

    @Override
    public void mouseClicked(MouseEvent aEvent) {
        MouseEvent event;
        Cursor hoveredCursor;
        this.getSignalDiagram().requestFocusInWindow();
        if (this.getModel().isCursorMode() && aEvent.getClickCount() == 2 && (hoveredCursor = this.findCursor((event = this.convertEvent(aEvent)).getPoint())) != null) {
            this.editCursorProperties(hoveredCursor);
            aEvent.consume();
        }
    }

    @Override
    public void mouseDragged(MouseEvent aEvent) {
        MouseEvent event = this.convertEvent(aEvent);
        Point point = event.getPoint();
        this.controller.setSelectedChannel(point);
        if (this.getModel().isCursorMode() && this.movingCursor >= 0) {
            this.controller.moveCursor(this.movingCursor, this.getCursorDropPoint(point));
            aEvent.consume();
        } else {
            JScrollPane scrollPane;
            if (this.lastClickPosition == null && (aEvent.getModifiersEx() & 0x400) != 0) {
                this.lastClickPosition = new Point(point);
            }
            if ((scrollPane = (JScrollPane)SwingComponentUtils.getAncestorOfClass(JScrollPane.class, (Component)((Component)aEvent.getSource()))) != null && this.lastClickPosition != null) {
                JViewport viewPort = scrollPane.getViewport();
                SignalView signalView = this.controller.getSignalDiagram().getSignalView();
                boolean horizontalOnly = (aEvent.getModifiersEx() & 0x200) != 0;
                boolean verticalOnly = horizontalOnly && (aEvent.getModifiersEx() & 0x40) != 0;
                int dx = aEvent.getX() - this.lastClickPosition.x;
                int dy = aEvent.getY() - this.lastClickPosition.y;
                Point scrollPosition = viewPort.getViewPosition();
                int newX = scrollPosition.x;
                if (!verticalOnly) {
                    newX -= dx;
                }
                int newY = scrollPosition.y;
                if (verticalOnly || !horizontalOnly) {
                    newY -= dy;
                }
                int diagramWidth = ((Component)signalView).getWidth();
                int viewportWidth = viewPort.getWidth();
                int maxX = diagramWidth - viewportWidth - 1;
                scrollPosition.x = Math.max(0, Math.min(maxX, newX));
                int diagramHeight = ((Component)signalView).getHeight();
                int viewportHeight = viewPort.getHeight();
                int maxY = diagramHeight - viewportHeight;
                scrollPosition.y = Math.max(0, Math.min(maxY, newY));
                viewPort.setViewPosition(scrollPosition);
            }
            this.handleZoomRegion(aEvent, this.lastClickPosition);
        }
    }

    @Override
    public void mousePressed(MouseEvent aEvent) {
        MouseEvent event = this.convertEvent(aEvent);
        Point point = event.getPoint();
        if (!this.handlePopupTrigger(point, aEvent)) {
            if (this.getModel().isCursorMode()) {
                Cursor hoveredCursor = this.findCursor(point);
                if (hoveredCursor != null) {
                    this.movingCursor = hoveredCursor.getIndex();
                    this.setMouseCursor(aEvent, SignalView.CURSOR_MOVE_CURSOR);
                } else {
                    this.movingCursor = -1;
                }
            }
            if ((aEvent.getModifiersEx() & 0x400) != 0) {
                this.lastClickPosition = point;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent aEvent) {
        MouseEvent event = this.convertEvent(aEvent);
        Point point = event.getPoint();
        if (!this.isCursorHover(event)) {
            this.setMouseCursor(event, null);
        }
        if (!this.handlePopupTrigger(point, aEvent)) {
            this.movingCursor = -1;
        }
        if ((aEvent.getModifiersEx() & 0x10) != 0) {
            this.handleZoomRegion(aEvent, this.lastClickPosition);
            this.lastClickPosition = null;
        }
    }

    protected final MouseEvent convertEvent(MouseEvent aEvent) {
        JComponent view = SwingComponentUtils.getDeepestComponentAt((MouseEvent)aEvent);
        return SwingUtilities.convertMouseEvent(aEvent.getComponent(), aEvent, view);
    }

    protected final Cursor findCursor(Point aPoint) {
        SignalDiagramModel model = this.getModel();
        long refIdx = model.locationToTimestamp(aPoint);
        double snapArea = 4.0 / model.getZoomFactor();
        for (Cursor cursor : model.getDefinedCursors()) {
            if (!cursor.inArea(refIdx, snapArea)) continue;
            return cursor;
        }
        return null;
    }

    protected final SignalDiagramModel getModel() {
        return this.controller.getSignalDiagramModel();
    }

    protected final SignalDiagramComponent getSignalDiagram() {
        return this.controller.getSignalDiagram();
    }

    protected void handleZoomRegion(MouseEvent aEvent, Point aStartPoint) {
        Rectangle viewRect;
        if (Boolean.FALSE.equals(Boolean.valueOf(System.getProperty("zoomregionenabled", "false")))) {
            return;
        }
        JComponent source = (JComponent)aEvent.getComponent();
        boolean dragging = aEvent.getID() == 506;
        GhostGlassPane glassPane = (GhostGlassPane)SwingUtilities.getRootPane(source).getGlassPane();
        JScrollPane scrollPane = (JScrollPane)SwingComponentUtils.getAncestorOfClass(JScrollPane.class, (Component)source);
        if (scrollPane != null) {
            JViewport viewport = scrollPane.getViewport();
            viewRect = SwingUtilities.convertRectangle(viewport, viewport.getVisibleRect(), glassPane);
        } else {
            viewRect = SwingUtilities.convertRectangle(source, source.getVisibleRect(), glassPane);
        }
        Point start = SwingUtilities.convertPoint(source, aStartPoint, glassPane);
        Point current = SwingUtilities.convertPoint(source, aEvent.getPoint(), glassPane);
        if (dragging) {
            if (!glassPane.isVisible()) {
                glassPane.setVisible(true);
                glassPane.setRenderer(new RubberBandRenderer(), start, current, viewRect);
            } else {
                glassPane.updateRenderer(start, current, viewRect);
            }
            glassPane.repaintPartially();
        } else {
            this.controller.getZoomController().zoomRegion(aStartPoint, aEvent.getPoint());
            glassPane.setVisible(false);
        }
    }

    protected final void setMouseCursor(MouseEvent aEvent, java.awt.Cursor aMouseCursor) {
        aEvent.getComponent().setCursor(aMouseCursor);
    }

    private JPopupMenu createCursorPopup(Point aPoint, Point aLocationOnScreen) {
        return this.popupHelper.createCursorPopup(this.findCursor(aPoint), aPoint, aLocationOnScreen);
    }

    private void editCursorProperties(Cursor aCursor) {
        ActionEvent stubEvent = new ActionEvent(this, 1001, "");
        new EditCursorPropertiesAction(this.controller, aCursor).actionPerformed(stubEvent);
    }

    private Point getCursorDropPoint(Point aCoordinate) {
        MeasurementInfo signalHover;
        Point dropPoint = new Point(aCoordinate);
        if (this.getModel().isSnapCursorMode() && (signalHover = this.getModel().getSignalHover(aCoordinate)) != null && !signalHover.isEmpty()) {
            dropPoint.x = signalHover.getMidSamplePos();
        }
        dropPoint.y = 0;
        return dropPoint;
    }

    private boolean handlePopupTrigger(Point aPoint, MouseEvent aEvent) {
        JPopupMenu contextMenu;
        boolean popupTrigger = this.isCursorPopupTrigger(aEvent);
        if (popupTrigger && (contextMenu = this.createCursorPopup(aPoint, aEvent.getLocationOnScreen())) != null) {
            contextMenu.show(aEvent.getComponent(), aEvent.getX(), aEvent.getY());
            aEvent.consume();
        }
        return popupTrigger;
    }

    private boolean isCursorHover(MouseEvent aEvent) {
        if (!this.isCursorPopupTrigger(aEvent)) {
            return false;
        }
        Point point = aEvent.getPoint();
        return this.findCursor(point) != null;
    }

    private boolean isCursorPopupTrigger(MouseEvent aEvent) {
        return !aEvent.isConsumed() && aEvent.isPopupTrigger();
    }
}

