/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.look;

import info.clearthought.layout.TableLayout;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;
import org.noos.xing.mydoggy.plaf.ui.animation.AbstractAnimation;
import org.noos.xing.mydoggy.plaf.ui.animation.AnimationListener;
import org.noos.xing.mydoggy.plaf.ui.animation.TransparencyAnimation;
import org.noos.xing.mydoggy.plaf.ui.cmp.RepresentativeAnchorBalloonTip;
import org.noos.xing.mydoggy.plaf.ui.translucent.TranslucentComponent;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class RepresentativeAnchorBalloonTipUI
extends BasicPanelUI
implements PropertyChangeListener {
    protected RepresentativeAnchorBalloonTip balloonTip;
    protected JLabel label;
    protected RootPaneContainer rootPaneContainer;
    protected JLayeredPane layeredPane;
    protected TransparencyAnimation transparencyAnimation;
    protected float transparencyAlpha = 0.0f;
    protected int hOffset;
    protected int vOffset;

    public static ComponentUI createUI(JComponent c) {
        return new RepresentativeAnchorBalloonTipUI();
    }

    public void installUI(JComponent c) {
        this.balloonTip = (RepresentativeAnchorBalloonTip)c;
        super.installUI(c);
    }

    protected void installDefaults(JPanel p) {
        super.installDefaults(p);
        this.transparencyAnimation = new TransparencyAnimation(new TranslucentComponent(){

            public void setAlphaModeRatio(float transparency) {
                RepresentativeAnchorBalloonTipUI.this.transparencyAlpha = RepresentativeAnchorBalloonTipUI.this.transparencyAnimation.getAnimationDirection() == AbstractAnimation.Direction.OUTGOING ? transparency : 1.0f - transparency;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RepresentativeAnchorBalloonTipUI.this.balloonTip.repaint();
                    }
                });
            }

            public float getAlphaModeEnabled() {
                return RepresentativeAnchorBalloonTipUI.this.transparencyAlpha;
            }
        }, (Component)this.balloonTip, SwingUtil.getFloat("RepresentativeAnchorBalloonTipUI.animation.alpha", 0.15f), (float)SwingUtil.getInt("RepresentativeAnchorBalloonTipUI.animation.duration", 500));
        this.transparencyAnimation.addAnimationListener(new AnimationListener(){

            public void onFinished() {
                if (RepresentativeAnchorBalloonTipUI.this.transparencyAnimation.getAnimationDirection() == AbstractAnimation.Direction.OUTGOING) {
                    RepresentativeAnchorBalloonTipUI.this.balloonTip.setVisible(false);
                }
            }
        });
        this.hOffset = SwingUtil.getInt("RepresentativeAnchorBalloonTipUI.hOffset", 15);
        this.vOffset = SwingUtil.getInt("RepresentativeAnchorBalloonTipUI.vOffset", 15);
        p.setLayout(new TableLayout(new double[][]{{-1.0}, {-1.0}}));
        p.setBorder(new RoundedBalloonBorder(SwingUtil.getInt("RepresentativeAnchorBalloonTipUI.arcWidth", 7), SwingUtil.getInt("RepresentativeAnchorBalloonTipUI.arcHeight", 7), SwingUtil.getColor("RepresentativeAnchorBalloonTipUI.fillColor", new Color(193, 240, 193)), SwingUtil.getColor("RepresentativeAnchorBalloonTipUI.borderColor", Color.GRAY)));
        p.setOpaque(false);
        int borderLength = SwingUtil.getInt("RepresentativeAnchorBalloonTipUI.borderLength", 15);
        this.label = new JLabel();
        this.label.setBorder(new EmptyBorder(borderLength, borderLength, borderLength, borderLength));
        this.label.setFont(this.label.getFont().deriveFont(0));
        p.add((Component)this.label, "0,0,FULL,FULL");
        if (this.rootPaneContainer != null) {
            this.layeredPane = this.rootPaneContainer.getLayeredPane();
            this.layeredPane.setLayer(p, JLayeredPane.DEFAULT_LAYER + 5);
            this.layeredPane.add(p);
        }
        p.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                e.consume();
            }
        });
        p.addPropertyChangeListener(this);
    }

    protected void uninstallDefaults(JPanel p) {
        super.uninstallDefaults(p);
        p.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("rootPaneContainer".equals(propertyName)) {
            this.rootPaneContainer = (RootPaneContainer)evt.getNewValue();
            if (this.rootPaneContainer != null) {
                if (this.layeredPane != null) {
                    this.layeredPane.remove(this.balloonTip);
                }
                this.layeredPane = this.rootPaneContainer.getLayeredPane();
                this.layeredPane.setLayer(this.balloonTip, JLayeredPane.DEFAULT_LAYER + 5);
                this.layeredPane.add(this.balloonTip);
            }
        } else if ("text".equals(propertyName)) {
            this.label.setText((String)evt.getNewValue());
        } else if ("icon".equals(propertyName)) {
            this.label.setIcon((Icon)evt.getNewValue());
        }
    }

    public void updateLocation(boolean visible) {
        if (this.rootPaneContainer != null) {
            this.layeredPane = this.rootPaneContainer.getLayeredPane();
            this.layeredPane.remove(this.balloonTip);
        }
        this.rootPaneContainer = SwingUtil.getParent(this.balloonTip.getRepresentativeAnchor(), RootPaneContainer.class);
        Point source = this.balloonTip.getRepresentativeAnchor().getLocation();
        Dimension size = this.balloonTip.getRepresentativeAnchor().getSize();
        source.setLocation(source.x + size.width / 2, source.y + size.height / 2);
        Point finalLocatioon = SwingUtil.convertPoint(this.balloonTip.getRepresentativeAnchor(), source, (Component)((Object)this.rootPaneContainer));
        Dimension finalSize = this.balloonTip.getPreferredSize();
        switch (this.balloonTip.getRepresentativeAnchorDescriptor().getAnchor()) {
            case TOP: {
                finalLocatioon.setLocation(finalLocatioon.getX() - finalSize.getWidth() / 2.0, finalLocatioon.getY());
                break;
            }
            case LEFT: {
                finalLocatioon.setLocation(finalLocatioon.getX(), finalLocatioon.getY() - finalSize.getHeight() / 2.0);
                break;
            }
            case RIGHT: {
                finalLocatioon.setLocation(finalLocatioon.getX() - finalSize.getWidth(), finalLocatioon.getY() - finalSize.getHeight() / 2.0);
                break;
            }
            case BOTTOM: {
                finalLocatioon.setLocation(finalLocatioon.getX() - finalSize.getWidth() / 2.0, finalLocatioon.getY() - finalSize.getHeight());
            }
        }
        this.balloonTip.setLocation(finalLocatioon);
        this.balloonTip.setSize(finalSize);
        this.layeredPane = this.rootPaneContainer.getLayeredPane();
        this.layeredPane.setLayer(this.balloonTip, JLayeredPane.DEFAULT_LAYER + 5);
        this.layeredPane.add(this.balloonTip);
        this.transparencyAnimation.show(new Object[0]);
    }

    public void showTip() {
        this.transparencyAlpha = 0.0f;
        this.updateLocation(true);
        this.balloonTip.setVisible(true);
    }

    public void hideTip() {
        this.transparencyAnimation.hide(new Object[0]);
    }

    public class RoundedBalloonBorder
    implements Border {
        int arcWidth;
        int arcHeight;
        Color fillColor;
        Color borderColor;
        Dimension lastSize;
        Insets insets = new Insets(0, 0, 0, 0);

        public RoundedBalloonBorder(int arcWidth, int arcHeight, Color fillColor, Color borderColor) {
            this.arcWidth = arcWidth;
            this.arcHeight = arcHeight;
            this.fillColor = fillColor;
            this.borderColor = borderColor;
        }

        public Insets getBorderInsets(Component c) {
            Dimension currentSize = c.getSize();
            switch (RepresentativeAnchorBalloonTipUI.this.balloonTip.getRepresentativeAnchorDescriptor().getAnchor()) {
                case BOTTOM: {
                    this.insets = new Insets(0, 0, RepresentativeAnchorBalloonTipUI.this.vOffset, 0);
                    this.lastSize = currentSize;
                    return this.insets;
                }
                case TOP: {
                    this.insets = new Insets(RepresentativeAnchorBalloonTipUI.this.vOffset, 0, 0, 0);
                    this.lastSize = currentSize;
                    return this.insets;
                }
                case LEFT: {
                    this.insets = new Insets(0, RepresentativeAnchorBalloonTipUI.this.hOffset, 0, 0);
                    this.lastSize = currentSize;
                    return this.insets;
                }
                case RIGHT: {
                    this.insets = new Insets(0, 0, 0, RepresentativeAnchorBalloonTipUI.this.hOffset);
                    this.lastSize = currentSize;
                    return this.insets;
                }
            }
            throw new IllegalStateException("Invalid position...");
        }

        public boolean isBorderOpaque() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintBorder(Component c, Graphics g, int x, int y, int bWidth, int bHeight) {
            Graphics2D g2D = (Graphics2D)g;
            Composite oldComposite = g2D.getComposite();
            g2D.setComposite(AlphaComposite.getInstance(3, RepresentativeAnchorBalloonTipUI.this.transparencyAlpha));
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            try {
                switch (RepresentativeAnchorBalloonTipUI.this.balloonTip.getRepresentativeAnchorDescriptor().getAnchor()) {
                    case BOTTOM: {
                        g.setColor(this.fillColor);
                        g.fillRoundRect(x, y, bWidth, bHeight - RepresentativeAnchorBalloonTipUI.this.vOffset, this.arcWidth * 2, this.arcHeight * 2);
                        g.setColor(this.borderColor);
                        g.drawRoundRect(x, y, bWidth - 1, bHeight - RepresentativeAnchorBalloonTipUI.this.vOffset - 1, this.arcWidth * 2, this.arcHeight * 2);
                        int[] xPoints = new int[]{x + bWidth / 2 - 7, x + bWidth / 2, x + bWidth / 2 + 7};
                        int[] yPoints = new int[]{y + bHeight - RepresentativeAnchorBalloonTipUI.this.vOffset - 1, y + bHeight, y + bHeight - RepresentativeAnchorBalloonTipUI.this.vOffset - 1};
                        g.setColor(this.fillColor);
                        g.fillPolygon(xPoints, yPoints, 3);
                        g.drawLine(xPoints[0], yPoints[0], xPoints[2], yPoints[2]);
                        g.setColor(this.borderColor);
                        g.drawLine(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
                        g.drawLine(xPoints[1], yPoints[1], xPoints[2], yPoints[2]);
                        break;
                    }
                    case TOP: {
                        g.setColor(this.fillColor);
                        g.fillRoundRect(x, y + RepresentativeAnchorBalloonTipUI.this.vOffset, bWidth, bHeight - RepresentativeAnchorBalloonTipUI.this.vOffset, this.arcWidth * 2, this.arcHeight * 2);
                        g.setColor(this.borderColor);
                        g.drawRoundRect(x, y + RepresentativeAnchorBalloonTipUI.this.vOffset, bWidth - 1, bHeight - RepresentativeAnchorBalloonTipUI.this.vOffset - 1, this.arcWidth * 2, this.arcHeight * 2);
                        int[] xPoints = new int[]{x + bWidth / 2 - 7, x + bWidth / 2, x + bWidth / 2 + 7};
                        int[] yPoints = new int[]{y + RepresentativeAnchorBalloonTipUI.this.vOffset, y + 1, y + RepresentativeAnchorBalloonTipUI.this.vOffset};
                        g.setColor(this.fillColor);
                        g.fillPolygon(xPoints, yPoints, 3);
                        g.drawLine(xPoints[0], yPoints[0], xPoints[2], yPoints[2]);
                        g.setColor(this.borderColor);
                        g.drawLine(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
                        g.drawLine(xPoints[1], yPoints[1], xPoints[2], yPoints[2]);
                        break;
                    }
                    case LEFT: {
                        g.setColor(this.fillColor);
                        g.fillRoundRect(x + RepresentativeAnchorBalloonTipUI.this.hOffset, y, bWidth - RepresentativeAnchorBalloonTipUI.this.hOffset, bHeight, this.arcWidth * 2, this.arcHeight * 2);
                        g.setColor(this.borderColor);
                        g.drawRoundRect(x + RepresentativeAnchorBalloonTipUI.this.hOffset, y, bWidth - RepresentativeAnchorBalloonTipUI.this.hOffset - 1, bHeight - 1, this.arcWidth * 2, this.arcHeight * 2);
                        int[] xPoints = new int[]{x + RepresentativeAnchorBalloonTipUI.this.hOffset, x + 1, x + RepresentativeAnchorBalloonTipUI.this.hOffset};
                        int[] yPoints = new int[]{y + bHeight / 2 + 7, y + bHeight / 2, y + bHeight / 2 - 7};
                        g.setColor(this.fillColor);
                        g.fillPolygon(xPoints, yPoints, 3);
                        g.drawLine(xPoints[0], yPoints[0], xPoints[2], yPoints[2]);
                        g.setColor(this.borderColor);
                        g.drawLine(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
                        g.drawLine(xPoints[1], yPoints[1], xPoints[2], yPoints[2]);
                        break;
                    }
                    case RIGHT: {
                        g.setColor(this.fillColor);
                        g.fillRoundRect(x, y, bWidth - RepresentativeAnchorBalloonTipUI.this.hOffset, bHeight, this.arcWidth * 2, this.arcHeight * 2);
                        g.setColor(this.borderColor);
                        g.drawRoundRect(x, y, bWidth - RepresentativeAnchorBalloonTipUI.this.hOffset - 1, bHeight - 1, this.arcWidth * 2, this.arcHeight * 2);
                        int[] xPoints = new int[]{x + bWidth - RepresentativeAnchorBalloonTipUI.this.hOffset - 1, x + bWidth, x + bWidth - RepresentativeAnchorBalloonTipUI.this.hOffset - 1};
                        int[] yPoints = new int[]{y + bHeight / 2 + 7, y + bHeight / 2, y + bHeight / 2 - 7};
                        g.setColor(this.fillColor);
                        g.fillPolygon(xPoints, yPoints, 3);
                        g.drawLine(xPoints[0], yPoints[0], xPoints[2], yPoints[2]);
                        g.setColor(this.borderColor);
                        g.drawLine(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
                        g.drawLine(xPoints[1], yPoints[1], xPoints[2], yPoints[2]);
                    }
                }
                Object var12_17 = null;
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                throw throwable;
            }
        }
    }
}

