/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.drag;

import java.awt.Color;
import java.awt.HeadlessException;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.cmp.border.LineBorder;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class ContentManagerDropTarget
extends DropTarget {
    public ContentManagerDropTarget(JComponent component, ToolWindowManager toolWindowManager) throws HeadlessException {
        super(component, 2, new ContentManagerDropTargetListener(toolWindowManager, component));
    }

    public static class ContentManagerDropTargetListener
    implements DropTargetListener {
        protected ToolWindowManager toolWindowManager;
        protected JComponent component;
        protected Border oldBorder;
        protected Border dragBorder = new LineBorder(Color.BLUE, 3);

        public ContentManagerDropTargetListener(ToolWindowManager toolWindowManager, JComponent component) {
            this.toolWindowManager = toolWindowManager;
            this.component = component;
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            if (!this.checkEvent(dtde)) {
                return;
            }
            if (dtde.getTransferable().isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_ID_DF) && dtde.getDropAction() == 2) {
                dtde.acceptDrag(dtde.getDropAction());
                if (this.component.getBorder() != this.dragBorder) {
                    this.oldBorder = this.component.getBorder();
                }
                this.component.setBorder(this.dragBorder);
            } else {
                dtde.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent dtde) {
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
            this.dragEnter(dtde);
        }

        public void dragExit(DropTargetEvent dte) {
            if (!this.isEnabled()) {
                return;
            }
            this.component.setBorder(this.oldBorder);
            this.oldBorder = null;
        }

        public void drop(DropTargetDropEvent dtde) {
            block8: {
                if (!this.isEnabled()) {
                    return;
                }
                if (dtde.getDropAction() == 2) {
                    if (dtde.getTransferable().isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_ID_DF)) {
                        try {
                            ToolWindow toolWindow = this.toolWindowManager.getToolWindow(dtde.getTransferable().getTransferData(MyDoggyTransferable.TOOL_WINDOW_ID_DF));
                            if (toolWindow != null) {
                                this.toolWindowManager.getContentManager().addContent(toolWindow).setSelected(true);
                                dtde.dropComplete(true);
                                break block8;
                            }
                            dtde.dropComplete(false);
                        }
                        catch (Exception e) {
                            dtde.dropComplete(false);
                        }
                    } else {
                        dtde.rejectDrop();
                    }
                } else {
                    dtde.rejectDrop();
                }
            }
            this.dragExit(dtde);
        }

        protected boolean isEnabled() {
            return SwingUtil.getBoolean("ContentManagerDropTarget.enabled", false);
        }

        protected boolean checkEvent(DropTargetDragEvent dtde) {
            Transferable transferable = dtde.getTransferable();
            try {
                if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_MANAGER) && transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_MANAGER).equals(System.identityHashCode(this.toolWindowManager))) {
                    return this.isEnabled();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }
}

