/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAction;
import org.noos.xing.mydoggy.ToolWindowActionHandler;
import org.noos.xing.mydoggy.plaf.actions.PlafToolWindowAction;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class HideToolWindowAction
extends ToolWindowAction
implements PlafToolWindowAction {
    protected PropertyChangeListener propertyChangeListener;

    public HideToolWindowAction() {
        super("HIDE_ACTION_ID", UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.hideToolWindow.inactive"));
        this.setTooltipText(SwingUtil.getString("@@tool.tooltip.hide"));
        this.putValue("constraint", 0);
    }

    public void setToolWindow(ToolWindow toolWindow) {
        if (toolWindow == null) {
            this.toolWindow.removePropertyChangeListener("active", this.propertyChangeListener);
            this.propertyChangeListener = null;
            super.setToolWindow(toolWindow);
        } else {
            super.setToolWindow(toolWindow);
            this.propertyChangeListener = new PropertyListener();
            this.setActionName("toolWindow.hideButton." + toolWindow.getId());
            toolWindow.addPropertyChangeListener("active", this.propertyChangeListener);
        }
    }

    public JMenuItem getMenuItem() {
        if (this.menuItem == null) {
            this.menuItem = new JMenuItem();
            this.menuItem.setName("toolWindow.popup.visible." + this.toolWindow.getId());
            this.menuItem.setActionCommand("menu.visible");
            this.menuItem.addActionListener(this);
        }
        this.menuItem.setText(this.toolWindow.isVisible() ? SwingUtil.getString("@@tool.hide") : SwingUtil.getString("@@tool.show"));
        return this.menuItem;
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("menu.visible".equals(actionCommand)) {
            if (this.toolWindow.isActive()) {
                this.toolWindow.setActive(false);
                this.hideToolWindow();
            } else if (this.toolWindow.isVisible()) {
                this.hideToolWindow();
            } else {
                this.toolWindow.setActive(true);
            }
        } else {
            this.hideToolWindow();
        }
    }

    public void hideToolWindow() {
        ToolWindowActionHandler toolWindowActionHandler = this.toolWindow.getTypeDescriptor(DockedTypeDescriptor.class).getToolWindowActionHandler();
        if (toolWindowActionHandler != null) {
            toolWindowActionHandler.onHideButtonClick(this.toolWindow);
        } else {
            this.toolWindow.setVisible(false);
        }
    }

    public class PropertyListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            boolean active = (Boolean)evt.getNewValue();
            if (active) {
                HideToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.hideToolWindow"));
            } else {
                HideToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.hideToolWindow.inactive"));
            }
        }
    }
}

