/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManager;
import org.noos.xing.mydoggy.ContentUI;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.MultiSplitConstraint;
import org.noos.xing.mydoggy.RepresentativeAnchorDescriptor;
import org.noos.xing.mydoggy.plaf.MyDoggyContentManager;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.PropertyChangeEventSource;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.descriptors.ContentRepresentativeAnchorDescriptor;
import org.noos.xing.mydoggy.plaf.support.UserPropertyChangeEvent;
import org.noos.xing.mydoggy.plaf.ui.content.PlafContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyDoggyContent
extends PropertyChangeEventSource
implements PlafContent {
    protected transient MyDoggyContentManager contentManager;
    protected String id;
    protected String title;
    protected Color foreground;
    protected Icon icon;
    protected Icon disabledIcon;
    protected String toolTipText;
    protected boolean enabled;
    protected transient Component component;
    protected JPopupMenu popupMenu;
    protected boolean detached;
    protected int mnemonic;
    protected boolean selected;
    protected boolean maximized;
    protected transient Dockable dockableDelegator;
    protected boolean flash;
    protected boolean minimized;
    protected RepresentativeAnchorDescriptor<Content> representativeAnchorDescriptor;

    public MyDoggyContent(MyDoggyContentManager contentManager, String id, String title, Icon icon, Component component, String toolTipText, Dockable dockableDelegator) {
        super(((MyDoggyToolWindowManager)contentManager.getToolWindowManager()).getFirePublicEvent());
        this.contentManager = contentManager;
        this.id = id;
        this.title = title;
        this.icon = icon;
        this.component = component;
        this.toolTipText = toolTipText;
        this.enabled = true;
        this.mnemonic = -1;
        this.selected = false;
        this.maximized = false;
        this.dockableDelegator = dockableDelegator;
        this.flash = false;
        this.representativeAnchorDescriptor = new ContentRepresentativeAnchorDescriptor(this);
    }

    @Override
    public ContentManager getDockableManager() {
        return this.contentManager;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public boolean isFlashing() {
        return this.flash;
    }

    @Override
    public void setFlashing(boolean flash) {
        if (flash && this.isSelected()) {
            return;
        }
        if (this.flash == flash) {
            return;
        }
        boolean old = this.flash;
        this.flash = flash;
        this.firePropertyChangeEvent("flash", old, flash);
    }

    @Override
    public void setFlashing(int duration) {
        if (this.isSelected()) {
            return;
        }
        if (this.flash) {
            return;
        }
        this.flash = true;
        this.firePropertyChangeEvent("flash", false, true, duration);
    }

    @Override
    public void setComponent(Component component) {
        if (this.component != null && this.component.equals(component)) {
            return;
        }
        Component old = this.component;
        this.component = component;
        this.firePropertyChangeEvent("component", old, component);
    }

    @Override
    public Icon getDisabledIcon() {
        return this.disabledIcon;
    }

    @Override
    public void setDisabledIcon(Icon disabledIcon) {
        if (this.disabledIcon != null && this.disabledIcon.equals(disabledIcon)) {
            return;
        }
        Icon old = this.disabledIcon;
        this.disabledIcon = disabledIcon;
        this.firePropertyChangeEvent("disabledIcon", old, disabledIcon);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled && this.enabled && this.isSelected()) {
            return;
        }
        if (this.enabled != enabled) {
            boolean old = this.enabled;
            this.enabled = enabled;
            this.firePropertyChangeEvent("enabled", old, enabled);
        }
    }

    @Override
    public boolean isSelected() {
        if (this.contentManager == null) {
            return false;
        }
        if (this.contentManager.getPlafContentManagerUI().isInstalled()) {
            return this.contentManager.getPlafContentManagerUI().isSelected(this);
        }
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        if (this.contentManager == null) {
            return;
        }
        if (this.isSelected() != selected || !this.contentManager.getPlafContentManagerUI().isInstalled()) {
            boolean old = this.isSelected();
            this.selected = selected;
            this.contentManager.getPlafContentManagerUI().setSelected(this, selected);
            this.firePropertyChangeEvent("selected", old, selected);
        }
    }

    @Override
    public Color getForeground() {
        return this.foreground;
    }

    @Override
    public void setForeground(Color foreground) {
        if (this.foreground != null && this.foreground.equals(foreground)) {
            return;
        }
        Color old = this.foreground;
        this.foreground = foreground;
        this.firePropertyChangeEvent("foreground", old, foreground);
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(Icon icon) {
        if (this.icon != null && this.icon.equals(icon)) {
            return;
        }
        Icon old = this.icon;
        this.icon = icon;
        this.firePropertyChangeEvent("icon", old, icon);
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    @Override
    public void setPopupMenu(JPopupMenu popupMenu) {
        if (this.popupMenu != null && this.popupMenu.equals(popupMenu)) {
            return;
        }
        JPopupMenu old = this.popupMenu;
        this.popupMenu = popupMenu;
        this.firePropertyChangeEvent("popupMenu", old, popupMenu);
    }

    @Override
    public void setDetached(boolean detached) {
        if (this.detached == detached) {
            return;
        }
        if (detached) {
            this.setMaximized(false);
        }
        boolean old = this.detached;
        this.detached = detached;
        this.firePropertyChangeEvent("detached", old, detached);
    }

    @Override
    public boolean isDetached() {
        return this.detached;
    }

    @Override
    public void setMnemonic(int mnemonic) {
        if (this.mnemonic == mnemonic) {
            return;
        }
        int old = this.mnemonic;
        this.mnemonic = mnemonic;
        this.firePropertyChangeEvent("mnemonic", old, mnemonic);
    }

    @Override
    public int getMnemonic() {
        return this.mnemonic;
    }

    @Override
    public void setMaximized(boolean maximized) {
        if (this.maximized == maximized) {
            return;
        }
        if (this.isMinimized()) {
            this.setMinimized(false);
        }
        boolean old = this.maximized;
        if (maximized) {
            this.firePlafPropertyChangeEvent("maximizedBefore", false, maximized);
        }
        this.maximized = maximized;
        this.firePropertyChangeEvent("maximized", old, maximized);
    }

    @Override
    public boolean isMaximized() {
        return this.maximized;
    }

    @Override
    public void setMinimized(boolean minimized) {
        if (this.minimized == minimized) {
            return;
        }
        Content maximizedContent = this.contentManager.getMaximizedContent();
        if (maximizedContent != null) {
            maximizedContent.setMaximized(false);
        }
        boolean old = this.minimized;
        this.minimized = minimized;
        this.firePropertyChangeEvent("minimized", old, minimized);
    }

    @Override
    public boolean isMinimized() {
        return this.minimized;
    }

    @Override
    public void ensureVisible() {
        if (!this.isMinimized()) {
            this.firePlafPropertyChangeEvent("ensureVisible", null, this);
        }
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public ContentUI getContentUI() {
        if (this.contentManager == null) {
            return null;
        }
        return this.contentManager.getContentManagerUI().getContentUI(this);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        if (this.title != null && this.title.equals(title)) {
            return;
        }
        String old = this.title;
        this.title = title;
        this.firePropertyChangeEvent("title", old, title);
    }

    @Override
    public String getToolTipText() {
        return this.toolTipText;
    }

    @Override
    public void setToolTipText(String toolTipText) {
        String old = this.toolTipText;
        this.toolTipText = toolTipText;
        this.firePropertyChangeEvent("toolTipText", old, toolTipText);
    }

    @Override
    public Dockable getDockableDelegator() {
        return this.dockableDelegator;
    }

    @Override
    public void detach(Content onContent, int onIndex, AggregationPosition onPosition) {
        if (onContent == null) {
            throw new IllegalArgumentException("onContent cannot be null.");
        }
        if (this.isDetached() || !this.contentManager.isEnabled()) {
            return;
        }
        this.detached = true;
        if (onIndex < -1) {
            onIndex = -1;
        }
        this.firePropertyChangeEvent(new UserPropertyChangeEvent(this, "detached", false, true, new MultiSplitConstraint(onContent, onIndex, onPosition)));
    }

    @Override
    public void detach(Content onContent, AggregationPosition onPosition) {
        if (onContent == null) {
            throw new IllegalArgumentException("onContent cannot be null.");
        }
        if (this.isDetached()) {
            return;
        }
        this.detached = true;
        this.firePropertyChangeEvent(new UserPropertyChangeEvent(this, "detached", false, true, new MultiSplitConstraint(onContent, -1, onPosition)));
    }

    @Override
    public void detachByReference(Content refContent, AggregationPosition onPosition) {
        if (refContent == null) {
            throw new IllegalArgumentException("refContent cannot be null.");
        }
        if (this.isDetached()) {
            return;
        }
        this.detached = true;
        this.firePropertyChangeEvent(new UserPropertyChangeEvent(this, "detached", false, true, new MultiSplitConstraint(refContent, -2, onPosition)));
    }

    @Override
    public void reattach(Object ... constraints) {
        if (!this.isDetached()) {
            return;
        }
        this.detached = false;
        this.firePropertyChangeEvent(new UserPropertyChangeEvent(this, "detached", true, false, constraints));
    }

    @Override
    public RepresentativeAnchorDescriptor<Content> getRepresentativeAnchorDescriptor() {
        return this.representativeAnchorDescriptor;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        ((Cleaner)((Object)this.representativeAnchorDescriptor)).cleanup();
        this.contentManager = null;
        this.dockableDelegator = null;
        this.representativeAnchorDescriptor = null;
    }
}

