/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy;

import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import org.noos.xing.mydoggy.ToolWindow;

public abstract class ToolWindowAction
extends AbstractAction {
    public static final String HIDE_ACTION_ID = "HIDE_ACTION_ID";
    public static final String DOCK_ACTION_ID = "DOCK_ACTION_ID";
    public static final String PIN_ACTION_ID = "PIN_ACTION_ID";
    public static final String MAXIMIZE_ACTION_ID = "MAXIMIZE_ACTION_ID";
    public static final String FLOATING_ACTION_ID = "FLOATING_ACTION_ID";
    public static final String FLOATING_LIVE_ACTION_ID = "FLOATING_LIVE_ACTION_ID";
    public static final String POPUP_ACTION_ID = "POPUP_ACTION_ID";
    public static final String MOVE_TO_ACTION_ID = "MOVE_TO_ACTION_ID";
    public static final String AGGREGATE_ACTION_ID = "AGGREGATE_ACTION_ID";
    public static final String AGGREGATE_MENU_ACTION_ID = "AGGREGATE_MENU_ACTION_ID";
    public static final String TOOLS_MENU_ACTION_ID = "TOOLS_MENU_ACTION_ID";
    public static final String INDEX_MENU_ACTION_ID = "INDEX_MENU_ACTION_ID";
    protected String id;
    protected String actionName;
    protected ToolWindow toolWindow;
    protected JMenuItem menuItem;
    protected boolean showTextOnTitleBar;
    protected boolean visibleOnTitleBar;
    protected boolean visibleOnMenuBar;

    protected ToolWindowAction(String id) {
        this(id, null);
    }

    protected ToolWindowAction(String id, Icon icon) {
        super(null, icon);
        this.id = id;
        this.showTextOnTitleBar = false;
        this.visibleOnTitleBar = true;
        this.visibleOnMenuBar = true;
    }

    public ToolWindow getToolWindow() {
        return this.toolWindow;
    }

    public void setToolWindow(ToolWindow toolWindow) {
        this.toolWindow = toolWindow;
    }

    public String getId() {
        return this.id;
    }

    public void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public void setText(String text) {
        this.putValue("Name", text);
    }

    public String getText() {
        return (String)this.getValue("Name");
    }

    public void setTooltipText(String tooltipText) {
        this.putValue("ShortDescription", tooltipText);
    }

    public String getTooltipText() {
        return (String)this.getValue("ShortDescription");
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public boolean isVisibleOnTitleBar() {
        return this.visibleOnTitleBar;
    }

    public void setVisibleOnTitleBar(boolean visibleOnTitleBar) {
        if (this.visibleOnTitleBar == visibleOnTitleBar) {
            return;
        }
        boolean old = this.visibleOnTitleBar;
        this.visibleOnTitleBar = visibleOnTitleBar;
        this.firePropertyChange("visibleOnTitleBar", old, visibleOnTitleBar);
    }

    public boolean isVisibleOnMenuBar() {
        return this.visibleOnMenuBar;
    }

    public void setVisibleOnMenuBar(boolean visibleOnMenuBar) {
        if (this.visibleOnMenuBar == visibleOnMenuBar) {
            return;
        }
        boolean old = this.visibleOnMenuBar;
        this.visibleOnMenuBar = visibleOnMenuBar;
        this.firePropertyChange("visibleOnMenuBar", old, visibleOnMenuBar);
    }

    public boolean isShowTextOnTitleBar() {
        return this.showTextOnTitleBar;
    }

    public void setShowTextOnTitleBar(boolean showTextOnTitleBar) {
        this.showTextOnTitleBar = showTextOnTitleBar;
    }

    public void setVisible(boolean visible) {
        this.firePropertyChange("visibleOnTitleBar", !visible, visible);
        this.firePropertyChange("visibleOnMenuBar", !visible, visible);
    }

    public JMenuItem getMenuItem() {
        if (this.menuItem == null) {
            this.menuItem = new JMenuItem(this);
        }
        return this.menuItem;
    }
}

