/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp.event;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class FloatingMoveMouseInputHandler
implements MouseInputListener {
    static final int BORDER_DRAG_THICKNESS = 0;
    static final int CORNER_DRAG_WIDTH = 16;
    static final int[] cursorMapping = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};
    protected boolean isMovingWindow;
    protected int dragCursor;
    protected int dragOffsetX;
    protected int dragOffsetY;
    protected Component floatingContainer;
    protected Window floatingWindow;

    public FloatingMoveMouseInputHandler(Component floatingContainer) {
        this.floatingContainer = floatingContainer;
        if (floatingContainer instanceof Window) {
            this.floatingWindow = (Window)floatingContainer;
        }
    }

    public void mousePressed(MouseEvent ev) {
        Component w = (Component)ev.getSource();
        if (w != null) {
            if (this.floatingWindow != null) {
                this.floatingWindow.toFront();
            }
            Point dragWindowOffset = ev.getPoint();
            Point convertedDragWindowOffset = SwingUtilities.convertPoint(w, dragWindowOffset, ev.getComponent());
            if (ev.getComponent() != null && ev.getComponent().contains(convertedDragWindowOffset) && dragWindowOffset.y >= 0 && dragWindowOffset.x >= 0 && dragWindowOffset.x < w.getWidth() - 0) {
                this.isMovingWindow = true;
                this.dragOffsetX = dragWindowOffset.x;
                this.dragOffsetY = dragWindowOffset.y;
            }
        }
    }

    public void mouseReleased(MouseEvent ev) {
        if (this.isMovingWindow) {
            if (this.dragCursor != 0 && this.floatingContainer != null && !this.floatingContainer.isValid()) {
                this.floatingContainer.validate();
            }
            this.isMovingWindow = false;
            this.dragCursor = 0;
        }
    }

    public void mouseMoved(MouseEvent ev) {
    }

    public void mouseDragged(MouseEvent ev) {
        if (this.isMovingWindow) {
            Point pt = ev.getPoint();
            Point windowPt = this.floatingContainer instanceof Window ? this.floatingContainer.getLocationOnScreen() : this.floatingContainer.getLocation();
            windowPt.x += pt.x - this.dragOffsetX;
            windowPt.y += pt.y - this.dragOffsetY;
            if (this.floatingWindow != null) {
                Rectangle maxBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                if (windowPt.y < maxBounds.y) {
                    windowPt.y = maxBounds.y;
                }
            }
            this.floatingContainer.setLocation(windowPt);
        }
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void setFloatingContainer(Component floatingContainer) {
        this.floatingContainer = floatingContainer;
        this.floatingWindow = floatingContainer instanceof Window ? (Window)floatingContainer : null;
    }
}

