/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.util;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.noos.xing.mydoggy.plaf.support.UserPropertyChangeEvent;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentWindow;
import org.noos.xing.mydoggy.plaf.ui.cmp.FloatingWindow;
import org.noos.xing.mydoggy.plaf.ui.drag.DragListener;
import org.noos.xing.mydoggy.plaf.ui.transparency.TransparencyManager;
import org.noos.xing.mydoggy.plaf.ui.util.FindFocusableQuestion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingUtil {
    private static Map<Window, Rectangle> fullScreenBounds = new HashMap<Window, Rectangle>();
    private static Map<Component, DragEntry> dragEntryMap = new HashMap<Component, DragEntry>();

    private SwingUtil() {
    }

    public static void repaint(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                component.invalidate();
                component.validate();
                component.repaint();
            }
        });
    }

    public static void repaint(final Component component, final Runnable runnable) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                component.invalidate();
                component.validate();
                component.repaint();
                SwingUtilities.invokeLater(runnable);
            }
        });
    }

    public static void repaintNow(Component component) {
        component.invalidate();
        component.validate();
        component.repaint();
    }

    public static void revalidate(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                component.invalidate();
                component.validate();
            }
        });
    }

    public static void revalidate(final JComponent component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                component.revalidate();
            }
        });
    }

    public static List<Window> getTopContainers(String name) {
        Frame[] frames;
        Vector<Window> containers = new Vector<Window>();
        for (Frame frame : frames = Frame.getFrames()) {
            Window[] windows;
            for (Window window : windows = frame.getOwnedWindows()) {
                if (window.getName() == null || !window.getName().equals(name)) continue;
                containers.add(window);
            }
            if (containers.contains(frame)) continue;
            containers.add(frame);
        }
        return containers;
    }

    public static List<Window> getTopContainers() {
        Frame[] frames;
        Vector<Window> containers = new Vector<Window>();
        for (Frame frame : frames = Frame.getFrames()) {
            Window[] windows = frame.getOwnedWindows();
            containers.addAll(Arrays.asList(windows));
            if (containers.contains(frame)) continue;
            containers.add(frame);
        }
        return containers;
    }

    public static List<Window> getMyDoggyTopContainers() {
        Frame[] frames;
        Vector<Window> containers = new Vector<Window>();
        for (Frame frame : frames = Frame.getFrames()) {
            Window[] windows;
            if ((frame instanceof FloatingWindow || frame instanceof ContentWindow) && frame.isDisplayable()) {
                containers.add(frame);
            }
            for (Window window : windows = frame.getOwnedWindows()) {
                if (!(window instanceof FloatingWindow) && !(window instanceof ContentWindow) || !window.isDisplayable()) continue;
                containers.add(window);
            }
        }
        return containers;
    }

    public static List<ContentWindow> getContentWindows() {
        Frame[] frames;
        ArrayList<ContentWindow> containers = new ArrayList<ContentWindow>();
        for (Frame frame : frames = Frame.getFrames()) {
            Window[] windows;
            if (frame instanceof ContentWindow && frame.isDisplayable() && !((ContentWindow)((Object)frame)).isDisposed()) {
                containers.add((ContentWindow)((Object)frame));
            }
            for (Window window : windows = frame.getOwnedWindows()) {
                if (!(window instanceof ContentWindow) || !frame.isDisplayable() || ((ContentWindow)((Object)window)).isDisposed()) continue;
                containers.add((ContentWindow)((Object)window));
            }
        }
        return containers;
    }

    public static Object getDeepestObjectAt(Object parent, int x, int y) {
        Component child;
        if (parent != null && parent instanceof Container && (child = SwingUtil.findComponentAt((Container)parent, x, y)) != null && child != parent) {
            if (child instanceof JRootPane) {
                JLayeredPane lp = ((JRootPane)child).getLayeredPane();
                Rectangle b = lp.getBounds();
                child = (Component)SwingUtil.getDeepestObjectAt(lp, x - b.x, y - b.y);
                if (child != null) {
                    return child;
                }
            } else {
                return child;
            }
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component findComponentAt(Container cont, int x, int y) {
        Object object = cont.getTreeLock();
        synchronized (object) {
            return SwingUtil.findComponentAt(cont, x, y, true, false);
        }
    }

    public static Component findComponentAt(Container cont, int x, int y, boolean ignoreEnabled, boolean ignoreGlassPane) {
        Point point;
        Component comp;
        int i;
        if (!(cont instanceof CellRendererPane || cont.getParent() instanceof CellRendererPane || cont.contains(x, y) && (ignoreEnabled || cont.isEnabled()))) {
            return null;
        }
        int ncomponents = cont.getComponentCount();
        Component[] component = cont.getComponents();
        Component glassPane = null;
        if (ignoreGlassPane && cont instanceof JRootPane) {
            glassPane = ((JRootPane)cont).getGlassPane();
        }
        for (i = 0; i < ncomponents; ++i) {
            comp = component[i];
            if (comp == null || comp == glassPane || comp.isLightweight()) continue;
            point = comp.getLocation();
            if ((comp = comp instanceof Container ? SwingUtil.findComponentAt((Container)comp, x - point.x, y - point.y, ignoreEnabled, ignoreGlassPane) : comp.getComponentAt(x - point.x, y - point.y)) == null || !comp.isVisible() || !ignoreEnabled && !comp.isEnabled()) continue;
            return comp;
        }
        for (i = 0; i < ncomponents; ++i) {
            comp = component[i];
            if (comp == null || comp == glassPane || !comp.isLightweight()) continue;
            point = comp.getLocation();
            if ((comp = comp instanceof Container ? SwingUtil.findComponentAt((Container)comp, x - point.x, y - point.y, ignoreEnabled, ignoreGlassPane) : comp.getComponentAt(x - point.x, y - point.y)) == null || !comp.isVisible() || !ignoreEnabled && !comp.isEnabled()) continue;
            return comp;
        }
        return cont;
    }

    public static Component findFocusable(Component cmp) {
        return ((FindFocusableQuestion)UIManager.get(FindFocusableQuestion.class)).getAnswer(cmp);
    }

    public static void requestFocus(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Window ancestor = SwingUtilities.getWindowAncestor(component);
                if (ancestor != null && ancestor.isFocused()) {
                    component.requestFocusInWindow();
                } else {
                    component.requestFocus();
                }
            }
        });
    }

    public static Component findAndRequestFocus(Component component) {
        Container container;
        if (component instanceof JDialog) {
            container = ((JDialog)component).getContentPane();
        } else if (component instanceof Container) {
            container = (Container)component;
        } else {
            return null;
        }
        Component focusRequester = SwingUtil.findFocusable(container);
        if (focusRequester == null) {
            focusRequester = container;
        }
        SwingUtil.requestFocus(focusRequester);
        return focusRequester;
    }

    public static boolean hasParent(Component component, Component parent) {
        for (Container p = component.getParent(); p != null; p = p.getParent()) {
            if (p != parent) continue;
            return true;
        }
        return false;
    }

    public static boolean isAncestor(Component component, Component parent) {
        if (component == null || parent == null) {
            return false;
        }
        if (component == parent) {
            return true;
        }
        for (Container p = component.getParent(); p != null; p = p.getParent()) {
            if (p != parent) continue;
            return true;
        }
        return false;
    }

    public static Component getParent(Component c, String parentName) {
        if (c == null || parentName == null) {
            return null;
        }
        if (c.getName() != null && c.getName().startsWith(parentName)) {
            return c;
        }
        while (c != null) {
            if (c.getName() != null && c.getName().startsWith(parentName)) {
                return c;
            }
            c = c.getParent();
        }
        return null;
    }

    public static <T> T getParent(Component c, Class<? extends T> parentClass) {
        if (c == null || parentClass == null) {
            return null;
        }
        if (parentClass.isInstance(c)) {
            return (T)c;
        }
        while (c != null) {
            if (parentClass.isInstance(c)) {
                return (T)c;
            }
            c = c.getParent();
        }
        return null;
    }

    public static <T> T getParentClientProperty(Component c, Class<? extends T> propertyIdClass) {
        Object t;
        if (c == null || propertyIdClass == null) {
            return null;
        }
        if (c instanceof JComponent && (t = ((JComponent)c).getClientProperty(propertyIdClass)) != null) {
            return (T)t;
        }
        while (c != null) {
            if (c instanceof JComponent && (t = ((JComponent)c).getClientProperty(propertyIdClass)) != null) {
                return (T)t;
            }
            c = c.getParent();
        }
        return null;
    }

    public static Component getComponentWhoseParentIs(Component c, Component p) {
        if (c == null || p == null) {
            return null;
        }
        while (c != null) {
            if (c.getParent() == p) {
                return c;
            }
            c = c.getParent();
        }
        return null;
    }

    public static Component getWindowAncestor(Component c) {
        for (Container p = c.getParent(); p != null; p = p.getParent()) {
            if (p instanceof Window) {
                return p;
            }
            if (!(p instanceof Applet)) continue;
            return p;
        }
        return null;
    }

    public static Icon loadIcon(String urlDef) {
        return SwingUtil.loadIcon(SwingUtil.class.getClassLoader(), urlDef);
    }

    public static Icon loadIcon(ClassLoader classLoader, String urlDef) {
        try {
            URL url;
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            if ((url = classLoader.getResource(urlDef)) == null) {
                throw new IllegalArgumentException("Invalid URL : " + urlDef);
            }
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(url));
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot load icon : " + e.getMessage(), e);
        }
    }

    public static Image loadImage(String url) {
        try {
            return Toolkit.getDefaultToolkit().getImage(SwingUtil.class.getClassLoader().getResource(url));
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot load image : " + e.getMessage(), e);
        }
    }

    public static BufferedImage loadImageIO(String url) {
        try {
            return ImageIO.read(SwingUtil.class.getClassLoader().getResource(url));
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot load buffered image : " + e.getMessage(), e);
        }
    }

    public static void convertPointToScreen(Point p, Component c) {
        if (c == null) {
            return;
        }
        do {
            int y;
            int x;
            if (c instanceof JComponent) {
                x = c.getX();
                y = c.getY();
            } else if (c instanceof Applet || c instanceof Window) {
                try {
                    Point pp = c.getLocationOnScreen();
                    x = pp.x;
                    y = pp.y;
                }
                catch (IllegalComponentStateException icse) {
                    x = c.getX();
                    y = c.getY();
                }
            } else {
                x = c.getX();
                y = c.getY();
            }
            p.x += x;
            p.y += y;
        } while (!(c instanceof Window) && !(c instanceof Applet) && (c = c.getParent()) != null);
    }

    public static Rectangle getVirtualScreenBounds() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return ge.getMaximumWindowBounds();
    }

    public static Rectangle validateBounds(Rectangle bounds, Rectangle referenceBounds) {
        if (bounds == null) {
            return null;
        }
        if (bounds.x < referenceBounds.x) {
            bounds.x = referenceBounds.x;
        }
        if ((double)bounds.x > referenceBounds.getMaxX()) {
            bounds.x = (int)referenceBounds.getMaxX() - bounds.width;
        }
        if (bounds.y < referenceBounds.y) {
            bounds.y = referenceBounds.y;
        }
        if ((double)bounds.y > referenceBounds.getMaxY()) {
            bounds.y = (int)referenceBounds.getMaxY() - bounds.height;
        }
        return bounds;
    }

    public static Rectangle validateBounds(Rectangle bounds) {
        return SwingUtil.validateBounds(bounds, SwingUtil.getVirtualScreenBounds());
    }

    public static void validateBounds(Component component) {
        component.setBounds(SwingUtil.validateBounds(component.getBounds(), SwingUtil.getVirtualScreenBounds()));
    }

    public static void validateBounds(Component component, Rectangle referenceBounds) {
        component.setBounds(SwingUtil.validateBounds(component.getBounds(), referenceBounds));
    }

    public static void setFullScreen(Window window) {
        GraphicsDevice[] gda = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (gda.length > 1) {
            Rectangle targetBounds = window.getBounds();
            fullScreenBounds.put(window, targetBounds);
            Point location = window.getLocationOnScreen();
            for (GraphicsDevice graphicsDevice : gda) {
                Rectangle bounds = graphicsDevice.getDefaultConfiguration().getBounds();
                if (graphicsDevice.getType() != 0 || !bounds.contains(location)) continue;
                targetBounds = bounds;
                break;
            }
            window.setBounds(targetBounds);
        } else {
            Rectangle targetBounds = window.getBounds();
            fullScreenBounds.put(window, targetBounds);
            window.setBounds(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
        }
    }

    public static void restoreFullScreenWindow(Window window) {
        Rectangle bounds = fullScreenBounds.remove(window);
        if (bounds != null) {
            window.setBounds(bounds);
        } else {
            GraphicsDevice graphicsDevice = window.getGraphicsConfiguration().getDevice();
            if (graphicsDevice.isFullScreenSupported()) {
                graphicsDevice.setFullScreenWindow(null);
            }
        }
    }

    public static Rectangle getScreenWindowBounds(Window window) {
        return fullScreenBounds.remove(window);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadPropertiesFile(String resourceName, ClassLoader classLoader) {
        Properties properties;
        InputStream is = null;
        try {
            try {
                URL resource = SwingUtil.getUrl(classLoader, "META-INF/" + resourceName);
                if (resource == null) {
                    File file = new File(resourceName);
                    if (file.exists()) {
                        resource = file.toURI().toURL();
                    } else {
                        file = new File(System.getProperty("user.home") + File.separator + resourceName);
                        if (!file.exists()) throw new RuntimeException("Cannot find resource property file called " + resourceName + ".");
                        resource = file.toURI().toURL();
                    }
                }
                is = resource.openStream();
                Properties properties2 = new Properties();
                properties2.load(is);
                properties = properties2;
                Object var7_7 = null;
                if (is == null) return properties;
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot load resource property file.", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return properties;
        }
        is.close();
        return properties;
    }

    public static Object newObject(ClassLoader classLoader, String className) {
        try {
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            return classLoader.loadClass(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(PropertyChangeEvent event) {
        return event.getPropertyName() + ":\n\t" + event.getSource() + ":\n\t" + event.getOldValue() + ":\n\t" + event.getNewValue();
    }

    public static URL getUrl(ClassLoader classLoader, String url) {
        URL result = null;
        if (classLoader != null) {
            result = classLoader.getResource(url);
        }
        if (result == null) {
            result = SwingUtil.class.getClassLoader().getResource(url);
        }
        if (result == null) {
            result = Thread.currentThread().getContextClassLoader().getResource(url);
        }
        if (result == null) {
            result = ClassLoader.getSystemClassLoader().getResource(url);
        }
        return result;
    }

    public static DragGestureRecognizer registerDragListener(Component c, DragListener dragListener) {
        if (dragEntryMap.containsKey(c)) {
            return SwingUtil.dragEntryMap.get((Object)c).dragGestureRecognizer;
        }
        DragSource dragSource = new DragSource();
        DragGestureRecognizer recognizer = dragSource.createDefaultDragGestureRecognizer(c, 2, dragListener);
        dragSource.addDragSourceMotionListener(dragListener);
        dragEntryMap.put(c, new DragEntry(recognizer, dragListener));
        return recognizer;
    }

    public static void unregisterDragListener(DragGestureRecognizer recognizer, DragListener dragListener) {
        recognizer.getDragSource().removeDragSourceMotionListener(dragListener);
        recognizer.removeDragGestureListener(dragListener);
    }

    public static void unregisterDragListener(Component c) {
        DragEntry dragEntry = dragEntryMap.remove(c);
        if (dragEntry == null) {
            return;
        }
        dragEntry.dragGestureRecognizer.getDragSource().removeDragSourceMotionListener(dragEntry.dragListener);
        dragEntry.dragGestureRecognizer.removeDragGestureListener(dragEntry.dragListener);
    }

    public static void addKeyActionMapping(JComponent component, KeyStroke keyStroke, Object actionMapKey, Action action) {
        SwingUtil.addKeyActionMapping(0, component, keyStroke, actionMapKey, action);
    }

    public static void addKeyActionMapping(int condition, JComponent component, KeyStroke keyStroke, Object actionMapKey, Action action) {
        component.getInputMap(condition).put(keyStroke, actionMapKey);
        component.getActionMap().put(actionMapKey, action);
    }

    public static void centrePositionOnScreen(Window window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = window.getSize();
        window.setLocation(screenSize.width - frameSize.width >> 1, screenSize.height - frameSize.height >> 1);
    }

    public static boolean isLeftToRight(Component c) {
        return c != null && c.getComponentOrientation().isLeftToRight();
    }

    public static void dispatchEvent(Object src, AWTEvent event) {
        if (src instanceof Component) {
            ((Component)src).dispatchEvent(event);
        } else if (src instanceof MenuComponent) {
            ((MenuComponent)src).dispatchEvent(event);
        }
    }

    public static int getIconWidth(Icon icon) {
        return icon != null ? icon.getIconWidth() : 0;
    }

    public static int getIconHeight(Icon icon) {
        return icon != null ? icon.getIconHeight() : 0;
    }

    public static int findDisplayedMnemonicIndex(String text, int mnemonic) {
        if (text == null || mnemonic == 0) {
            return -1;
        }
        char uc = Character.toUpperCase((char)mnemonic);
        char lc = Character.toLowerCase((char)mnemonic);
        int uci = text.indexOf(uc);
        int lci = text.indexOf(lc);
        if (uci == -1) {
            return lci;
        }
        if (lci == -1) {
            return uci;
        }
        return lci < uci ? lci : uci;
    }

    public static Point convertPointFromScreen(Point p, Component c) {
        do {
            int y;
            int x;
            if (c instanceof JComponent) {
                x = c.getX();
                y = c.getY();
            } else if (c instanceof Applet || c instanceof Window) {
                try {
                    Point pp = c.getLocationOnScreen();
                    x = pp.x;
                    y = pp.y;
                }
                catch (IllegalComponentStateException icse) {
                    x = c.getX();
                    y = c.getY();
                }
            } else {
                x = c.getX();
                y = c.getY();
            }
            p.x -= x;
            p.y -= y;
        } while (!(c instanceof Window) && !(c instanceof Applet) && (c = c.getParent()) != null);
        return p;
    }

    public static Point convertPointFromScreen2(Point p, Component c) {
        do {
            int y;
            int x;
            if (c instanceof JComponent) {
                x = c.getX();
                y = c.getY();
            } else if (c instanceof Applet || c instanceof Window) {
                try {
                    Point pp = c.getLocationOnScreen();
                    x = pp.x;
                    y = pp.y;
                }
                catch (IllegalComponentStateException icse) {
                    x = c.getX();
                    y = c.getY();
                }
                if (c instanceof RootPaneContainer) {
                    try {
                        JMenuBar menuBar = ((RootPaneContainer)((Object)c)).getRootPane().getJMenuBar();
                        if (menuBar != null) {
                            y += menuBar.getHeight();
                        }
                    }
                    catch (Exception e) {}
                }
            } else {
                x = c.getX();
                y = c.getY();
            }
            p.x -= x;
            p.y -= y;
        } while (!(c instanceof Window) && !(c instanceof Applet) && (c = c.getParent()) != null);
        return p;
    }

    public static Point convertPoint(Component source, Point aPoint, Component destination) {
        if (source == null && destination == null) {
            return aPoint;
        }
        if (source == null && (source = SwingUtilities.getWindowAncestor(destination)) == null) {
            throw new Error("Source component not connected to component tree hierarchy");
        }
        Point p = new Point(aPoint);
        SwingUtil.convertPointToScreen(p, source);
        if (destination == null && (destination = SwingUtil.getWindowAncestor(source)) == null) {
            throw new Error("Destination component not connected to component tree hierarchy");
        }
        SwingUtil.convertPointFromScreen2(p, destination);
        return p;
    }

    public static void setWindowTitle(Component component, String title) {
        Window window = SwingUtilities.windowForComponent(component);
        if (window instanceof Dialog) {
            ((Dialog)window).setTitle(title);
        } else if (window instanceof Frame) {
            ((Frame)window).setTitle(title);
        } else {
            throw new IllegalArgumentException("Cannot set title for that component");
        }
    }

    public static void installFont(JComponent component, String name) {
        Font newfont = UIManager.getFont(name);
        if (newfont != null) {
            component.setFont(newfont);
        }
    }

    public static final <T> T getClientProperty(JComponent c, Object key) {
        return (T)c.getClientProperty(key);
    }

    public static boolean getBoolean(String name, boolean defaultValue) {
        if (UIManager.getDefaults().containsKey(name)) {
            return UIManager.getBoolean(name);
        }
        return defaultValue;
    }

    public static BufferedImage getImage(String name) {
        return (BufferedImage)UIManager.get(name);
    }

    public static float getFloat(String name, float defaultValue) {
        if (UIManager.getDefaults().containsKey(name)) {
            return ((Float)UIManager.get(name)).floatValue();
        }
        return defaultValue;
    }

    public static int getInt(String name, int defaultValue) {
        if (UIManager.getDefaults().containsKey(name)) {
            return (Integer)UIManager.get(name);
        }
        return defaultValue;
    }

    public static Color getColor(String key, Color defaultColor) {
        if (UIManager.getDefaults().containsKey(key)) {
            return UIManager.getColor(key);
        }
        return defaultColor;
    }

    public static TransparencyManager<Window> getTransparencyManager() {
        return (TransparencyManager)UIManager.get(TransparencyManager.class);
    }

    public static Border getBorder(String key, Border border) {
        Border result = UIManager.getBorder(key);
        return result != null ? result : border;
    }

    public static ResourceBundle getResourceBundle() {
        return (ResourceBundle)UIManager.get("mydoggy.resourceBundle");
    }

    public static String getString(String key) {
        ResourceBundle resourceBundle = (ResourceBundle)UIManager.get("mydoggy.resourceBundle");
        try {
            return resourceBundle.getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    public static String getUserString(String key) {
        ResourceBundle resourceBundle = (ResourceBundle)UIManager.get("mydoggy.resourceBundle.user");
        try {
            return resourceBundle.getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    public static int getInt(PropertyChangeEvent e, int defaultValue) {
        UserPropertyChangeEvent event;
        if (e instanceof UserPropertyChangeEvent && (event = (UserPropertyChangeEvent)e).getUserObject() instanceof Integer) {
            return (Integer)event.getUserObject();
        }
        return defaultValue;
    }

    public static <T> T getAt(PropertyChangeEvent e, int index, T defaultValue) {
        UserPropertyChangeEvent event;
        if (e instanceof UserPropertyChangeEvent && (event = (UserPropertyChangeEvent)e).getUserObject() instanceof Object[]) {
            Object[] objects = (Object[])event.getUserObject();
            return (T)objects[index];
        }
        return defaultValue;
    }

    public static void updateComponentTreeUI(Component c) {
        SwingUtil.updateComponentTreeUI0(c, 0);
        c.invalidate();
        c.validate();
        c.repaint();
    }

    private static void updateComponentTreeUI0(Component c, int level) {
        System.out.printf("%s%s", SwingUtil.space(level), c.toString());
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.updateUI();
            JPopupMenu jpm = jc.getComponentPopupMenu();
            if (jpm != null && jpm.isVisible() && jpm.getInvoker() == jc) {
                SwingUtil.updateComponentTreeUI(jpm);
            }
        }
        Component[] children = null;
        if (c instanceof JMenu) {
            children = ((JMenu)c).getMenuComponents();
        } else if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                SwingUtil.updateComponentTreeUI0(children[i], level + 1);
            }
        }
    }

    public static String space(int level) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            buffer.append("  ");
        }
        return buffer.toString();
    }

    public static void installColorsAndFont(JComponent c, String defaultBgName, String defaultFgName, String defaultFontName) {
        Font f = c.getFont();
        if (f == null || f instanceof UIResource && UIManager.getDefaults().containsKey(defaultFgName)) {
            c.setFont(UIManager.getFont(defaultFontName));
        }
        SwingUtil.installColors(c, defaultBgName, defaultFgName);
    }

    public static void installColors(JComponent c, String defaultBgName, String defaultFgName) {
        Color fg;
        Color bg = c.getBackground();
        if (bg == null || bg instanceof UIResource && UIManager.getDefaults().containsKey(defaultBgName)) {
            c.setBackground(UIManager.getColor(defaultBgName));
        }
        if ((fg = c.getForeground()) == null || fg instanceof UIResource && UIManager.getDefaults().containsKey(defaultFgName)) {
            c.setForeground(UIManager.getColor(defaultFgName));
        }
    }

    public static void installBorder(JComponent c, String defaultBorderName) {
        Border b = c.getBorder();
        if (b == null || b instanceof UIResource && UIManager.getDefaults().containsKey(defaultBorderName)) {
            c.setBorder(UIManager.getBorder(defaultBorderName));
        }
    }

    public static class DragEntry {
        DragGestureRecognizer dragGestureRecognizer;
        DragListener dragListener;

        public DragEntry(DragGestureRecognizer dragGestureRecognizer, DragListener dragListener) {
            this.dragGestureRecognizer = dragGestureRecognizer;
            this.dragListener = dragListener;
        }
    }
}

