/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.TabbedPaneUI;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManager;
import org.noos.xing.mydoggy.ContentUI;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.cmp.AggregateIcon;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiDockableOwner;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultipleAggregateIcon;
import org.noos.xing.mydoggy.plaf.ui.cmp.TextIcon;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.TabbedContentPaneEvent;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.TabbedContentPaneListener;
import org.noos.xing.mydoggy.plaf.ui.drag.DragListener;
import org.noos.xing.mydoggy.plaf.ui.drag.DragListenerAdapter;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.util.RemoveNotifyDragListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class TabbedContentPane
extends JTabbedPane
implements PropertyChangeListener,
MultiDockableOwner {
    protected static final int LINEWIDTH = 3;
    protected static final String TRANSFERABLE_NAME = "TabbedTransferable";
    protected MyDoggyToolWindowManager toolWindowManager;
    protected Map<Integer, Content> contentMap;
    protected Map<Content, Object> flashingContents;
    protected ExMultipleAggregateIcon aggregateIcon;
    protected TextIcon titleIcon;
    protected ByteArrayOutputStream tmpWorkspace = null;
    protected MouseInputAdapter mouseInputAdapter;
    protected String currentToolTip;
    protected boolean dragEnabled;
    protected boolean showMaximize = true;
    protected boolean showDetach = true;
    protected boolean showClose = true;
    protected boolean showMinimize = true;
    protected RemoveNotifyDragListener removeNotifyDragListener;
    protected DragSource dragSource = new DragSource();
    protected DragListener dragListener;
    protected Point tabPointerLocation = new Point(-1, 0);
    protected Image tabPointer;
    protected int dragTabIndex = -1;
    protected int indexAtLocation;
    protected boolean pointerVisible;
    public boolean valueAdjusting = false;

    public TabbedContentPane() {
        this(false);
    }

    public TabbedContentPane(boolean dragEnabled) {
        this.setTabLayoutPolicy(1);
        this.setFocusable(false);
        this.setInheritsPopupMenu(false);
        this.contentMap = new Hashtable<Integer, Content>();
        this.flashingContents = new HashMap<Content, Object>();
        this.aggregateIcon = new ExMultipleAggregateIcon(6, 0);
        this.titleIcon = new TextIcon(this, "", 1);
        this.aggregateIcon.setIconAt(1, this.titleIcon);
        this.tabPointer = SwingUtil.getImage("TabbedContentPane.image.contentPointer");
        this.dragEnabled = dragEnabled;
        this.mouseInputAdapter = new MouseOverTabListener();
        this.addMouseListener(this.mouseInputAdapter);
        this.addMouseMotionListener(this.mouseInputAdapter);
    }

    public Dockable getDockable() {
        return null;
    }

    public Dockable getDockable(int index) {
        return this.getContentAt(index);
    }

    public int getDockableIndex(Point point) {
        return this.indexAtLocation(point.x, point.y);
    }

    public int getDockableIndex() {
        return this.indexAtLocation;
    }

    public void setPointerVisible(boolean visible) {
        this.pointerVisible = visible;
        SwingUtil.repaint(this);
    }

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.tabPointerLocation.x < 0) {
            return;
        }
        if (this.pointerVisible && this.indexAtLocation != -1) {
            g.drawImage(this.tabPointer, this.tabPointerLocation.x, this.tabPointerLocation.y, this);
        }
        if (this.dragTabIndex >= 0) {
            g.drawImage(this.tabPointer, this.tabPointerLocation.x, this.tabPointerLocation.y, this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("flash".equals(evt.getPropertyName())) {
            if (evt.getNewValue() == Boolean.TRUE) {
                this.flashingContents.put((Content)evt.getSource(), null);
                SwingUtil.repaint(this);
            } else {
                this.flashingContents.remove((Content)evt.getSource());
                SwingUtil.repaint(this);
            }
        } else if ("selected".equals(evt.getPropertyName())) {
            this.flashingContents.remove((Content)evt.getSource());
            SwingUtil.repaint(this);
        }
    }

    public String getTitleAt(int index) {
        if (this.getSelectedIndex() == index) {
            return "";
        }
        return super.getTitleAt(index);
    }

    public Icon getIconAt(int index) {
        if (this.getSelectedIndex() == index) {
            Content content = this.contentMap.get(index);
            if (content == null) {
                return super.getIconAt(index);
            }
            ContentUI contentUI = content.getContentUI();
            if (contentUI == null) {
                return super.getIconAt(index);
            }
            this.aggregateIcon.setIconAt(0, super.getIconAt(index));
            this.titleIcon.setText(super.getTitleAt(index));
            this.titleIcon.setUnderlinedIndex(SwingUtil.findDisplayedMnemonicIndex(super.getTitleAt(index), this.getContentAt(index).getMnemonic()));
            this.aggregateIcon.setVisibleAt(2, contentUI.isMinimizable() && this.showMinimize);
            if (content.isMaximized() || this.getContentMaximized(content) != null) {
                this.aggregateIcon.setIconAt(3, UIManager.getIcon("TabbedContentPane.icon.contentPageRestore"));
            } else {
                this.aggregateIcon.setIconAt(3, UIManager.getIcon("TabbedContentPane.icon.contentPageMaximize"));
            }
            this.aggregateIcon.setVisibleAt(3, contentUI.isMaximizable() && this.showMaximize);
            this.aggregateIcon.setVisibleAt(4, contentUI.isDetachable() && this.showDetach);
            this.aggregateIcon.setVisibleAt(5, contentUI.isCloseable() && this.showClose);
            this.aggregateIcon.setIndex(index);
            return this.aggregateIcon;
        }
        if (this.flashingContents.containsKey(this.getContentAt(index))) {
            Content content = this.getContentAt(index);
            Object o = this.flashingContents.get(content);
            if (o == null) {
                AggregateIcon icon = new AggregateIcon(UIManager.getIcon("TabbedContentPane.icon.contentFlashing"), super.getIconAt(index), 0);
                this.flashingContents.put(content, icon);
                return icon;
            }
            return (Icon)o;
        }
        return super.getIconAt(index);
    }

    public void removeTabAt(int index) {
        Content content = this.getContentAt(index);
        if (content == null) {
            throw new IllegalArgumentException("Invalid index location.");
        }
        content.removePropertyChangeListener(this);
        super.removeTabAt(index);
        this.contentMap.remove(index);
        Object[] keys = this.contentMap.keySet().toArray(new Integer[this.contentMap.size()]);
        Arrays.sort(keys);
        for (Object key : keys) {
            if ((Integer)key <= index) continue;
            this.contentMap.put((Integer)key - 1, this.contentMap.remove(key));
        }
    }

    public void setUI(TabbedPaneUI ui) {
        super.setUI(ui);
        this.setFocusable(false);
        this.setInheritsPopupMenu(false);
        this.removeMouseListener(this.mouseInputAdapter);
        this.removeMouseMotionListener(this.mouseInputAdapter);
        this.addMouseListener(this.mouseInputAdapter);
        this.addMouseMotionListener(this.mouseInputAdapter);
    }

    public String getToolTipText(MouseEvent event) {
        if (this.currentToolTip != null) {
            return this.currentToolTip;
        }
        return super.getToolTipText(event);
    }

    public void addNotify() {
        super.addNotify();
        if (this.dragListener != null) {
            this.toolWindowManager.removeRemoveNotifyListener(this.removeNotifyDragListener);
            this.removeNotifyDragListener = new RemoveNotifyDragListener(this, this.dragListener);
            this.toolWindowManager.addRemoveNotifyListener(this.removeNotifyDragListener);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeNotifyDragListener.cleanup();
        this.toolWindowManager.removeRemoveNotifyListener(this.removeNotifyDragListener);
    }

    public boolean containsDockable(Dockable dockable) {
        for (Content content : this.contentMap.values()) {
            if (content != dockable) continue;
            return true;
        }
        return false;
    }

    public void setComponent(Dockable dockable, Component component) {
        for (Integer index : this.contentMap.keySet()) {
            if (this.contentMap.get(index) != dockable) continue;
            this.setComponentAt(index, component);
            return;
        }
    }

    public Component getComponent() {
        throw new IllegalStateException("Cannot call this method here.");
    }

    public void setComponent(Component component) {
        throw new IllegalStateException("Cannot call this method here.");
    }

    public void setToolWindowManager(MyDoggyToolWindowManager toolWindowManager) {
        this.toolWindowManager = toolWindowManager;
        this.aggregateIcon.setIconAt(2, UIManager.getIcon("TabbedContentPane.icon.contentPageMinimize"));
        this.aggregateIcon.setIconAt(3, UIManager.getIcon("TabbedContentPane.icon.contentPageMaximize"));
        this.aggregateIcon.setIconAt(4, UIManager.getIcon("TabbedContentPane.icon.contentPageDetach"));
        this.aggregateIcon.setIconAt(5, UIManager.getIcon("TabbedContentPane.icon.contentPageClose"));
        if (this.dragEnabled) {
            this.initDragListener();
        }
    }

    public void addTab(Content content) {
        String tip = content.getToolTipText();
        this.addTab(content.getTitle(), content.getIcon(), content.getComponent(), tip);
        int index = this.getTabCount() - 1;
        this.setForegroundAt(index, content.getForeground());
        this.setDisabledIconAt(index, content.getDisabledIcon());
        this.setMnemonicAt(index, content.getMnemonic());
        content.addPropertyChangeListener(this);
        this.contentMap.put(index, content);
    }

    public void addTab(Content content, Component component) {
        String tip = content.getToolTipText();
        if (component == null) {
            component = content.getComponent();
        }
        this.addTab(content.getTitle(), content.getIcon(), component, tip);
        int index = this.getTabCount() - 1;
        this.setForegroundAt(index, content.getForeground());
        this.setDisabledIconAt(index, content.getDisabledIcon());
        this.setMnemonicAt(index, content.getMnemonic());
        content.addPropertyChangeListener(this);
        this.contentMap.put(index, content);
    }

    public int addTab(Content content, Component component, int index) {
        if (index < 0 || index >= this.getTabCount()) {
            this.addTab(content, component);
            return this.getTabCount() - 1;
        }
        String tip = content.getToolTipText();
        if (component == null) {
            component = content.getComponent();
        }
        Integer[] keys = this.contentMap.keySet().toArray(new Integer[this.contentMap.size()]);
        Arrays.sort(keys, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1 < o2 ? 1 : (o1.equals(o2) ? 0 : -11);
            }
        });
        this.insertTab(content.getTitle(), content.getIcon(), component, tip, index);
        for (Integer key : keys) {
            if (key < index || !this.contentMap.containsKey(key)) continue;
            this.contentMap.put(key + 1, this.contentMap.remove(key));
        }
        this.setForegroundAt(index, content.getForeground());
        this.setDisabledIconAt(index, content.getDisabledIcon());
        this.setMnemonicAt(index, content.getMnemonic());
        content.addPropertyChangeListener(this);
        this.contentMap.put(index, content);
        return index;
    }

    public Content getContentAt(int index) {
        return this.contentMap.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setIndex(final Content content, Integer newIndex) {
        if (newIndex < 0 || newIndex >= this.getTabCount()) {
            throw new IllegalArgumentException("Invalid index");
        }
        boolean selected = content.isSelected();
        this.valueAdjusting = true;
        try {
            int index = this.indexOfContent(content);
            if (index != -1) {
                content.setSelected(false);
                this.removeTabAt(index);
                this.addTab(content, content.getComponent(), newIndex);
            }
        }
        finally {
            this.valueAdjusting = false;
        }
        if (selected) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    content.setSelected(true);
                }
            });
        }
    }

    public int indexOfContent(Content content) {
        for (Integer key : this.contentMap.keySet()) {
            if (this.contentMap.get(key) != content) continue;
            return key;
        }
        return -1;
    }

    public Object getSelectedContent() {
        int index = this.getSelectedIndex();
        return index != -1 ? this.getContentAt(index) : null;
    }

    public void setDragListener(DragListener dragListener) {
        this.dragListener = dragListener;
        this.removeNotifyDragListener = new RemoveNotifyDragListener(this, dragListener);
        this.toolWindowManager.addRemoveNotifyListener(this.removeNotifyDragListener);
    }

    public void addTabbedContentPaneListener(TabbedContentPaneListener listener) {
        this.listenerList.add(TabbedContentPaneListener.class, listener);
    }

    public void removeTabbedContentPaneListener(TabbedContentPaneListener listener) {
        this.listenerList.remove(TabbedContentPaneListener.class, listener);
    }

    public boolean isShowMaximize() {
        return this.showMaximize;
    }

    public void setShowMaximize(boolean showMaximize) {
        this.showMaximize = showMaximize;
    }

    public boolean isShowDetach() {
        return this.showDetach;
    }

    public void setShowDetach(boolean showDetach) {
        this.showDetach = showDetach;
    }

    public boolean isShowClose() {
        return this.showClose;
    }

    public void setShowClose(boolean showClose) {
        this.showClose = showClose;
    }

    public boolean isShowMinimize() {
        return this.showMinimize;
    }

    public void setShowMinimize(boolean showMinimize) {
        this.showMinimize = showMinimize;
    }

    protected void initDragListener() {
        this.setDragListener(new TabbedDragListenerAdapter(this.toolWindowManager));
        this.setDropTarget(new DropTarget(this, 3, new TabbedDropTargetListener(), true));
    }

    protected void initTargetLeftRightLine(int next) {
        if (next < 0) {
            this.tabPointerLocation.setLocation(-1, 0);
        } else if (next == this.getTabCount()) {
            Rectangle rect = this.getBoundsAt(this.getTabCount() - 1);
            this.tabPointerLocation.setLocation(rect.x + rect.width - 1, rect.y);
        } else if (this.dragTabIndex == next) {
            this.tabPointerLocation.setLocation(-1, 0);
        } else if (next == 0) {
            Rectangle rect = this.getBoundsAt(0);
            this.tabPointerLocation.setLocation(0, rect.y);
        } else {
            Rectangle rect = this.getBoundsAt(next - 1);
            this.tabPointerLocation.setLocation(rect.x + rect.width - 1, rect.y);
        }
    }

    protected void initTargetTopBottomLine(int next) {
        if (next < 0) {
            this.tabPointerLocation.setLocation(-1, 0);
        } else if (next == this.getTabCount()) {
            Rectangle rect = this.getBoundsAt(this.getTabCount() - 1);
            this.tabPointerLocation.setLocation(rect.x, rect.y + rect.height - 1);
        } else if (this.dragTabIndex == next) {
            this.tabPointerLocation.setLocation(-1, 0);
        } else if (next == 0) {
            Rectangle rect = this.getBoundsAt(0);
            this.tabPointerLocation.setLocation(rect.x, 0);
        } else {
            Rectangle rect = this.getBoundsAt(next - 1);
            this.tabPointerLocation.setLocation(rect.x, rect.y + rect.height - 1);
        }
    }

    protected Rectangle getTabAreaBound() {
        Rectangle lastTab = this.getUI().getTabBounds(this, this.getTabCount() - 1);
        return new Rectangle(0, 0, this.getWidth(), lastTab.y + lastTab.height);
    }

    protected void moveTab(int prev, int next) {
        if (next < 0 || prev == next) {
            return;
        }
        Component cmp = this.getComponentAt(prev);
        Content content = this.getContentAt(prev);
        if (content == null) {
            throw new IllegalArgumentException("Invalid index location.");
        }
        content.removePropertyChangeListener(this);
        super.removeTabAt(prev);
        this.contentMap.remove(prev);
        Object[] keys = this.contentMap.keySet().toArray(new Integer[this.contentMap.size()]);
        Arrays.sort(keys);
        for (Object key : keys) {
            if ((Integer)key <= prev) continue;
            this.contentMap.put((Integer)key - 1, this.contentMap.remove(key));
        }
        if (next == this.getTabCount()) {
            this.addTab(content, cmp);
            this.setSelectedIndex(this.getTabCount() - 1);
        } else if (prev > next) {
            this.addTab(content, cmp, next);
            this.setSelectedIndex(next);
        } else {
            this.addTab(content, cmp, next - 1);
            this.setSelectedIndex(next - 1);
        }
    }

    protected void fireCloseTabEvent(Content content) {
        TabbedContentPaneEvent event = new TabbedContentPaneEvent(this, TabbedContentPaneEvent.ActionId.ON_CLOSE, content);
        for (TabbedContentPaneListener tabListener : (TabbedContentPaneListener[])this.getListeners(TabbedContentPaneListener.class)) {
            tabListener.tabbedContentPaneEventFired(event);
        }
    }

    protected void fireDetachTabEvent(Content content) {
        TabbedContentPaneEvent event = new TabbedContentPaneEvent(this, TabbedContentPaneEvent.ActionId.ON_DETACH, content);
        for (TabbedContentPaneListener tabListener : (TabbedContentPaneListener[])this.getListeners(TabbedContentPaneListener.class)) {
            tabListener.tabbedContentPaneEventFired(event);
        }
    }

    protected Content getContentMaximized(Content content) {
        for (Content c : ((ContentManager)content.getDockableManager()).getContents()) {
            if (!c.isMaximized()) continue;
            return c;
        }
        return null;
    }

    public class TabbedDragListenerAdapter
    extends DragListenerAdapter {
        protected Content draggingContent;

        public TabbedDragListenerAdapter(MyDoggyToolWindowManager manager) {
            super(manager);
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            super.dragGestureRecognized(dge);
            if (!this.acquireLocks()) {
                return;
            }
            Point tabPt = dge.getDragOrigin();
            TabbedContentPane.this.dragTabIndex = TabbedContentPane.this.indexAtLocation(tabPt.x, tabPt.y);
            if (TabbedContentPane.this.dragTabIndex < 0) {
                return;
            }
            this.draggingContent = TabbedContentPane.this.getContentAt(TabbedContentPane.this.dragTabIndex);
            dge.startDrag(DragSource.DefaultMoveDrop, new MyDoggyTransferable(this.manager, MyDoggyTransferable.CONTENT_ID_DF, this.draggingContent.getId()), this);
            if (SwingUtil.getBoolean("drag.icon.useDefault", false)) {
                this.setGhostImage(dge.getDragOrigin(), SwingUtil.getImage("mydoggy.image.drag"));
            } else {
                Component c = dge.getComponent();
                Rectangle rect = TabbedContentPane.this.getBoundsAt(TabbedContentPane.this.dragTabIndex);
                BufferedImage image = new BufferedImage(c.getWidth(), c.getHeight(), 2);
                Graphics g = image.getGraphics();
                c.paint(g);
                image = image.getSubimage(rect.x, rect.y, rect.width, rect.height);
                this.setGhostImage(dge.getDragOrigin(), image);
            }
        }

        public void dragMouseMoved(DragSourceDragEvent dsde) {
            if (!this.checkStatus()) {
                return;
            }
            this.updateGhostImage(dsde.getLocation());
            this.updateDropTarget(dsde);
        }

        public void dragEnter(DragSourceDragEvent e) {
        }

        public void dragExit(DragSourceEvent e) {
            TabbedContentPane.this.tabPointerLocation.setLocation(-1, 0);
        }

        public void dragOver(DragSourceDragEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dragDropEnd(DragSourceDropEvent e) {
            try {
                if (!this.checkStatus()) {
                    return;
                }
                this.releaseLocksOne();
                if (!e.getDropSuccess()) {
                    if (this.lastDropPanel != null) {
                        this.lastDropPanel.drop(e.getDragSourceContext().getTransferable());
                    } else if (this.lastBarAnchor == null) {
                        if (SwingUtil.getBoolean("dnd.content.outside.frame", true)) {
                            Content content = TabbedContentPane.this.getContentAt(TabbedContentPane.this.dragTabIndex);
                            ContentUI contentUI = content.getContentUI();
                            Rectangle bounds = contentUI.getDetachedBounds();
                            if (bounds != null) {
                                bounds.setLocation(e.getLocation());
                            } else {
                                bounds = new Rectangle();
                                bounds.setLocation(e.getLocation());
                                bounds.setSize(TabbedContentPane.this.toolWindowManager.getBoundsToScreen(content.getComponent().getBounds(), content.getComponent().getParent()).getSize());
                            }
                            contentUI.setDetachedBounds(bounds);
                            content.setDetached(true);
                        }
                    } else if (this.draggingContent != null && TabbedContentPane.this.dragTabIndex != -1) {
                        TabbedContentPane.this.setIndex(this.draggingContent, TabbedContentPane.this.dragTabIndex);
                    }
                }
                this.releaseLocksTwo();
            }
            finally {
                this.dockableDropDragEnd();
            }
            TabbedContentPane.this.tabPointerLocation.setLocation(-1, 0);
            TabbedContentPane.this.dragTabIndex = -1;
            this.cleanupGhostImage();
        }

        public void dropActionChanged(DragSourceDragEvent e) {
        }

        protected boolean isDragEnabled() {
            return super.isDragEnabled() && SwingUtil.getBoolean("ContentManagerUI.drag.enabled", true);
        }
    }

    public class TabbedDropTargetListener
    implements DropTargetListener {
        public void dragEnter(DropTargetDragEvent e) {
            if (this.isDragAcceptable(e)) {
                e.acceptDrag(e.getDropAction());
            } else {
                e.rejectDrag();
            }
        }

        public void dragExit(DropTargetEvent e) {
        }

        public void dropActionChanged(DropTargetDragEvent e) {
        }

        public void dragOver(DropTargetDragEvent e) {
            Point location = e.getLocation();
            if (TabbedContentPane.this.getTabPlacement() == 1 || TabbedContentPane.this.getTabPlacement() == 3) {
                TabbedContentPane.this.initTargetLeftRightLine(TabbedContentPane.this.indexAtLocation(location.x, location.y));
            } else {
                TabbedContentPane.this.initTargetTopBottomLine(TabbedContentPane.this.indexAtLocation(location.x, location.y));
            }
            TabbedContentPane.this.repaint();
        }

        public void drop(DropTargetDropEvent e) {
            block8: {
                if (this.isDropAcceptable(e)) {
                    try {
                        Content dragContent = TabbedContentPane.this.toolWindowManager.getContentManager().getContent(e.getTransferable().getTransferData(MyDoggyTransferable.CONTENT_ID_DF));
                        Point location = e.getLocation();
                        int targetIndex = TabbedContentPane.this.indexAtLocation(location.x, location.y);
                        if (dragContent.isDetached()) {
                            if (targetIndex >= 0) {
                                dragContent.reattach(targetIndex);
                            } else {
                                dragContent.reattach(-1);
                            }
                            e.dropComplete(true);
                            break block8;
                        }
                        if (targetIndex >= 0) {
                            TabbedContentPane.this.setIndex(TabbedContentPane.this.getContentAt(TabbedContentPane.this.dragTabIndex), targetIndex);
                            e.dropComplete(true);
                            break block8;
                        }
                        e.dropComplete(false);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        e.dropComplete(false);
                    }
                } else {
                    e.dropComplete(false);
                }
            }
            TabbedContentPane.this.repaint();
        }

        public boolean isDragAcceptable(DropTargetDragEvent e) {
            Transferable transferable = e.getTransferable();
            if (transferable == null) {
                return false;
            }
            return transferable.isDataFlavorSupported(MyDoggyTransferable.CONTENT_ID_DF);
        }

        public boolean isDropAcceptable(DropTargetDropEvent e) {
            Transferable transferable = e.getTransferable();
            if (transferable == null) {
                return false;
            }
            return transferable.isDataFlavorSupported(MyDoggyTransferable.CONTENT_ID_DF);
        }
    }

    public class TabbedTransferable
    implements Transferable {
        private final DataFlavor FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "TabbedTransferable");

        public Object getTransferData(DataFlavor flavor) {
            if (this.isDataFlavorSupported(flavor)) {
                return TabbedContentPane.this;
            }
            throw new IllegalArgumentException("Invalid data flavor!!!");
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.FLAVOR};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return TabbedContentPane.TRANSFERABLE_NAME.equals(flavor.getHumanPresentableName());
        }
    }

    public class ExMultipleAggregateIcon
    extends MultipleAggregateIcon {
        protected int index;

        public ExMultipleAggregateIcon(int numIcon, int orientation) {
            super(numIcon, orientation);
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }

    public class MouseOverTabListener
    extends MouseInputAdapter {
        protected int mouseOverTab = -1;
        protected JPopupMenu stdPopupMenu;
        protected boolean selectionOnPressed;
        protected int mouseOverTabWhenPressed;

        public void mousePressed(MouseEvent e) {
            Content oldSelected;
            Content newSelected;
            if (this.mouseOverTab >= 0 && this.mouseOverTab < TabbedContentPane.this.getTabCount()) {
                this.selectionOnPressed = TabbedContentPane.this.aggregateIcon.getIndex() == this.mouseOverTab;
            }
            this.mouseOverTabWhenPressed = this.mouseOverTab;
            if (this.mouseOverTab != -1 && (newSelected = TabbedContentPane.this.getContentAt(this.mouseOverTab)) != null && !newSelected.isMaximized() && newSelected != (oldSelected = TabbedContentPane.this.toolWindowManager.getContentManager().getSelectedContent())) {
                newSelected.setSelected(true);
            }
        }

        public void mouseClicked(MouseEvent e) {
            JPopupMenu popupMenu;
            if (this.mouseOverTab >= 0 && this.mouseOverTab < TabbedContentPane.this.getTabCount()) {
                if (this.mouseOverTab == this.mouseOverTabWhenPressed && !this.selectionOnPressed) {
                    return;
                }
                Content content = TabbedContentPane.this.getContentAt(this.mouseOverTab);
                if (content == null) {
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    ContentUI contentUI = content.getContentUI();
                    if (this.isDetachFired(contentUI, e.getPoint())) {
                        TabbedContentPane.this.fireDetachTabEvent(content);
                        return;
                    }
                    if (this.isCloseFired(contentUI, e.getPoint())) {
                        TabbedContentPane.this.fireCloseTabEvent(content);
                        return;
                    }
                    if (this.isMinimizedFired(contentUI, e.getPoint())) {
                        content.setMinimized(!content.isMinimized());
                        return;
                    }
                    if (e.getClickCount() == 2 && contentUI.isMaximizable() || this.isMaximizeFired(contentUI, e.getPoint())) {
                        Content maximized = TabbedContentPane.this.getContentMaximized(content);
                        if (maximized != null) {
                            maximized.setMaximized(false);
                        } else {
                            content.setMaximized(!content.isMaximized());
                        }
                    }
                } else if (SwingUtilities.isRightMouseButton(e) && TabbedContentPane.this.toolWindowManager.getContentManager().getContentManagerUI().isPopupMenuEnabled()) {
                    this.showPopupMenu(e);
                }
            } else if (SwingUtilities.isRightMouseButton(e) && (popupMenu = TabbedContentPane.this.getComponentPopupMenu()) != null) {
                popupMenu.show(TabbedContentPane.this, e.getX(), e.getY());
            }
        }

        public void mouseExited(MouseEvent e) {
            if (this.mouseOverTab != -1) {
                int tmp = this.mouseOverTab;
                this.mouseOverTab = -1;
                if (tmp < TabbedContentPane.this.getTabCount()) {
                    TabbedContentPane.this.repaint(TabbedContentPane.this.getBoundsAt(tmp));
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
            int tabIndex;
            if (!TabbedContentPane.this.isEnabled()) {
                return;
            }
            if (this.mouseOverTab != -1) {
                int tmp = this.mouseOverTab;
                this.mouseOverTab = -1;
                if (tmp < TabbedContentPane.this.getTabCount()) {
                    TabbedContentPane.this.repaint(TabbedContentPane.this.getBoundsAt(tmp));
                }
            }
            if ((tabIndex = TabbedContentPane.this.indexAtLocation(e.getX(), e.getY())) >= 0 && TabbedContentPane.this.isEnabledAt(tabIndex)) {
                this.mouseOverTab = tabIndex;
                if (tabIndex < TabbedContentPane.this.getTabCount()) {
                    TabbedContentPane.this.repaint(TabbedContentPane.this.getBoundsAt(tabIndex));
                }
            }
            if (this.mouseOverTab == -1) {
                TabbedContentPane.this.currentToolTip = null;
            } else {
                Point point;
                Content content = TabbedContentPane.this.getContentAt(this.mouseOverTab);
                if (content == null) {
                    return;
                }
                ContentUI contentUI = content.getContentUI();
                TabbedContentPane.this.currentToolTip = this.isMinimizedFired(contentUI, point = e.getPoint()) ? SwingUtil.getString("@@tabbed.page.minimize") : (this.isMaximizeFired(contentUI, point) ? SwingUtil.getString("@@tabbed.page.maximize") : (this.isDetachFired(contentUI, point) ? SwingUtil.getString("@@tabbed.page.detach") : (this.isCloseFired(contentUI, point) ? SwingUtil.getString("@@tabbed.page.close") : null)));
            }
        }

        protected boolean isMinimizedFired(ContentUI contentUI, Point point) {
            Point relativeMousePoint = SwingUtilities.convertPoint(TabbedContentPane.this, point, this.getDestination());
            Rectangle iconBounds = TabbedContentPane.this.aggregateIcon.getLastPaintedRecAt(2);
            return iconBounds != null && contentUI.isMinimizable() && TabbedContentPane.this.showMinimize && (relativeMousePoint.getX() > (double)iconBounds.x && relativeMousePoint.getX() < (double)(iconBounds.x + iconBounds.width) || point.getX() > (double)iconBounds.x && point.getX() < (double)(iconBounds.x + iconBounds.width));
        }

        protected boolean isMaximizeFired(ContentUI contentUI, Point point) {
            Point relativeMousePoint = SwingUtilities.convertPoint(TabbedContentPane.this, point, this.getDestination());
            Rectangle iconBounds = TabbedContentPane.this.aggregateIcon.getLastPaintedRecAt(3);
            return iconBounds != null && contentUI.isMaximizable() && TabbedContentPane.this.showMaximize && (relativeMousePoint.getX() > (double)iconBounds.x && relativeMousePoint.getX() < (double)(iconBounds.x + iconBounds.width) || point.getX() > (double)iconBounds.x && point.getX() < (double)(iconBounds.x + iconBounds.width));
        }

        protected boolean isDetachFired(ContentUI contentUI, Point point) {
            Point relativeMousePoint = SwingUtilities.convertPoint(TabbedContentPane.this, point, this.getDestination());
            Rectangle iconBounds = TabbedContentPane.this.aggregateIcon.getLastPaintedRecAt(4);
            return iconBounds != null && contentUI.isDetachable() && TabbedContentPane.this.showDetach && (relativeMousePoint.getX() > (double)iconBounds.x && relativeMousePoint.getX() < (double)(iconBounds.x + iconBounds.width) || point.getX() > (double)iconBounds.x && point.getX() < (double)(iconBounds.x + iconBounds.width));
        }

        protected boolean isCloseFired(ContentUI contentUI, Point point) {
            Point relativeMousePoint = SwingUtilities.convertPoint(TabbedContentPane.this, point, this.getDestination());
            Rectangle iconBounds = TabbedContentPane.this.aggregateIcon.getLastPaintedRecAt(5);
            return iconBounds != null && contentUI.isCloseable() && TabbedContentPane.this.showClose && (relativeMousePoint.getX() > (double)iconBounds.x && relativeMousePoint.getX() < (double)(iconBounds.x + iconBounds.width) || point.getX() > (double)iconBounds.x && point.getX() < (double)(iconBounds.x + iconBounds.width));
        }

        protected Component getDestination() {
            int size = TabbedContentPane.this.getComponentCount();
            for (int i = 0; i < size; ++i) {
                if (!(TabbedContentPane.this.getComponent(i) instanceof JViewport)) continue;
                return ((JViewport)TabbedContentPane.this.getComponent(i)).getView();
            }
            return TabbedContentPane.this;
        }

        protected void showPopupMenu(MouseEvent mouseEvent) {
            final Content contentAt = TabbedContentPane.this.getContentAt(this.mouseOverTab);
            JPopupMenu popupMenu = contentAt.getPopupMenu();
            if (popupMenu == null) {
                popupMenu = TabbedContentPane.this.getComponentPopupMenu();
            }
            if (popupMenu == null) {
                this.stdPopupMenu = new JPopupMenu("Content Page Popup");
                if (contentAt.getContentUI().isCloseable()) {
                    this.stdPopupMenu.add(new JMenuItem(new AbstractAction(SwingUtil.getString("@@tabbed.page.close")){

                        public void actionPerformed(ActionEvent e) {
                            TabbedContentPane.this.fireCloseTabEvent(contentAt);
                        }
                    }));
                }
                this.stdPopupMenu.add(new JMenuItem(new AbstractAction(SwingUtil.getString("@@tabbed.page.closeAll")){

                    public void actionPerformed(ActionEvent e) {
                        for (Content content : TabbedContentPane.this.toolWindowManager.getContentManager().getContents()) {
                            if (!content.getContentUI().isCloseable()) continue;
                            TabbedContentPane.this.fireCloseTabEvent(content);
                        }
                    }
                }));
                this.stdPopupMenu.add(new JMenuItem(new AbstractAction(SwingUtil.getString("@@tabbed.page.closeAllButThis")){

                    public void actionPerformed(ActionEvent e) {
                        for (Content content : TabbedContentPane.this.toolWindowManager.getContentManager().getContents()) {
                            if (content == contentAt || !content.getContentUI().isCloseable()) continue;
                            TabbedContentPane.this.fireCloseTabEvent(content);
                        }
                    }
                }));
                boolean restore = false;
                if (contentAt.getContentUI().isDetachable() && TabbedContentPane.this.showDetach) {
                    this.stdPopupMenu.addSeparator();
                    this.stdPopupMenu.add(new JMenuItem(new AbstractAction(SwingUtil.getString("@@tabbed.page.detach")){

                        public void actionPerformed(ActionEvent e) {
                            TabbedContentPane.this.fireDetachTabEvent(contentAt);
                        }
                    }));
                }
                if (contentAt.getContentUI().isMaximizable() && TabbedContentPane.this.showMaximize) {
                    MaximizeAction maximizeAction = new MaximizeAction(contentAt);
                    restore = contentAt.isMaximized() || this.isAContentMaximized();
                    maximizeAction.putValue("Name", restore ? SwingUtil.getString("@@tabbed.page.restore") : SwingUtil.getString("@@tabbed.page.maximize"));
                    this.stdPopupMenu.add(maximizeAction);
                }
                if (!restore && contentAt.getContentUI().isMinimizable() && TabbedContentPane.this.showMinimize) {
                    this.stdPopupMenu.add(new MinimizeAction(contentAt));
                }
                popupMenu = this.stdPopupMenu;
            }
            if (popupMenu != null) {
                popupMenu.show(TabbedContentPane.this, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        protected boolean isAContentMaximized() {
            for (Content content : TabbedContentPane.this.toolWindowManager.getContentManager().getContents()) {
                if (!content.isMaximized()) continue;
                return true;
            }
            return false;
        }

        class MinimizeAction
        extends AbstractAction {
            Content content;

            public MinimizeAction(Content content) {
                super(SwingUtil.getString("@@tabbed.page.minimize"));
                this.content = content;
            }

            public void actionPerformed(ActionEvent e) {
                this.content.setMinimized(!this.content.isMaximized());
            }
        }

        class MaximizeAction
        extends AbstractAction {
            Content content;

            public MaximizeAction(Content content) {
                super(SwingUtil.getString("@@tabbed.page.maximize"));
                this.content = content;
            }

            public void actionPerformed(ActionEvent e) {
                this.content.setMaximized(!this.content.isMaximized());
            }
        }
    }
}

