/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.descriptors;

import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import org.noos.xing.mydoggy.FloatingLiveTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.ToolWindowTypeDescriptor;
import org.noos.xing.mydoggy.plaf.descriptors.DefaultToolWindowTypeDescriptor;
import org.noos.xing.mydoggy.plaf.descriptors.InternalTypeDescriptor;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;

public class DefaultFloatingLiveTypeDescriptor
extends DefaultToolWindowTypeDescriptor
implements FloatingLiveTypeDescriptor,
InternalTypeDescriptor {
    private Point location;
    private Dimension size;
    private boolean transparentMode;
    private float transparentRatio;
    private int transparentDelay;
    private boolean resizable;

    public DefaultFloatingLiveTypeDescriptor() {
        this.transparentMode = true;
        this.transparentRatio = 0.5f;
        this.transparentDelay = 1000;
        this.autoHide = false;
        this.resizable = true;
    }

    public DefaultFloatingLiveTypeDescriptor(ToolWindowDescriptor toolWindowDescriptor, DefaultFloatingLiveTypeDescriptor parent, Point location, Dimension size, int transparentDelay, float transparentRatio, boolean useTransparentMode, boolean enabled, boolean animating, boolean autoHide, boolean idVisibleOnTitleBar, boolean hideRepresentativeButtonOnVisible, boolean titleBarButtonsVisible, boolean titleBarVisible, boolean resizable) {
        super(toolWindowDescriptor, parent, enabled, animating, autoHide, idVisibleOnTitleBar, hideRepresentativeButtonOnVisible, titleBarButtonsVisible, titleBarVisible);
        this.location = location;
        this.size = size;
        this.transparentDelay = transparentDelay;
        this.transparentRatio = transparentRatio;
        this.transparentMode = useTransparentMode;
        this.resizable = resizable;
    }

    public ToolWindowType getType() {
        return ToolWindowType.FLOATING_LIVE;
    }

    public void setLocation(int x, int y) {
        Point newLocation = new Point(x, y);
        if (this.location != null && this.location.equals(newLocation)) {
            return;
        }
        Point old = this.location;
        this.location = newLocation;
        this.firePropertyChangeEvent("location", old, this.location);
    }

    public Point getLocation() {
        return this.location;
    }

    public void setSize(int width, int height) {
        Dimension newSize = new Dimension(width, height);
        if (this.size != null && this.size.equals(newSize)) {
            return;
        }
        Dimension old = this.size;
        this.size = newSize;
        this.firePropertyChangeEvent("size", old, this.size);
    }

    public Dimension getSize() {
        return this.size;
    }

    public float getTransparentRatio() {
        return this.transparentRatio;
    }

    public void setTransparentRatio(float transparentRatio) {
        if (this.transparentRatio == transparentRatio) {
            return;
        }
        if (transparentRatio < 0.0f || transparentRatio > 1.0f) {
            throw new IllegalArgumentException("Invalid transparent ratio. Valid range is [0.0f, 1.0f]. [transparentRatio : " + transparentRatio + "]");
        }
        float old = this.transparentRatio;
        this.transparentRatio = transparentRatio;
        this.firePropertyChangeEvent("transparentRatio", Float.valueOf(old), Float.valueOf(transparentRatio));
    }

    public boolean isTransparentMode() {
        return this.transparentMode;
    }

    public void setTransparentMode(boolean transparentMode) {
        if (this.transparentMode == transparentMode) {
            return;
        }
        boolean old = this.transparentMode;
        this.transparentMode = transparentMode;
        this.firePropertyChangeEvent("transparentMode", old, transparentMode);
    }

    public int getTransparentDelay() {
        return this.transparentDelay;
    }

    public void setTransparentDelay(int transparentDelay) {
        if (this.transparentDelay == transparentDelay) {
            return;
        }
        int old = this.transparentDelay;
        this.transparentDelay = transparentDelay;
        this.firePropertyChangeEvent("transparentDelay", old, transparentDelay);
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        if (this.resizable == resizable) {
            return;
        }
        boolean old = this.resizable;
        this.resizable = resizable;
        this.firePropertyChangeEvent("resizable", old, resizable);
    }

    public ToolWindowTypeDescriptor cloneMe(ToolWindowDescriptor toolWindowDescriptor) {
        return new DefaultFloatingLiveTypeDescriptor(toolWindowDescriptor, this, this.location, this.size, this.transparentDelay, this.transparentRatio, this.transparentMode, this.enabled, this.animating, this.autoHide, this.idVisibleOnTitleBar, this.hideRepresentativeButtonOnVisible, this.titleBarButtonsVisible, this.titleBarVisible, this.resizable);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if ("location".equals(evt.getPropertyName())) {
            Point p = (Point)evt.getNewValue();
            this.setLocation(p.x, p.y);
        } else if ("size".equals(evt.getPropertyName())) {
            Dimension d = (Dimension)evt.getNewValue();
            this.setSize(d.width, d.height);
        } else if ("transparentMode".equals(evt.getPropertyName())) {
            this.setTransparentMode((Boolean)evt.getNewValue());
        } else if ("transparentRatio".equals(evt.getPropertyName())) {
            this.setTransparentRatio(((Float)evt.getNewValue()).floatValue());
        } else if ("transparentDelay".equals(evt.getPropertyName())) {
            this.setTransparentDelay((Integer)evt.getNewValue());
        } else if ("resizable".equals(evt.getPropertyName())) {
            this.setResizable((Boolean)evt.getNewValue());
        }
    }
}

