/*
 * Decompiled with CFR 0.152.
 */
package jtermios.windows;

import com.sun.jna.Memory;
import com.sun.jna.WString;
import com.sun.jna.ptr.IntByReference;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import jtermios.FDSet;
import jtermios.JTermios;
import jtermios.Pollfd;
import jtermios.Termios;
import jtermios.TimeVal;
import jtermios.windows.WinAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTermiosImpl
implements JTermios.JTermiosInterface {
    private volatile int m_ErrNo = 0;
    private volatile boolean[] m_PortFDs = new boolean[256];
    private volatile Hashtable<Integer, Port> m_OpenPorts = new Hashtable();

    public JTermiosImpl() {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "instantiating %s\n", this.getClass().getCanonicalName());
    }

    @Override
    public int errno() {
        return this.m_ErrNo;
    }

    @Override
    public void cfmakeraw(Termios termios2) {
        termios2.c_iflag &= ~(JTermios.IGNBRK | JTermios.BRKINT | JTermios.PARMRK | JTermios.ISTRIP | JTermios.INLCR | JTermios.IGNCR | JTermios.ICRNL | JTermios.IXON);
        termios2.c_oflag &= ~JTermios.OPOST;
        termios2.c_lflag &= ~(JTermios.ECHO | JTermios.ECHONL | JTermios.ICANON | JTermios.ISIG | JTermios.IEXTEN);
        termios2.c_cflag &= ~(JTermios.CSIZE | JTermios.PARENB);
        termios2.c_cflag |= JTermios.CS8;
    }

    @Override
    public int fcntl(int fd, int cmd, int arg) {
        Port port = this.getPort(fd);
        if (port == null) {
            return -1;
        }
        if (JTermios.F_SETFL != cmd) {
            if (JTermios.F_GETFL == cmd) {
                return port.m_OpenFlags;
            }
            this.m_ErrNo = JTermios.ENOTSUP;
            return -1;
        }
        port.m_OpenFlags = arg;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int tcdrain(int fd) {
        Port port = this.getPort(fd);
        if (port == null) {
            return -1;
        }
        Memory memory = port.m_WrBuffer;
        synchronized (memory) {
            try {
                if (!WinAPI.FlushFileBuffers(port.m_Comm)) {
                    port.fail();
                }
                return 0;
            }
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Fail f) {
                    return -1;
                }
            }
        }
    }

    @Override
    public int cfgetispeed(Termios termios2) {
        return termios2.c_ispeed;
    }

    @Override
    public int cfgetospeed(Termios termios2) {
        return termios2.c_ospeed;
    }

    @Override
    public int cfsetispeed(Termios termios2, int speed) {
        termios2.c_ispeed = speed;
        return 0;
    }

    @Override
    public int cfsetospeed(Termios termios2, int speed) {
        termios2.c_ospeed = speed;
        return 0;
    }

    @Override
    public int open(String filename, int flags) {
        Port port = new Port();
        port.m_OpenFlags = flags;
        try {
            if (!filename.startsWith("\\\\")) {
                filename = "\\\\.\\" + filename;
            }
            port.m_Comm = WinAPI.CreateFileW(new WString(filename), -1073741824, 0, null, 3, 0x40000000, null);
            if (WinAPI.INVALID_HANDLE_VALUE == port.m_Comm) {
                this.m_ErrNo = WinAPI.GetLastError() == 2 ? JTermios.ENOENT : JTermios.EBUSY;
                port.fail();
            }
            if (!WinAPI.SetupComm(port.m_Comm, (int)port.m_RdBuffer.size(), (int)port.m_WrBuffer.size())) {
                port.fail();
            }
            this.cfmakeraw(port.m_Termios);
            this.cfsetispeed(port.m_Termios, JTermios.B9600);
            this.cfsetospeed(port.m_Termios, JTermios.B9600);
            port.m_Termios.c_cc[JTermios.VTIME] = 0;
            port.m_Termios.c_cc[JTermios.VMIN] = 0;
            this.updateFromTermios(port);
            port.m_RdOVL.writeField("hEvent", WinAPI.CreateEventA(null, true, false, null));
            if (port.m_RdOVL.hEvent == WinAPI.INVALID_HANDLE_VALUE) {
                port.fail();
            }
            port.m_WrOVL.writeField("hEvent", WinAPI.CreateEventA(null, true, false, null));
            if (port.m_WrOVL.hEvent == WinAPI.INVALID_HANDLE_VALUE) {
                port.fail();
            }
            port.m_SelOVL.writeField("hEvent", WinAPI.CreateEventA(null, true, false, null));
            if (port.m_SelOVL.hEvent == WinAPI.INVALID_HANDLE_VALUE) {
                port.fail();
            }
            return port.m_FD;
        }
        catch (Exception f) {
            if (port != null) {
                port.close();
            }
            return -1;
        }
    }

    private static void nanoSleep(long nsec) throws Fail {
        try {
            Thread.sleep((int)(nsec / 1000000L), (int)(nsec % 1000000L));
        }
        catch (InterruptedException ie) {
            throw new Fail();
        }
    }

    private int getCharBits(Termios tios) {
        int cs = 8;
        if ((tios.c_cflag & JTermios.CSIZE) == JTermios.CS5) {
            cs = 5;
        }
        if ((tios.c_cflag & JTermios.CSIZE) == JTermios.CS6) {
            cs = 6;
        }
        if ((tios.c_cflag & JTermios.CSIZE) == JTermios.CS7) {
            cs = 7;
        }
        if ((tios.c_cflag & JTermios.CSIZE) == JTermios.CS8) {
            cs = 8;
        }
        if ((tios.c_cflag & JTermios.CSTOPB) != 0) {
            ++cs;
        }
        if ((tios.c_cflag & JTermios.PARENB) != 0) {
            ++cs;
        }
        return cs += 2;
    }

    private static int min(int a, int b) {
        return a < b ? a : b;
    }

    private static int max(int a, int b) {
        return a > b ? a : b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(int fd, byte[] buffer, int length) {
        Port port = this.getPort(fd);
        if (port == null) {
            return -1;
        }
        Memory memory = port.m_RdBuffer;
        synchronized (memory) {
            try {
                if ((long)length > port.m_RdBuffer.size()) {
                    length = (int)port.m_RdBuffer.size();
                }
                if (length == 0) {
                    return 0;
                }
                if ((port.m_OpenFlags & JTermios.O_NONBLOCK) != 0) {
                    int available;
                    if (!WinAPI.ClearCommError(port.m_Comm, port.m_RdErr, port.m_RdStat)) {
                        port.fail();
                    }
                    if ((available = port.m_RdStat.cbInQue) == 0) {
                        this.m_ErrNo = JTermios.EAGAIN;
                        return -1;
                    }
                    length = JTermiosImpl.min(length, available);
                } else {
                    byte vtime = port.m_Termios.c_cc[JTermios.VTIME];
                    byte vmin = port.m_Termios.c_cc[JTermios.VMIN];
                    if (!WinAPI.ClearCommError(port.m_Comm, port.m_RdErr, port.m_RdStat)) {
                        port.fail();
                    }
                    int available = port.m_RdStat.cbInQue;
                    if (vmin == 0 && vtime == 0) {
                        if (available == 0) {
                            return 0;
                        }
                        length = JTermiosImpl.min(length, available);
                    }
                    if (vmin > 0) {
                        length = JTermiosImpl.min(JTermiosImpl.max(vmin, available), length);
                    }
                }
                if (!WinAPI.ResetEvent(port.m_RdOVL.hEvent)) {
                    port.fail();
                }
                if (!WinAPI.ReadFile(port.m_Comm, port.m_RdBuffer, length, port.m_RdN, port.m_RdOVL)) {
                    if (WinAPI.GetLastError() != 997) {
                        port.fail();
                    }
                    if (WinAPI.WaitForSingleObject(port.m_RdOVL.hEvent, -1) != 0) {
                        port.fail();
                    }
                    if (!WinAPI.GetOverlappedResult(port.m_Comm, port.m_RdOVL, port.m_RdN, true)) {
                        port.fail();
                    }
                }
                port.m_RdBuffer.read(0L, buffer, 0, port.m_RdN[0]);
                return port.m_RdN[0];
            }
            catch (Fail ie) {
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(int fd, byte[] buffer, int length) {
        Port port = this.getPort(fd);
        if (port == null) {
            return -1;
        }
        Memory memory = port.m_WrBuffer;
        synchronized (memory) {
            try {
                if ((port.m_OpenFlags & JTermios.O_NONBLOCK) != 0) {
                    int room;
                    if (!WinAPI.ClearCommError(port.m_Comm, port.m_WrErr, port.m_WrStat)) {
                        port.fail();
                    }
                    if (length > (room = (int)port.m_WrBuffer.size() - port.m_WrStat.cbOutQue)) {
                        length = room;
                    }
                }
                if (!WinAPI.ResetEvent(port.m_WrOVL.hEvent)) {
                    port.fail();
                }
                port.m_WrBuffer.write(0L, buffer, 0, length);
                boolean ok = WinAPI.WriteFile(port.m_Comm, port.m_WrBuffer, length, port.m_WrN, port.m_WrOVL);
                if (!ok) {
                    int res;
                    if (WinAPI.GetLastError() != 997) {
                        port.fail();
                    }
                    while ((res = WinAPI.WaitForSingleObject(port.m_WrOVL.hEvent, -1)) == 258) {
                        this.clearCommErrors(port);
                        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "write pending, cbInQue %d cbOutQue %d\n", port.m_ClearStat.cbInQue, port.m_ClearStat.cbOutQue);
                    }
                    if (!WinAPI.GetOverlappedResult(port.m_Comm, port.m_WrOVL, port.m_WrN, false)) {
                        port.fail();
                    }
                }
                return port.m_WrN[0];
            }
            catch (Fail f) {
                return -1;
            }
        }
    }

    @Override
    public int close(int fd) {
        Port port = this.getPort(fd);
        if (port == null) {
            return -1;
        }
        port.close();
        return 0;
    }

    @Override
    public int tcflush(int fd, int queue) {
        Port port = this.getPort(fd);
        if (port == null) {
            return -1;
        }
        try {
            if (queue == JTermios.TCIFLUSH) {
                if (!WinAPI.PurgeComm(port.m_Comm, 2)) {
                    port.fail();
                }
            } else if (queue == JTermios.TCOFLUSH) {
                if (!WinAPI.PurgeComm(port.m_Comm, 1)) {
                    port.fail();
                }
            } else if (queue == JTermios.TCIOFLUSH) {
                if (!WinAPI.PurgeComm(port.m_Comm, 1)) {
                    port.fail();
                }
                if (!WinAPI.PurgeComm(port.m_Comm, 2)) {
                    port.fail();
                }
            } else {
                this.m_ErrNo = JTermios.ENOTSUP;
                return -1;
            }
            return 0;
        }
        catch (Fail f) {
            return -1;
        }
    }

    @Override
    public int tcgetattr(int fd, Termios termios2) {
        Port port = this.getPort(fd);
        if (port == null) {
            return -1;
        }
        termios2.set(port.m_Termios);
        return 0;
    }

    @Override
    public int tcsendbreak(int fd, int duration) {
        Port port = this.getPort(fd);
        if (port == null) {
            return -1;
        }
        try {
            if (!WinAPI.SetCommBreak(port.m_Comm)) {
                port.fail();
            }
            JTermiosImpl.nanoSleep(duration * 250000000);
            if (!WinAPI.ClearCommBreak(port.m_Comm)) {
                port.fail();
            }
            return 0;
        }
        catch (Fail f) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int tcsetattr(int fd, int cmd, Termios termios2) {
        Port port;
        if (cmd != JTermios.TCSANOW) {
            JTermios.JTermiosLogging.log(0, "tcsetattr only supports TCSANOW", new Object[0]);
        }
        if ((port = this.getPort(fd)) == null) {
            return -1;
        }
        Termios termios3 = port.m_Termios;
        synchronized (termios3) {
            try {
                port.m_Termios.set(termios2);
                this.updateFromTermios(port);
                return 0;
            }
            catch (Fail f) {
                return -1;
            }
        }
    }

    public int updateFromTermios(Port port) throws Fail {
        Termios tios = port.m_Termios;
        WinAPI.DCB dcb = port.m_DCB;
        dcb.DCBlength = dcb.size();
        dcb.BaudRate = tios.c_ospeed;
        if (tios.c_ospeed != tios.c_ispeed) {
            JTermios.JTermiosLogging.log(0, "c_ospeed (%d) != c_ispeed (%d)\n", tios.c_ospeed, tios.c_ispeed);
        }
        int c_cflag = tios.c_cflag;
        int c_iflag = tios.c_iflag;
        int c_oflag = tios.c_oflag;
        int flags = 0;
        flags |= 1;
        if ((c_cflag & JTermios.PARENB) != 0) {
            flags |= 2;
        }
        if ((c_iflag & JTermios.IXON) != 0) {
            flags |= 0x100;
        }
        if ((c_iflag & JTermios.IXOFF) != 0) {
            flags |= 0x200;
        }
        if ((c_iflag & JTermios.IXANY) != 0) {
            flags |= 0x80;
        }
        if ((c_iflag & JTermios.CRTSCTS) != 0) {
            flags |= 0x3000;
            flags |= 4;
        }
        dcb.fFlags = flags;
        dcb.XonLim = (short)128;
        dcb.XoffLim = (short)128;
        int cs = 8;
        int csize = c_cflag & JTermios.CSIZE;
        if (csize == JTermios.CS5) {
            cs = 5;
        }
        if (csize == JTermios.CS6) {
            cs = 6;
        }
        if (csize == JTermios.CS7) {
            cs = 7;
        }
        if (csize == JTermios.CS8) {
            cs = 8;
        }
        dcb.ByteSize = (byte)cs;
        dcb.Parity = (c_cflag & JTermios.PARENB) != 0 ? ((c_cflag & JTermios.PARODD) != 0 && (c_cflag & JTermios.CMSPAR) != 0 ? (byte)3 : ((c_cflag & JTermios.PARODD) != 0 ? (byte)1 : ((c_cflag & JTermios.CMSPAR) != 0 ? (byte)4 : (byte)2))) : (byte)0;
        dcb.StopBits = (byte)((tios.c_cflag & JTermios.CSTOPB) != 0 ? 2 : 0);
        dcb.XonChar = tios.c_cc[JTermios.VSTART];
        dcb.XoffChar = tios.c_cc[JTermios.VSTOP];
        dcb.ErrorChar = 0;
        dcb.EvtChar = (byte)10;
        dcb.EofChar = tios.c_cc[JTermios.VEOF];
        int vmin = port.m_Termios.c_cc[JTermios.VMIN] & 0xFF;
        int vtime = (port.m_Termios.c_cc[JTermios.VTIME] & 0xFF) * 100;
        WinAPI.COMMTIMEOUTS touts = port.m_Timeouts;
        touts.WriteTotalTimeoutConstant = 0;
        touts.WriteTotalTimeoutMultiplier = 0;
        if (vmin == 0 && vtime == 0) {
            touts.ReadIntervalTimeout = -1;
            touts.ReadTotalTimeoutConstant = 0;
            touts.ReadTotalTimeoutMultiplier = 0;
        }
        if (vmin == 0 && vtime > 0) {
            touts.ReadIntervalTimeout = -1;
            touts.ReadTotalTimeoutConstant = vtime;
            touts.ReadTotalTimeoutMultiplier = -1;
        }
        if (vmin > 0 && vtime > 0) {
            touts.ReadIntervalTimeout = vtime;
            touts.ReadTotalTimeoutConstant = 0;
            touts.ReadTotalTimeoutMultiplier = 0;
        }
        if (vmin > 0 && vtime == 0) {
            touts.ReadIntervalTimeout = 0;
            touts.ReadTotalTimeoutConstant = 0;
            touts.ReadTotalTimeoutMultiplier = 0;
        }
        if (!WinAPI.SetCommState(port.m_Comm, dcb)) {
            port.fail();
        }
        if (!WinAPI.SetCommTimeouts(port.m_Comm, port.m_Timeouts)) {
            port.fail();
        }
        return 0;
    }

    private void maskToFDSets(Port port, FDSet readfds, FDSet writefds, FDSet exceptfds) {
        int emask = port.m_EvenFlags.getValue();
        int fd = port.m_FD;
        if ((emask & 1) != 0) {
            this.FD_SET(fd, readfds);
        }
        if ((emask & 4) != 0) {
            this.FD_SET(fd, writefds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCommErrors(Port port) throws Fail {
        int[] nArray = port.m_ClearErr;
        synchronized (port.m_ClearErr) {
            if (!WinAPI.ClearCommError(port.m_Comm, port.m_ClearErr, port.m_ClearStat)) {
                port.fail();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public int select(int n, FDSet readfds, FDSet writefds, FDSet exceptfds, TimeVal timeout) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int poll(Pollfd[] fds, int nfds, int timeout) {
        return 0;
    }

    @Override
    public void perror(String msg) {
        if (msg != null && msg.length() > 0) {
            System.out.print(String.valueOf(msg) + ": ");
        }
        System.out.printf("%d\n", this.m_ErrNo);
    }

    private static int baudToDCB(int baud) {
        switch (baud) {
            case 110: {
                return 110;
            }
            case 300: {
                return 300;
            }
            case 600: {
                return 600;
            }
            case 1200: {
                return 1200;
            }
            case 2400: {
                return 2400;
            }
            case 4800: {
                return 4800;
            }
            case 9600: {
                return 9600;
            }
            case 14400: {
                return 14400;
            }
            case 19200: {
                return 19200;
            }
            case 38400: {
                return 38400;
            }
            case 57600: {
                return 57600;
            }
            case 115200: {
                return 115200;
            }
            case 128000: {
                return 128000;
            }
            case 256000: {
                return 256000;
            }
        }
        return baud;
    }

    @Override
    public FDSet newFDSet() {
        return new FDSetImpl();
    }

    @Override
    public void FD_CLR(int fd, FDSet set) {
        if (set == null) {
            return;
        }
        FDSetImpl p = (FDSetImpl)set;
        int n = fd / 32;
        p.bits[n] = p.bits[n] & ~(1 << fd % 32);
    }

    @Override
    public boolean FD_ISSET(int fd, FDSet set) {
        if (set == null) {
            return false;
        }
        FDSetImpl p = (FDSetImpl)set;
        return (p.bits[fd / 32] & 1 << fd % 32) != 0;
    }

    @Override
    public void FD_SET(int fd, FDSet set) {
        if (set == null) {
            return;
        }
        FDSetImpl p = (FDSetImpl)set;
        int n = fd / 32;
        p.bits[n] = p.bits[n] | 1 << fd % 32;
    }

    @Override
    public void FD_ZERO(FDSet set) {
        if (set == null) {
            return;
        }
        FDSetImpl p = (FDSetImpl)set;
        Arrays.fill(p.bits, 0);
    }

    @Override
    public int ioctl(int fd, int cmd, int[] arg) {
        block11: {
            Port port;
            block10: {
                block9: {
                    port = this.getPort(fd);
                    if (port == null) {
                        return -1;
                    }
                    try {
                        if (cmd != JTermios.FIONREAD) break block9;
                        this.clearCommErrors(port);
                        arg[0] = port.m_ClearStat.cbInQue;
                        return 0;
                    }
                    catch (Fail f) {
                        return -1;
                    }
                }
                if (cmd != JTermios.TIOCMSET) break block10;
                int a = arg[0];
                port.MSR = (a & JTermios.TIOCM_DTR) != 0 ? (port.MSR |= JTermios.TIOCM_DTR) : (port.MSR &= ~JTermios.TIOCM_DTR);
                if (!WinAPI.EscapeCommFunction(port.m_Comm, (a & JTermios.TIOCM_DTR) != 0 ? 5 : 6)) {
                    port.fail();
                }
                port.MSR = (a & JTermios.TIOCM_RTS) != 0 ? (port.MSR |= JTermios.TIOCM_RTS) : (port.MSR &= ~JTermios.TIOCM_RTS);
                if (!WinAPI.EscapeCommFunction(port.m_Comm, (a & JTermios.TIOCM_RTS) != 0 ? 3 : 4)) {
                    port.fail();
                }
                return 0;
            }
            if (cmd != JTermios.TIOCMGET) break block11;
            int[] stat = new int[1];
            if (!WinAPI.GetCommModemStatus(port.m_Comm, stat)) {
                port.fail();
            }
            int s = stat[0];
            int a = arg[0];
            a = (s & 0x80) != 0 ? (a |= JTermios.TIOCM_CAR) : (a &= ~JTermios.TIOCM_CAR);
            a = (s & 0x40) != 0 ? (a |= JTermios.TIOCM_RNG) : (a &= ~JTermios.TIOCM_RNG);
            a = (s & 0x20) != 0 ? (a |= JTermios.TIOCM_DSR) : (a &= ~JTermios.TIOCM_DSR);
            a = (s & 0x10) != 0 ? (a |= JTermios.TIOCM_CTS) : (a &= ~JTermios.TIOCM_CTS);
            a = (port.MSR & JTermios.TIOCM_DTR) != 0 ? (a |= JTermios.TIOCM_DTR) : (a &= ~JTermios.TIOCM_DTR);
            a = (port.MSR & JTermios.TIOCM_RTS) != 0 ? (a |= JTermios.TIOCM_RTS) : (a &= ~JTermios.TIOCM_RTS);
            arg[0] = a;
            return 0;
        }
        this.m_ErrNo = JTermios.ENOTSUP;
        return -1;
    }

    private void set_errno(int x) {
        this.m_ErrNo = x;
    }

    private void report(String msg) {
        System.err.print(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Port getPort(int fd) {
        JTermiosImpl jTermiosImpl = this;
        synchronized (jTermiosImpl) {
            Port port = this.m_OpenPorts.get(fd);
            if (port == null) {
                this.m_ErrNo = JTermios.EBADF;
            }
            return port;
        }
    }

    private static String getString(char[] buffer, int offset) {
        char c;
        StringBuffer s = new StringBuffer();
        while ((c = buffer[offset++]) != '\u0000') {
            s.append(c);
        }
        return s.toString();
    }

    @Override
    public String getPortNamePattern() {
        return "^COM.*";
    }

    @Override
    public List<String> getPortList() {
        Pattern p = JTermios.getPortNamePattern(this);
        int size = 0;
        size = 16384;
        while (size < 262144) {
            char[] buffer = new char[size];
            int res = WinAPI.QueryDosDeviceW(null, buffer, buffer.length);
            if (res > 0) {
                String port;
                LinkedList<String> list = new LinkedList<String>();
                int offset = 0;
                while ((port = JTermiosImpl.getString(buffer, offset)).length() > 0) {
                    if (p.matcher(port).matches()) {
                        list.add(port);
                    }
                    offset += port.length() + 1;
                }
                return list;
            }
            int err = WinAPI.GetLastError();
            if (err != 122) {
                JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "QueryDosDeviceW() failed with GetLastError() ", err);
                return null;
            }
            size *= 2;
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "Repeated QueryDosDeviceW() calls failed up to buffer size %d\n", size);
        return null;
    }

    @Override
    public void shutDown() {
        for (Port port : this.m_OpenPorts.values()) {
            try {
                JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "shutDown() closing port %d\n", port.m_FD);
                port.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int setspeed(int fd, Termios termios2, int speed) {
        int br = speed;
        switch (speed) {
            case 50: {
                br = JTermios.B50;
                break;
            }
            case 75: {
                br = JTermios.B75;
                break;
            }
            case 110: {
                br = JTermios.B110;
                break;
            }
            case 134: {
                br = JTermios.B134;
                break;
            }
            case 150: {
                br = JTermios.B150;
                break;
            }
            case 200: {
                br = JTermios.B200;
                break;
            }
            case 300: {
                br = JTermios.B300;
                break;
            }
            case 600: {
                br = JTermios.B600;
                break;
            }
            case 1200: {
                br = JTermios.B1200;
                break;
            }
            case 1800: {
                br = JTermios.B1800;
                break;
            }
            case 2400: {
                br = JTermios.B2400;
                break;
            }
            case 4800: {
                br = JTermios.B4800;
                break;
            }
            case 9600: {
                br = JTermios.B9600;
                break;
            }
            case 19200: {
                br = JTermios.B19200;
                break;
            }
            case 38400: {
                br = JTermios.B38400;
                break;
            }
            case 7200: {
                br = JTermios.B7200;
                break;
            }
            case 14400: {
                br = JTermios.B14400;
                break;
            }
            case 28800: {
                br = JTermios.B28800;
                break;
            }
            case 57600: {
                br = JTermios.B57600;
                break;
            }
            case 76800: {
                br = JTermios.B76800;
                break;
            }
            case 115200: {
                br = JTermios.B115200;
                break;
            }
            case 230400: {
                br = JTermios.B230400;
            }
        }
        int r = this.cfsetispeed(termios2, br);
        if (r != 0) {
            return r;
        }
        r = this.cfsetospeed(termios2, br);
        if (r != 0) {
            return r;
        }
        r = this.tcsetattr(fd, JTermios.TCSANOW, termios2);
        if (r != 0) {
            return r;
        }
        return 0;
    }

    private static class FDSetImpl
    extends FDSet {
        static final int FD_SET_SIZE = 256;
        static final int NFBBITS = 32;
        int[] bits = new int[8];

        private FDSetImpl() {
        }
    }

    static class Fail
    extends Exception {
        Fail() {
        }
    }

    private class Port {
        volatile int m_FD = -1;
        volatile boolean m_Locked;
        volatile WinAPI.HANDLE m_Comm;
        volatile int m_OpenFlags;
        volatile WinAPI.DCB m_DCB = new WinAPI.DCB();
        volatile WinAPI.COMMTIMEOUTS m_Timeouts = new WinAPI.COMMTIMEOUTS();
        volatile WinAPI.COMSTAT m_ClearStat = new WinAPI.COMSTAT();
        volatile int[] m_ClearErr = new int[1];
        volatile Memory m_RdBuffer = new Memory(2048L);
        volatile WinAPI.COMSTAT m_RdStat = new WinAPI.COMSTAT();
        volatile int[] m_RdErr = new int[1];
        volatile int[] m_RdN = new int[1];
        volatile WinAPI.OVERLAPPED m_RdOVL = new WinAPI.OVERLAPPED();
        volatile Memory m_WrBuffer = new Memory(2048L);
        volatile WinAPI.COMSTAT m_WrStat = new WinAPI.COMSTAT();
        volatile int[] m_WrErr = new int[1];
        volatile int[] m_WrN = new int[1];
        volatile WinAPI.OVERLAPPED m_WrOVL = new WinAPI.OVERLAPPED();
        volatile int[] m_SelN = new int[1];
        volatile WinAPI.OVERLAPPED m_SelOVL = new WinAPI.OVERLAPPED();
        volatile IntByReference m_EvenFlags = new IntByReference();
        volatile Termios m_Termios = new Termios();
        volatile int MSR;

        public synchronized void fail() throws Fail {
            int err = WinAPI.GetLastError();
            Memory buffer = new Memory(2048L);
            int res = WinAPI.FormatMessageW(4608, null, err, WinAPI.MAKELANGID(0, 1), buffer, (int)buffer.size(), null);
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "fail() %s, Windows GetLastError()= %d, %s\n", JTermios.JTermiosLogging.lineno(1), err, buffer.getString(0L, true));
            Fail f = new Fail();
            throw f;
        }

        public synchronized void lock() throws InterruptedException {
            if (this.m_Locked) {
                this.wait();
            }
            this.m_Locked = true;
        }

        public synchronized void unlock() {
            if (!this.m_Locked) {
                throw new IllegalArgumentException("Port was not locked");
            }
            this.m_Locked = false;
            this.notifyAll();
        }

        public synchronized void waitUnlock() {
            while (this.m_Locked) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public Port() {
            JTermiosImpl jTermiosImpl2 = JTermiosImpl.this;
            synchronized (jTermiosImpl2) {
                this.m_FD = -1;
                int i = 0;
                while (i < JTermiosImpl.this.m_PortFDs.length) {
                    if (!JTermiosImpl.this.m_PortFDs[i]) {
                        this.m_FD = i;
                        ((JTermiosImpl)JTermiosImpl.this).m_PortFDs[i] = true;
                        JTermiosImpl.this.m_OpenPorts.put(this.m_FD, this);
                        return;
                    }
                    ++i;
                }
                throw new RuntimeException("Too many ports open");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            JTermiosImpl jTermiosImpl = JTermiosImpl.this;
            synchronized (jTermiosImpl) {
                WinAPI.HANDLE h;
                if (this.m_FD >= 0) {
                    JTermiosImpl.this.m_OpenPorts.remove(this.m_FD);
                    ((JTermiosImpl)JTermiosImpl.this).m_PortFDs[this.m_FD] = false;
                    this.m_FD = -1;
                }
                if (this.m_Comm != null && !WinAPI.PurgeComm(this.m_Comm, 15)) {
                    JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "PurgeComm() failed, GetLastError()= %d, %s\n", WinAPI.GetLastError(), JTermios.JTermiosLogging.lineno(1));
                }
                Memory memory = this.m_RdBuffer;
                synchronized (memory) {
                    h = (WinAPI.HANDLE)this.m_RdOVL.readField("hEvent");
                    this.m_RdOVL = null;
                    if (h != null && !h.equals(WinAPI.NULL) && !h.equals(WinAPI.INVALID_HANDLE_VALUE)) {
                        WinAPI.CloseHandle(h);
                    }
                }
                memory = this.m_WrBuffer;
                synchronized (memory) {
                    h = (WinAPI.HANDLE)this.m_WrOVL.readField("hEvent");
                    this.m_WrOVL = null;
                    if (h != null && !h.equals(WinAPI.NULL) && !h.equals(WinAPI.INVALID_HANDLE_VALUE)) {
                        WinAPI.CloseHandle(h);
                    }
                }
                this.waitUnlock();
                h = (WinAPI.HANDLE)this.m_SelOVL.readField("hEvent");
                this.m_SelOVL = null;
                if (h != null && !h.equals(WinAPI.NULL) && !h.equals(WinAPI.INVALID_HANDLE_VALUE)) {
                    WinAPI.CloseHandle(h);
                }
                if (this.m_Comm != null && this.m_Comm != WinAPI.NULL && this.m_Comm != WinAPI.INVALID_HANDLE_VALUE) {
                    WinAPI.CloseHandle(this.m_Comm);
                }
                this.m_Comm = null;
            }
        }
    }
}

