/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import nl.lxtreme.ols.util.HostUtils;

public final class SpringLayoutUtils {
    public static final String SEPARATOR = "SEPARATOR";
    private static Color selectionColor = null;

    private SpringLayoutUtils() {
    }

    public static final Container addSeparator(Container aContainer, String aText) {
        Color color = SpringLayoutUtils.getSeparatorForegroundColor();
        JLabel label = new JLabel(aText);
        label.setAlignmentY(1.0f);
        label.setForeground(color);
        label.setFont(label.getFont().deriveFont(1));
        label.setHorizontalAlignment(4);
        SpringLayoutUtils.setSeparatorProperty(label);
        JSeparator separator = new JSeparator();
        separator.setAlignmentY(HostUtils.getHostInfo().isMacOS() ? 0.25f : 0.5f);
        SpringLayoutUtils.setSeparatorProperty(separator);
        aContainer.add(label);
        aContainer.add(separator);
        return aContainer;
    }

    public static void addToConstraint(SpringLayout.Constraints aConstraints, String aEdgeName, int aConstant) {
        aConstraints.setConstraint(aEdgeName, Spring.sum(aConstraints.getConstraint(aEdgeName), Spring.constant(aConstant)));
    }

    public static void makeCompactGrid(Container aContainer, int aRows, int aCols, int aInitialX, int aInitialY, int aXpad, int aYpad) {
        if (!(aContainer.getLayout() instanceof SpringLayout)) {
            throw new IllegalArgumentException("Container should have SpringLayout as layout manager!");
        }
        SpringLayout layout = (SpringLayout)aContainer.getLayout();
        Spring x = Spring.constant(aInitialX);
        for (int c = 0; c < aCols; ++c) {
            int r;
            Spring width = Spring.constant(0);
            for (r = 0; r < aRows; ++r) {
                width = Spring.max(width, SpringLayoutUtils.getConstraintsForCell(aContainer, aCols, r, c).getWidth());
            }
            for (r = 0; r < aRows; ++r) {
                SpringLayout.Constraints constraints = SpringLayoutUtils.getConstraintsForCell(aContainer, aCols, r, c);
                constraints.setX(x);
                constraints.setWidth(width);
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(aXpad)));
        }
        Spring y = Spring.constant(aInitialY);
        for (int r = 0; r < aRows; ++r) {
            int c;
            Spring height = Spring.constant(0);
            for (c = 0; c < aCols; ++c) {
                height = Spring.max(height, SpringLayoutUtils.getConstraintsForCell(aContainer, aCols, r, c).getHeight());
            }
            for (c = 0; c < aCols; ++c) {
                SpringLayout.Constraints constraints = SpringLayoutUtils.getConstraintsForCell(aContainer, aCols, r, c);
                constraints.setHeight(height);
                constraints.setY(y);
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(aYpad)));
        }
        SpringLayout.Constraints pCons = layout.getConstraints(aContainer);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }

    public static void makeEditorGrid(Container aContainer, int aInitialX, int aInitialY) {
        if (!(aContainer.getLayout() instanceof SpringLayout)) {
            throw new IllegalArgumentException("Container should have SpringLayout as layout manager!");
        }
        int xPad = 6;
        int yPad = 6;
        int columns = 2;
        int rows = aContainer.getComponentCount() / 2;
        SpringLayout layout = (SpringLayout)aContainer.getLayout();
        Spring x = Spring.constant(aInitialX);
        for (int c = 0; c < 2; ++c) {
            int r;
            Spring width = Spring.constant(0);
            for (r = 0; r < rows; ++r) {
                width = Spring.max(width, SpringLayoutUtils.getConstraintsForCell(aContainer, 2, r, c).getWidth());
            }
            for (r = 0; r < rows; ++r) {
                SpringLayout.Constraints constraints = SpringLayoutUtils.getConstraintsForCell(aContainer, 2, r, c);
                constraints.setX(x);
                constraints.setWidth(width);
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(6)));
        }
        Spring y = Spring.constant(aInitialY);
        for (int r = 0; r < rows; ++r) {
            int c;
            Spring height = Spring.constant(0);
            for (c = 0; c < 2; ++c) {
                height = Spring.max(height, SpringLayoutUtils.getConstraintsForCell(aContainer, 2, r, c).getHeight());
            }
            for (c = 0; c < 2; ++c) {
                float vAlignment;
                SpringLayout.Constraints constraints = SpringLayoutUtils.getConstraintsForCell(aContainer, 2, r, c);
                Component component = SpringLayoutUtils.getCellComponent(aContainer, 2, r, c);
                constraints.setHeight(height);
                Spring actualY = y;
                if (SpringLayoutUtils.isSeparatorComponent(component) && (double)(vAlignment = component.getAlignmentY()) > 0.0 && (double)vAlignment < 1.0) {
                    int vOffset = (int)((float)height.getValue() * component.getAlignmentY());
                    actualY = Spring.sum(y, Spring.constant(vOffset));
                }
                constraints.setY(actualY);
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(6)));
        }
        SpringLayout.Constraints parentConstraints = layout.getConstraints(aContainer);
        parentConstraints.setConstraint("South", y);
        parentConstraints.setConstraint("East", x);
    }

    public static void makeGrid(Container aContainer, int aRows, int aCols, int aInitialX, int aInitialY, int aXpad, int aYpad) {
        SpringLayout.Constraints cons;
        int i;
        if (!(aContainer.getLayout() instanceof SpringLayout)) {
            throw new IllegalArgumentException("Container should have SpringLayout as layout manager!");
        }
        SpringLayout layout = (SpringLayout)aContainer.getLayout();
        Spring xPadSpring = Spring.constant(aXpad);
        Spring yPadSpring = Spring.constant(aYpad);
        Spring initialXSpring = Spring.constant(aInitialX);
        Spring initialYSpring = Spring.constant(aInitialY);
        int max = aRows * aCols;
        Spring maxWidthSpring = layout.getConstraints(aContainer.getComponent(0)).getWidth();
        Spring maxHeightSpring = layout.getConstraints(aContainer.getComponent(0)).getWidth();
        for (i = 1; i < max; ++i) {
            cons = layout.getConstraints(aContainer.getComponent(i));
            maxWidthSpring = Spring.max(maxWidthSpring, cons.getWidth());
            maxHeightSpring = Spring.max(maxHeightSpring, cons.getHeight());
        }
        for (i = 0; i < max; ++i) {
            cons = layout.getConstraints(aContainer.getComponent(i));
            cons.setWidth(maxWidthSpring);
            cons.setHeight(maxHeightSpring);
        }
        SpringLayout.Constraints lastCons = null;
        SpringLayout.Constraints lastRowCons = null;
        for (int i2 = 0; i2 < max; ++i2) {
            SpringLayout.Constraints cons2 = layout.getConstraints(aContainer.getComponent(i2));
            if (i2 % aCols == 0) {
                lastRowCons = lastCons;
                cons2.setX(initialXSpring);
            } else {
                cons2.setX(Spring.sum(lastCons.getConstraint("East"), xPadSpring));
            }
            if (i2 / aCols == 0) {
                cons2.setY(initialYSpring);
            } else {
                cons2.setY(Spring.sum(lastRowCons.getConstraint("South"), yPadSpring));
            }
            lastCons = cons2;
        }
        SpringLayout.Constraints pCons = layout.getConstraints(aContainer);
        pCons.setConstraint("South", Spring.sum(Spring.constant(aYpad), lastCons.getConstraint("South")));
        pCons.setConstraint("East", Spring.sum(Spring.constant(aXpad), lastCons.getConstraint("East")));
    }

    public static JComponent setSeparatorProperty(JComponent aComponent) {
        aComponent.putClientProperty(SEPARATOR, Boolean.TRUE);
        return aComponent;
    }

    private static Component getCellComponent(Container aContainer, int aCols, int aRow, int aCol) {
        return aContainer.getComponent(aRow * aCols + aCol);
    }

    private static SpringLayout.Constraints getConstraintsForCell(Container aContainer, int aCols, int aRow, int aCol) {
        if (!(aContainer.getLayout() instanceof SpringLayout)) {
            throw new IllegalArgumentException("Container should have SpringLayout as layout manager!");
        }
        SpringLayout layout = (SpringLayout)aContainer.getLayout();
        Component c = SpringLayoutUtils.getCellComponent(aContainer, aCols, aRow, aCol);
        return layout.getConstraints(c);
    }

    private static Color getSeparatorForegroundColor() {
        if (selectionColor == null && (selectionColor = HostUtils.getHostInfo().isMacOS() ? UIManager.getColor("List.selectionBackground") : UIManager.getColor("MenuItem.selectionBackground")) == null) {
            selectionColor = Color.BLUE;
        }
        return selectionColor;
    }

    private static boolean isSeparatorComponent(Component aComponent) {
        if (!(aComponent instanceof JComponent)) {
            return false;
        }
        JComponent comp = (JComponent)aComponent;
        Object property = comp.getClientProperty(SEPARATOR);
        return Boolean.TRUE.equals(property);
    }
}

