/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public final class Frequency<TYPE extends Comparable<TYPE>> {
    private final ConcurrentNavigableMap<TYPE, Long> distribution;

    public Frequency() {
        this.distribution = new ConcurrentSkipListMap<TYPE, Long>();
    }

    public Frequency(Comparator<TYPE> aComparator) {
        if (aComparator == null) {
            throw new IllegalArgumentException("Comparator cannot be null!");
        }
        this.distribution = new ConcurrentSkipListMap<TYPE, Long>(aComparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValue(TYPE aValue) {
        if (aValue == null) {
            throw new IllegalArgumentException("Value cannot be null!");
        }
        ConcurrentNavigableMap<TYPE, Long> concurrentNavigableMap = this.distribution;
        synchronized (concurrentNavigableMap) {
            Long count = (Long)this.distribution.get(aValue);
            count = count == null ? Long.valueOf(1L) : Long.valueOf(count + 1L);
            this.distribution.put(aValue, count);
        }
    }

    public void clear() {
        this.distribution.clear();
    }

    public long getCount(TYPE aValue) {
        if (aValue == null) {
            throw new IllegalArgumentException("Value cannot be null!");
        }
        long result = 0L;
        Long count = (Long)this.distribution.get(aValue);
        if (count != null) {
            result = count;
        }
        return result;
    }

    public TYPE getHighestRanked() {
        Comparable result = null;
        Long rank = null;
        for (Map.Entry entry : this.distribution.entrySet()) {
            if (rank != null && rank.compareTo((Long)entry.getValue()) >= 0) continue;
            rank = (Long)entry.getValue();
            result = (Comparable)entry.getKey();
        }
        return (TYPE)result;
    }

    public TYPE getLowestRanked() {
        Comparable result = null;
        Long rank = null;
        for (Map.Entry entry : this.distribution.entrySet()) {
            if (rank != null && rank.compareTo((Long)entry.getValue()) <= 0) continue;
            rank = (Long)entry.getValue();
            result = (Comparable)entry.getKey();
        }
        return (TYPE)result;
    }

    public long getTotalCount() {
        long totalCount = 0L;
        for (Long count : this.distribution.values()) {
            if (count == null) continue;
            totalCount += count.longValue();
        }
        return totalCount;
    }

    public int getUniqueValueCount() {
        int size = 0;
        size = this.distribution.keySet().size();
        return size;
    }

    public Iterable<TYPE> values() {
        ArrayList result = new ArrayList();
        result.addAll(this.distribution.keySet());
        Collections.sort(result);
        return result;
    }
}

