/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.project.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.api.data.Channel;
import nl.lxtreme.ols.api.data.DataSet;
import nl.lxtreme.ols.api.data.project.Project;
import nl.lxtreme.ols.api.data.project.ProjectManager;
import nl.lxtreme.ols.api.data.project.ProjectVisitor;
import nl.lxtreme.ols.client.project.impl.ProjectImpl;
import nl.lxtreme.ols.client.project.impl.ProjectProperties;
import nl.lxtreme.ols.client.project.impl.UserSettingsImpl;
import nl.lxtreme.ols.util.HostProperties;
import nl.lxtreme.ols.util.HostUtils;

public class ProjectManagerImpl
implements PropertyChangeListener,
ProjectManager,
ProjectProperties {
    private static final String FILENAME_PROJECT_METADATA = "ols.project";
    private static final String FILENAME_CHANNEL_LABELS = "channel.labels";
    private static final String FILENAME_PROJECT_SETTINGS = "settings/";
    private static final String FILENAME_CAPTURE_RESULTS = "data.ols";
    private volatile HostProperties hostProperties;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ProjectImpl project;

    public ProjectManagerImpl() {
        this.setProject(new ProjectImpl());
    }

    public void addPropertyChangeListener(PropertyChangeListener aListener) {
        this.propertyChangeSupport.addPropertyChangeListener(aListener);
    }

    public Project createNewProject() {
        this.setProject(new ProjectImpl());
        return this.project;
    }

    public Project createTemporaryProject() {
        return new ProjectImpl();
    }

    public Project getCurrentProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProject(InputStream aInput) throws IOException {
        if (aInput == null) {
            throw new IllegalArgumentException("Input stream cannot be null!");
        }
        BufferedInputStream in = new BufferedInputStream(aInput);
        ZipInputStream zipIS = new ZipInputStream(in);
        ProjectImpl newProject = new ProjectImpl();
        this.copyPropertyChangeListeners(this.project, newProject);
        List<String> labels = null;
        try {
            ZipEntry ze = null;
            boolean entriesSeen = false;
            while ((ze = zipIS.getNextEntry()) != null) {
                String name = ze.getName();
                if (FILENAME_PROJECT_METADATA.equals(name)) {
                    this.loadProjectMetadata(newProject, zipIS);
                    entriesSeen = true;
                } else if (FILENAME_CHANNEL_LABELS.equals(name)) {
                    labels = this.loadChannelLabels(zipIS);
                    entriesSeen = true;
                } else if (FILENAME_CAPTURE_RESULTS.equals(name)) {
                    this.loadCapturedResults(newProject, zipIS);
                    entriesSeen = true;
                } else if (name.startsWith(FILENAME_PROJECT_SETTINGS)) {
                    String userSettingsName = name.substring(FILENAME_PROJECT_SETTINGS.length());
                    this.loadProjectSettings(newProject, userSettingsName, zipIS);
                    entriesSeen = true;
                }
                zipIS.closeEntry();
            }
            if (!entriesSeen) {
                throw new IOException("Invalid project file!");
            }
            newProject.getDataSet().mergeChannelLabels(labels);
            newProject.setChanged(false);
            this.setProject(newProject);
        }
        finally {
            HostUtils.closeResource((Closeable)zipIS);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent aEvent) {
        this.propertyChangeSupport.firePropertyChange(aEvent);
    }

    public void removePropertyChangeListener(PropertyChangeListener aListener) {
        this.propertyChangeSupport.removePropertyChangeListener(aListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProject(OutputStream aOutput) throws IOException {
        if (aOutput == null) {
            throw new IllegalArgumentException("Output stream cannot be null!");
        }
        BufferedOutputStream os = new BufferedOutputStream(aOutput);
        ZipOutputStream zipOS = new ZipOutputStream(os);
        zipOS.setComment(this.hostProperties.getFullName().concat(" project file"));
        try {
            this.storeProjectMetadata(this.project, zipOS);
            this.storeChannelLabels(this.project.getDataSet(), zipOS);
            this.storeProjectSettings(this.project, zipOS);
            this.storeCapturedResults(this.project, zipOS);
            this.project.setChanged(false);
        }
        finally {
            HostUtils.closeResource((Closeable)zipOS);
            HostUtils.closeResource((Closeable)os);
        }
    }

    public void setHostProperties(HostProperties aHostProperties) {
        this.hostProperties = aHostProperties;
    }

    protected void loadCapturedResults(Project aProject, ZipInputStream aZipIS) throws IOException {
        aProject.readData((Reader)new InputStreamReader(aZipIS));
    }

    protected List<String> loadChannelLabels(ZipInputStream aZipIS) throws IOException {
        InputStreamReader isReader = new InputStreamReader(aZipIS);
        BufferedReader reader = new BufferedReader(isReader);
        ArrayList<String> result = new ArrayList<String>();
        String label = null;
        int idx = 0;
        while ((label = reader.readLine()) != null && idx < 32) {
            result.add(label);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProjectMetadata(Project aProject, ZipInputStream aZipIS) throws IOException {
        InputStreamReader isReader = new InputStreamReader(aZipIS);
        BufferedReader reader = new BufferedReader(isReader);
        String name = null;
        String version = null;
        Date savedAt = null;
        try {
            name = reader.readLine();
            version = reader.readLine();
            savedAt = new Date(Long.valueOf(reader.readLine()));
        }
        catch (Throwable throwable) {
            aProject.setName(name);
            aProject.setSourceVersion(version);
            aProject.setLastModified(savedAt);
            throw throwable;
        }
        aProject.setName(name);
        aProject.setSourceVersion(version);
        aProject.setLastModified(savedAt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProjectSettings(ProjectImpl aProject, String aUserSettingsName, ZipInputStream aZipIS) throws IOException {
        Properties settings = new Properties();
        try {
            settings.load(aZipIS);
        }
        finally {
            UserSettingsImpl userSettings = new UserSettingsImpl(aUserSettingsName, settings);
            aProject.setSettings(userSettings);
        }
    }

    protected void storeCapturedResults(Project aProject, ZipOutputStream aZipOS) throws IOException {
        DataSet dataSet = aProject.getDataSet();
        if (dataSet.getCapturedData() == null) {
            return;
        }
        ZipEntry zipEntry = new ZipEntry(FILENAME_CAPTURE_RESULTS);
        aZipOS.putNextEntry(zipEntry);
        aProject.writeData((Writer)new OutputStreamWriter(aZipOS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeChannelLabels(DataSet aDataSet, ZipOutputStream aZipOS) throws IOException {
        Channel[] channels = aDataSet.getChannels();
        ZipEntry zipEntry = new ZipEntry(FILENAME_CHANNEL_LABELS);
        aZipOS.putNextEntry(zipEntry);
        PrintStream out = new PrintStream(aZipOS);
        try {
            for (Channel channel : channels) {
                out.println(channel != null && channel.hasName() ? channel.getLabel() : "");
            }
        }
        finally {
            out.flush();
            out = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeProjectMetadata(Project aProject, ZipOutputStream aZipOS) throws IOException {
        String name = aProject.getName();
        if (name == null || name.trim().isEmpty()) {
            return;
        }
        ZipEntry zipEntry = new ZipEntry(FILENAME_PROJECT_METADATA);
        aZipOS.putNextEntry(zipEntry);
        PrintStream out = new PrintStream(aZipOS);
        try {
            out.println(name);
            out.println(this.hostProperties.getVersion());
            out.println(System.currentTimeMillis());
        }
        finally {
            out.flush();
            out = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeProjectSettings(ProjectImpl aProject, final ZipOutputStream aZipOS) throws IOException {
        try {
            aProject.visit(new ProjectVisitor(){

                public void visit(UserSettings aSettings) throws IOException {
                    String zipEntryName = ProjectManagerImpl.FILENAME_PROJECT_SETTINGS.concat(aSettings.getName());
                    ZipEntry zipEntry = new ZipEntry(zipEntryName);
                    aZipOS.putNextEntry(zipEntry);
                    Properties props = new Properties();
                    for (Map.Entry userSetting : aSettings) {
                        props.put(userSetting.getKey(), userSetting.getValue());
                    }
                    props.store(aZipOS, aSettings.getName().concat(" settings"));
                }
            });
        }
        finally {
            aZipOS.flush();
        }
    }

    private void copyPropertyChangeListeners(ProjectImpl aSource, ProjectImpl aTarget) {
        PropertyChangeListener[] listeners;
        for (PropertyChangeListener listener : listeners = aSource.getPropertyChangeListeners()) {
            aTarget.addPropertyChangeListener(listener);
        }
    }

    private void setProject(ProjectImpl aProject) {
        ProjectImpl oldProject = this.project;
        if (oldProject != null) {
            oldProject.removePropertyChangeListener(this);
        }
        this.project = aProject;
        this.project.addPropertyChangeListener(this);
        this.propertyChangeSupport.firePropertyChange("project", oldProject, this.project);
    }
}

