/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.export.image;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import nl.lxtreme.ols.api.data.DataSet;
import nl.lxtreme.ols.api.data.export.Exporter;

public class ImageExporter
implements Exporter {
    private static final int MAX_WIDTH = 8192;
    private static final int MAX_HEIGHT = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(DataSet aDataSet, JComponent aComponent, OutputStream aStream) throws IOException {
        Dimension dims = this.getExportSize(aComponent);
        BufferedImage image = new BufferedImage(dims.width, dims.height, 1);
        Graphics2D g2d = image.createGraphics();
        try {
            this.paintDiagram(g2d, aComponent);
        }
        finally {
            g2d.dispose();
            g2d = null;
        }
        if (!ImageIO.write((RenderedImage)image, "png", aStream)) {
            throw new IOException("Export to PNG failed! Image not supported?");
        }
    }

    public String[] getFilenameExtentions() {
        return new String[]{"png"};
    }

    public String getName() {
        return "PNG Image";
    }

    private Dimension getExportSize(JComponent aDiagram) {
        Dimension dims = this.getImageSize(aDiagram);
        int width = Math.min(dims.width, 8192);
        int height = Math.min(dims.height, 8192);
        return new Dimension(width, height);
    }

    private Dimension getImageSize(JComponent aDiagram) {
        if (aDiagram instanceof JScrollPane) {
            JScrollPane scrollpane = (JScrollPane)aDiagram;
            Dimension visibleViewSize = scrollpane.getViewport().getExtentSize();
            Dimension viewSize = scrollpane.getViewport().getViewSize();
            Dimension rowHeaderSize = scrollpane.getRowHeader().getExtentSize();
            Dimension columnHeaderSize = scrollpane.getColumnHeader().getExtentSize();
            int width = Math.min(viewSize.width, visibleViewSize.width) + rowHeaderSize.width;
            int height = Math.min(viewSize.height, visibleViewSize.height) + columnHeaderSize.height;
            return new Dimension(width, height);
        }
        return aDiagram.getSize();
    }

    private void paintDiagram(Graphics2D aCanvas, JComponent aDiagram) {
        Insets insets;
        Border border = aDiagram.getBorder();
        if (border != null && (insets = border.getBorderInsets(aDiagram)) != null) {
            aCanvas.translate(-insets.left, -insets.top);
        }
        aDiagram.paint(aCanvas);
    }
}

