/*
 * Decompiled with CFR 0.152.
 */
package org.sump.device.logicsniffer;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.io.StreamConnection;
import nl.lxtreme.ols.api.acquisition.AcquisitionProgressListener;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.CapturedData;
import nl.lxtreme.ols.api.devices.AcquisitionTask;
import nl.lxtreme.ols.util.HostUtils;
import org.sump.device.logicsniffer.LogicSnifferConfig;
import org.sump.device.logicsniffer.profile.DeviceProfileManager;
import org.sump.device.logicsniffer.protocol.SumpCommandWriter;
import org.sump.device.logicsniffer.protocol.SumpProtocolConstants;
import org.sump.device.logicsniffer.protocol.SumpResultReader;
import org.sump.device.logicsniffer.sampleprocessor.EqualityFilter;
import org.sump.device.logicsniffer.sampleprocessor.RleDecoder;
import org.sump.device.logicsniffer.sampleprocessor.SampleProcessor;
import org.sump.device.logicsniffer.sampleprocessor.SampleProcessorCallback;

public class LogicSnifferAcquisitionTask
implements SumpProtocolConstants,
AcquisitionTask {
    private static final Logger LOG = Logger.getLogger(LogicSnifferAcquisitionTask.class.getName());
    private final DeviceProfileManager deviceProfileManager;
    private final AcquisitionProgressListener acquisitionProgressListener;
    private final LogicSnifferConfig config;
    private StreamConnection connection;
    private SumpResultReader inputStream;
    private SumpCommandWriter outputStream;
    private int trigcount;

    public LogicSnifferAcquisitionTask(LogicSnifferConfig aConfig, StreamConnection aConnection, DeviceProfileManager aDeviceProfileManager, AcquisitionProgressListener aProgressListener) {
        this.config = aConfig;
        this.connection = aConnection;
        this.deviceProfileManager = aDeviceProfileManager;
        this.acquisitionProgressListener = aProgressListener;
    }

    public AcquisitionResult call() throws IOException, InterruptedException {
        LOG.info("Starting capture ...");
        this.open();
        this.detectDevice();
        int channelCount = this.config.getChannelCount();
        if (channelCount <= 0) {
            throw new InternalError("Internal error: did not obtain correct number of channels (" + channelCount + ")?!");
        }
        int sampleCount = this.config.getSampleCount();
        if (sampleCount <= 0) {
            throw new InternalError("Internal error: did not obtain correct number of samples (" + sampleCount + ")?!");
        }
        this.configureAndArmDevice();
        int[] buffer = new int[sampleCount];
        int sampleIdx = this.awaitTrigger(buffer);
        if (LOG.isLoggable(Level.FINE) && sampleIdx < sampleCount) {
            LOG.log(Level.FINE, "Trigger(s) fired! Reading {0} samples of {1} bytes ...", new Object[]{sampleCount, this.config.getEnabledGroupCount()});
        }
        sampleIdx = this.readSamples(sampleIdx, buffer);
        LOG.log(Level.FINE, "{0} samples read. Starting post processing...", sampleCount - sampleIdx - 1);
        final ArrayList values = new ArrayList();
        final ArrayList timestamps = new ArrayList();
        final long[] absoluteLength = new long[]{0L};
        final long[] triggerPos = new long[]{-1L};
        int rate = this.config.getSampleRate();
        SampleProcessorCallback callback = new SampleProcessorCallback(){

            @Override
            public void addValue(int aSampleValue, long aTimestamp) {
                values.add(aSampleValue);
                timestamps.add(aTimestamp);
            }

            @Override
            public void ready(long aAbsoluteLength, long aTriggerPosition) {
                absoluteLength[0] = aAbsoluteLength;
                if (LogicSnifferAcquisitionTask.this.config.isTriggerEnabled()) {
                    triggerPos[0] = aTriggerPosition;
                }
            }
        };
        this.createSampleProcessor(sampleCount, buffer, callback).process();
        this.close();
        return new CapturedData(values, timestamps, triggerPos[0], rate, this.config.getEnabledChannelsCount(), this.config.getEnabledChannelsMask(), absoluteLength[0]);
    }

    void configureAndArmDevice() throws IOException {
        this.trigcount = this.outputStream.writeDeviceConfiguration();
        this.outputStream.writeCmdRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void close() {
        StreamConnection conn = this.getStreamConnection();
        if (conn == null) return;
        try {
            if (this.outputStream == null) return;
            this.outputStream.writeCmdReset();
            return;
        }
        catch (IOException exception) {
            if (HostUtils.handleInterruptedException((Throwable)exception)) return;
            LOG.log(Level.WARNING, "Detaching failed!", exception);
            return;
        }
        finally {
            HostUtils.closeResource((Closeable)this.outputStream);
            HostUtils.closeResource((Closeable)this.inputStream);
            try {
                conn.close();
            }
            catch (IOException exception) {
                LOG.log(Level.WARNING, "Closing connection failed!", exception);
            }
            finally {
                this.connection = null;
                this.outputStream = null;
                this.inputStream = null;
            }
        }
    }

    protected final LogicSnifferConfig getConfig() {
        return this.config;
    }

    protected DeviceProfileManager getDeviceProfileManager() {
        return this.deviceProfileManager;
    }

    protected StreamConnection getStreamConnection() {
        return this.connection;
    }

    protected void open() throws IOException {
        block3: {
            StreamConnection conn = this.getStreamConnection();
            try {
                if (conn == null) {
                    throw new IOException("Failed to open a valid connection!");
                }
                this.outputStream = new SumpCommandWriter(this.config, conn.openDataOutputStream());
                this.inputStream = new SumpResultReader(this.config, conn.openDataInputStream());
                this.inputStream.flush();
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Failed to open connection! Possible reason: " + exception.getMessage());
                LOG.log(Level.FINE, "Detailed stack trace:", exception);
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block3;
                throw new IOException("Failed to open connection! Possible reason: " + exception.getMessage());
            }
        }
    }

    private int awaitTrigger(int[] aBuffer) throws IOException, InterruptedException {
        int sampleIdx = aBuffer.length - 1;
        boolean waiting = sampleIdx >= 0;
        LOG.log(Level.FINE, "Awaiting trigger ...");
        while (waiting && !Thread.currentThread().isInterrupted()) {
            try {
                aBuffer[sampleIdx] = this.inputStream.readSample();
                --sampleIdx;
                waiting = false;
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) continue;
                throw exception;
            }
        }
        return sampleIdx;
    }

    private SampleProcessor createSampleProcessor(int aSampleCount, int[] aSampleValues, SampleProcessorCallback aCallback) {
        SampleProcessor processor;
        if (this.config.isRleEnabled()) {
            LOG.log(Level.INFO, "Decoding Run Length Encoded data, sample count: {0}", aSampleCount);
            processor = new RleDecoder(this.config, aSampleValues, this.trigcount, aCallback);
        } else {
            LOG.log(Level.INFO, "Decoding unencoded data, sample count: {0}", aSampleCount);
            processor = new EqualityFilter(this.config, aSampleValues, this.trigcount, aCallback);
        }
        return processor;
    }

    private void detectDevice() throws IOException {
        int tries = 3;
        int id = -1;
        do {
            this.inputStream.flush();
            this.outputStream.writeCmdReset();
            this.outputStream.writeCmdGetId();
            try {
                id = this.inputStream.readDeviceId();
            }
            catch (EOFException exception) {
                id = -1;
                tries = -1;
            }
            catch (IOException exception) {
                id = -1;
                if (HostUtils.handleInterruptedException((Throwable)exception)) continue;
                LOG.log(Level.INFO, "I/O exception!", exception);
            }
        } while (!Thread.currentThread().isInterrupted() && tries-- > 0 && id < 0);
        if (id == 809585747) {
            throw new IOException("Device is obsolete. Please upgrade firmware.");
        }
        if (id != 826362963) {
            throw new IOException("Device not found!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readSamples(int aSampleIdx, int[] aBuffer) throws IOException, InterruptedException {
        try {
            while (aSampleIdx >= 0 && !Thread.currentThread().isInterrupted()) {
                aBuffer[aSampleIdx] = this.inputStream.readSample();
                int percentage = (int)(100.0 - 100.0 * (double)aSampleIdx / (double)aBuffer.length);
                this.acquisitionProgressListener.acquisitionInProgress(percentage);
                --aSampleIdx;
            }
        }
        catch (IOException exception) {
            this.outputStream.writeCmdReset();
            if (!HostUtils.handleInterruptedException((Throwable)exception)) {
                throw exception;
            }
        }
        finally {
            this.acquisitionProgressListener.acquisitionInProgress(100);
        }
        if (this.config.isSamplesInReverseOrder()) {
            HostUtils.reverse((int[])aBuffer);
        }
        return aSampleIdx;
    }
}

